/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.window.Geometry_desktopKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WindowLocationTracker {
    @NotNull
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    @NotNull
    private static final Point cascadeOffset = new Point(48, 48);
    @NotNull
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    @NotNull
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        public void windowGainedFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(e.getWindow());
            Set set = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = e.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            set.add(window);
        }

        public void windowLostFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };
    public static final int $stable = 8;

    private WindowLocationTracker() {
    }

    public final void onWindowCreated(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.addWindowFocusListener(focusListener);
    }

    public final void onWindowDisposed(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(window);
    }

    @Nullable
    public final GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        return window != null ? window.getGraphicsConfiguration() : null;
    }

    @NotNull
    public final Point getCascadeLocationFor(@NotNull Window window) {
        Point point;
        Object graphicsConfiguration;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Window lastWindow = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object = lastWindow;
        if (object == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if ((graphicsConfiguration = object) != null) {
            Rectangle screenBounds = ((GraphicsConfiguration)graphicsConfiguration).getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration);
            Intrinsics.checkNotNull((Object)screenBounds);
            Point screenLeftTop = Geometry_desktopKt.plus(Geometry_desktopKt.getLeftTop(screenBounds), new Point(screenInsets.left, screenInsets.top));
            Point screenRightBottom = Geometry_desktopKt.minus(Geometry_desktopKt.getRightBottom(screenBounds), new Point(screenInsets.right, screenInsets.bottom));
            Serializable serializable = lastWindow;
            if (serializable == null || (serializable = serializable.getLocation()) == null) {
                serializable = screenLeftTop;
            }
            Serializable lastLocation = serializable;
            Point location2 = Geometry_desktopKt.plus((Point)lastLocation, cascadeOffset);
            Dimension dimension = window.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
            Point rightBottom = Geometry_desktopKt.plus(location2, Geometry_desktopKt.getRightBottom(dimension));
            if (rightBottom.x > screenRightBottom.x || rightBottom.y > screenRightBottom.y) {
                location2 = Geometry_desktopKt.plus(screenLeftTop, cascadeOffset);
            }
            point = location2;
        } else {
            point = cascadeOffset;
        }
        return point;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

