/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.GlobalPositionAwareModifierNode;
import androidx.compose.ui.node.LayoutAwareModifierNode;
import androidx.compose.ui.node.OnUnplacedModifierNode;
import androidx.compose.ui.node.TraversableNode;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrackInteropPlacementModifierNode
extends Modifier.Node
implements GlobalPositionAwareModifierNode,
LayoutAwareModifierNode,
OnUnplacedModifierNode,
TraversableNode {
    @Nullable
    private InteropViewHolder interopViewHolder;
    private boolean isPlaced;
    @NotNull
    private final String traverseKey;
    public static final int $stable = 8;

    public TrackInteropPlacementModifierNode(@Nullable InteropViewHolder interopViewHolder) {
        this.interopViewHolder = interopViewHolder;
        this.traverseKey = "androidx.compose.ui.node.TRACK_INTEROP_TRAVERSAL_NODE_KEY";
    }

    @Nullable
    public final InteropViewHolder getInteropViewHolder() {
        return this.interopViewHolder;
    }

    @Override
    @NotNull
    public String getTraverseKey() {
        return this.traverseKey;
    }

    @Override
    public void onPlaced(@NotNull LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        InteropViewHolder interopViewHolder = this.interopViewHolder;
        if (interopViewHolder != null) {
            interopViewHolder.place();
        }
        this.isPlaced = true;
    }

    @Override
    public void onUnplaced() {
        InteropViewHolder interopViewHolder = this.interopViewHolder;
        if (interopViewHolder != null) {
            interopViewHolder.unplace();
        }
        this.isPlaced = false;
    }

    @Override
    public void onGloballyPositioned(@NotNull LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        if (!this.isPlaced) {
            this.onPlaced(coordinates);
        }
    }

    @Override
    public void onDetach() {
        if (this.isPlaced) {
            this.onUnplaced();
        }
        super.onDetach();
    }
}

