/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropContainer_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.ScheduledUpdatesSwapchain;
import androidx.compose.ui.viewinterop.TrackInteropPlacementModifierNode;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipRectangle;

@SourceDebugExtension(value={"SMAP\nSwingInteropContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n+ 2 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain\n*L\n1#1,282:1\n60#2,16:283\n*S KotlinDebug\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n*L\n250#1:283,16\n*E\n"})
public final class SwingInteropContainer
implements InteropContainer {
    @NotNull
    private final Container root;
    private boolean placeInteropAbove;
    @NotNull
    private Map<Container, InteropViewHolder> interopComponents;
    @Nullable
    private TrackInteropPlacementModifierNode rootModifier;
    @NotNull
    private final SnapshotStateObserver snapshotObserver;
    @NotNull
    private final ScheduledUpdatesSwapchain scheduledUpdatesSwapchain;
    public static final int $stable = 8;

    public SwingInteropContainer(@NotNull Container root, boolean placeInteropAbove, @NotNull Function0<Unit> requestRedraw) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(requestRedraw, (String)"requestRedraw");
        this.root = root;
        this.placeInteropAbove = placeInteropAbove;
        this.interopComponents = new LinkedHashMap();
        this.snapshotObserver = new SnapshotStateObserver((Function1<? super Function0<Unit>, Unit>)((Function1)SwingInteropContainer::snapshotObserver$lambda$0));
        this.scheduledUpdatesSwapchain = new ScheduledUpdatesSwapchain(requestRedraw);
    }

    @NotNull
    public Container getRoot() {
        return this.root;
    }

    public final void setPlaceInteropAbove(boolean value2) {
        if (this.placeInteropAbove != value2) {
            this.placeInteropAbove = value2;
            this.updateInteropComponentsOrder();
        }
    }

    @Override
    @Nullable
    public TrackInteropPlacementModifierNode getRootModifier() {
        return this.rootModifier;
    }

    @Override
    public void setRootModifier(@Nullable TrackInteropPlacementModifierNode trackInteropPlacementModifierNode) {
        this.rootModifier = trackInteropPlacementModifierNode;
    }

    @Override
    @NotNull
    public SnapshotStateObserver getSnapshotObserver() {
        return this.snapshotObserver;
    }

    @Override
    public boolean contains(@NotNull InteropViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return this.interopComponents.containsKey(holder.getGroup());
    }

    private final void updateInteropComponentsOrder() {
        List<InteropViewHolder> orderedInteropComponents = InteropContainer_skikoKt.interopComponentsSortedByDrawOrder(this, this.interopComponents.values());
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.updateInteropComponentsOrder$lambda$2(this, orderedInteropComponents)));
    }

    @Override
    public void place(@NotNull InteropViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Container group = holder.getGroup();
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().start();
        }
        boolean isNewInteropView = this.interopComponents.putIfAbsent(group, holder) == null;
        int interopComponentsCount = this.interopComponents.size();
        int interopComponentsBelowCount = InteropContainer_skikoKt.countInteropComponentsBelow(this, holder);
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.place$lambda$3(interopComponentsCount, this, isNewInteropView, interopComponentsBelowCount, holder)));
    }

    @Override
    public void unplace(@NotNull InteropViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.unplace$lambda$4(holder, this)));
        this.interopComponents.remove(holder.getGroup());
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().stop();
        }
    }

    private final void executeScheduledUpdates() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Check failed.");
        }
        boolean hasAnyUpdates = this.scheduledUpdatesSwapchain.execute();
        if (hasAnyUpdates) {
            this.getRoot().validate();
            this.getRoot().repaint();
        }
    }

    public final void dispose() {
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postponingExecutingScheduledUpdates(@NotNull Function0<Unit> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ScheduledUpdatesSwapchain this_$iv = this.scheduledUpdatesSwapchain;
        boolean $i$f$preventingRedrawRequests = false;
        try {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                boolean $i$a$-synchronized-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$iv22 = false;
                if (!ScheduledUpdatesSwapchain.access$getNeedsRequestRedrawOnUpdateScheduled$p(this_$iv)) {
                    boolean $i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22 = false;
                    String $i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22 = "Reentry into ignoringRedrawRequests is not allowed";
                    throw new IllegalStateException($i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22.toString());
                }
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, false);
                Unit $i$a$-synchronized-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$iv22 = Unit.INSTANCE;
            }
            boolean bl = false;
            body.invoke();
        }
        finally {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                boolean bl = false;
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, true);
                Unit unit = Unit.INSTANCE;
            }
        }
        this.executeScheduledUpdates();
    }

    @Override
    public void scheduleUpdate(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.scheduledUpdatesSwapchain.scheduleUpdate(action2);
    }

    @NotNull
    public final ClipRectangle getClipRectForComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        InteropViewHolder interopViewHolder = this.interopComponents.get(component);
        if (interopViewHolder == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)interopViewHolder, (String)"null cannot be cast to non-null type org.jetbrains.skiko.ClipRectangle");
        return (ClipRectangle)interopViewHolder;
    }

    public final void invoke(@NotNull Function2<? super Composer, ? super Integer, Unit> content2, @Nullable Composer $composer, int $changed) {
        block6: {
            Intrinsics.checkNotNullParameter(content2, (String)"content");
            $composer = $composer.startRestartGroup(-1827244710);
            ComposerKt.sourceInformation($composer, "C(invoke)274@9496L103,272@9411L188:SwingInteropContainer.desktop.kt#z33iqn");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(content2) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= $composer.changedInstance(this) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart(-1827244710, $dirty, -1, "androidx.compose.ui.viewinterop.SwingInteropContainer.invoke (SwingInteropContainer.desktop.kt:271)");
                }
                CompositionLocalKt.CompositionLocalProvider(InteropContainer_skikoKt.getLocalInteropContainer().provides(this), (Function2<? super Composer, ? super Integer, Unit>)((Function2)ComposableLambdaKt.rememberComposableLambda(-1220154854, true, new Function2<Composer, Integer, Unit>(this, content2){
                    final /* synthetic */ SwingInteropContainer this$0;
                    final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                    {
                        this.this$0 = $receiver;
                        this.$content = $content;
                    }

                    public final void invoke(Composer $composer, int $changed) {
                        ComposerKt.sourceInformation($composer, "C275@9510L79:SwingInteropContainer.desktop.kt#z33iqn");
                        if (($changed & 3) != 2 || !$composer.getSkipping()) {
                            if (ComposerKt.isTraceInProgress()) {
                                ComposerKt.traceEventStart(-1220154854, $changed, -1, "androidx.compose.ui.viewinterop.SwingInteropContainer.invoke.<anonymous> (SwingInteropContainer.desktop.kt:275)");
                            }
                            InteropContainer_skikoKt.TrackInteropPlacementContainer(this.this$0, this.$content, $composer, 0);
                            if (ComposerKt.isTraceInProgress()) {
                                ComposerKt.traceEventEnd();
                            }
                        } else {
                            $composer.skipToGroupEnd();
                        }
                    }
                }, $composer, 54)), $composer, 0x30 | ProvidedValue.$stable);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block6;
            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> SwingInteropContainer.invoke$lambda$6(this, content2, $changed, arg_0, arg_1)));
        }
    }

    private static final Unit snapshotObserver$lambda$0(Function0 command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        command2.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit updateInteropComponentsOrder$lambda$2(SwingInteropContainer this$0, List $orderedInteropComponents) {
        int allComponentCount = this$0.getRoot().getComponents().length;
        Iterator iterator2 = ((Iterable)CollectionsKt.asReversed((List)$orderedInteropComponents)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            InteropViewHolder holder = (InteropViewHolder)iterator2.next();
            holder.changeInteropViewIndex(this$0.getRoot(), this$0.placeInteropAbove ? allComponentCount - 1 : index);
        }
        return Unit.INSTANCE;
    }

    private static final Unit place$lambda$3(int $interopComponentsCount, SwingInteropContainer this$0, boolean $isNewInteropView, int $interopComponentsBelowCount, InteropViewHolder $holder) {
        int lastInteropIndex = $interopComponentsCount - 1;
        if (!this$0.placeInteropAbove) {
            int existingInteropComponentCount = $interopComponentsCount - ($isNewInteropView ? 1 : 0);
            lastInteropIndex += this$0.getRoot().getComponentCount() - existingInteropComponentCount;
        }
        int awtIndex = lastInteropIndex - $interopComponentsBelowCount;
        if ($isNewInteropView) {
            $holder.insertInteropView(this$0.getRoot(), awtIndex);
        } else {
            $holder.changeInteropViewIndex(this$0.getRoot(), awtIndex);
        }
        return Unit.INSTANCE;
    }

    private static final Unit unplace$lambda$4(InteropViewHolder $holder, SwingInteropContainer this$0) {
        $holder.removeInteropView(this$0.getRoot());
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$6(SwingInteropContainer $tmp0_rcvr, Function2 $content, int $$changed, Composer $composer, int $force) {
        $tmp0_rcvr.invoke((Function2<? super Composer, ? super Integer, Unit>)$content, $composer, RecomposeScopeImplKt.updateChangedFlags($$changed | 1));
        return Unit.INSTANCE;
    }
}

