/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.style;

import androidx.compose.ui.util.ListUtilsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int mask;
    @NotNull
    private static final TextDecoration None = new TextDecoration(0);
    @NotNull
    private static final TextDecoration Underline = new TextDecoration(1);
    @NotNull
    private static final TextDecoration LineThrough = new TextDecoration(2);

    public TextDecoration(int mask) {
        this.mask = mask;
    }

    public final int getMask() {
        return this.mask;
    }

    public final boolean contains(@NotNull TextDecoration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (this.mask | other.mask) == this.mask;
    }

    @NotNull
    public String toString() {
        if (this.mask == 0) {
            return "TextDecoration.None";
        }
        List values = new ArrayList();
        if ((this.mask & TextDecoration.Underline.mask) != 0) {
            values.add("Underline");
        }
        if ((this.mask & TextDecoration.LineThrough.mask) != 0) {
            values.add("LineThrough");
        }
        if (values.size() == 1) {
            return "TextDecoration." + values.get(0);
        }
        return "TextDecoration[" + ListUtilsKt.fastJoinToString$default(values, ", ", null, null, 0, null, null, 62, null) + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextDecoration)) {
            return false;
        }
        return this.mask == ((TextDecoration)other).mask;
    }

    public int hashCode() {
        return this.mask;
    }

    @SourceDebugExtension(value={"SMAP\nTextDecoration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDecoration.kt\nandroidx/compose/ui/text/style/TextDecoration$Companion\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,103:1\n270#2,2:104\n35#2,5:106\n272#2:111\n*S KotlinDebug\n*F\n+ 1 TextDecoration.kt\nandroidx/compose/ui/text/style/TextDecoration$Companion\n*L\n51#1:104,2\n51#1:106,5\n51#1:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextDecoration getNone() {
            return None;
        }

        @NotNull
        public final TextDecoration getUnderline() {
            return Underline;
        }

        @NotNull
        public final TextDecoration getLineThrough() {
            return LineThrough;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

