/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.paragraph.Paragraph;

public final class SkiaParagraphIntrinsics
implements ParagraphIntrinsics {
    @NotNull
    private final String text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @NotNull
    private final Density density;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    @NotNull
    private final ResolvedTextDirection textDirection;
    @Nullable
    private ParagraphLayouter layouter;
    private float minIntrinsicWidth;
    private float maxIntrinsicWidth;
    public static final int $stable = 8;

    public SkiaParagraphIntrinsics(@NotNull String text2, @NotNull TextStyle style, @NotNull List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.style = style;
        this.annotations = annotations;
        this.placeholders = placeholders;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver;
        this.textDirection = SkiaParagraphIntrinsics_skikoKt.resolveTextDirection-Ikz0yAw(this.text, TextDirection.box-impl(this.style.getTextDirection-s_7X-co()), this.style.getLocaleList());
        this.layouter = this.newLayouter();
        ParagraphLayouter paragraphLayouter = this.layouter;
        Intrinsics.checkNotNull((Object)paragraphLayouter);
        Paragraph para = paragraphLayouter.layoutParagraph(Float.POSITIVE_INFINITY);
        this.minIntrinsicWidth = (float)Math.ceil(para.getMinIntrinsicWidth());
        this.maxIntrinsicWidth = (float)Math.ceil(para.getMaxIntrinsicWidth());
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final ResolvedTextDirection getTextDirection() {
        return this.textDirection;
    }

    @NotNull
    public final ParagraphLayouter layouter() {
        ParagraphLayouter paragraphLayouter = this.layouter;
        if (paragraphLayouter == null) {
            paragraphLayouter = this.newLayouter();
        }
        ParagraphLayouter layouter = paragraphLayouter;
        this.layouter = null;
        return layouter;
    }

    private final ParagraphLayouter newLayouter() {
        return new ParagraphLayouter(this.text, this.textDirection, this.style, this.annotations, this.placeholders, this.density, this.fontFamilyResolver);
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.minIntrinsicWidth;
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.maxIntrinsicWidth;
    }
}

