/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.ParagraphBuilder;
import androidx.compose.ui.text.platform.ParagraphLayouter_skikoKt;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.Paragraph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nParagraphLayouter.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 4 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n646#2:225\n635#2:226\n153#3:227\n57#4:228\n61#4:231\n60#5:229\n70#5:232\n22#6:230\n22#6:233\n1755#7,3:234\n*S KotlinDebug\n*F\n+ 1 ParagraphLayouter.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphLayouter\n*L\n114#1:225\n114#1:226\n130#1:227\n131#1:228\n132#1:231\n131#1:229\n132#1:232\n131#1:230\n132#1:233\n154#1:234,3\n*E\n"})
public final class ParagraphLayouter {
    @NotNull
    private final String text;
    @NotNull
    private final ParagraphBuilder builder;
    @Nullable
    private Paragraph paragraphCache;
    private boolean updateForeground;
    private float width;
    public static final int $stable = 8;

    public ParagraphLayouter(@NotNull String text2, @NotNull ResolvedTextDirection textDirection, @NotNull TextStyle style, @NotNull List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, @NotNull Density density, @NotNull FontFamily.Resolver fontFamilyResolver) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.builder = new ParagraphBuilder(fontFamilyResolver, this.text, style, 0L, null, 0, annotations, placeholders, density, textDirection, null, 0, 3128, null);
        this.width = Float.NaN;
    }

    @NotNull
    public final Font getDefaultFont() {
        return this.builder.getDefaultFont$ui_text();
    }

    @NotNull
    public final TextStyle getTextStyle() {
        return this.builder.getTextStyle();
    }

    private final void invalidateParagraph(boolean onlyForeground) {
        if (onlyForeground && this.builder.getAnnotations().isEmpty()) {
            this.updateForeground = true;
        } else {
            this.paragraphCache = null;
        }
    }

    static /* synthetic */ void invalidateParagraph$default(ParagraphLayouter paragraphLayouter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        paragraphLayouter.invalidateParagraph(bl);
    }

    @NotNull
    public final LineMetrics[] emptyLineMetrics$ui_text(@NotNull Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        return this.builder.emptyLineMetrics$ui_text(paragraph);
    }

    public final void setParagraphStyle(int maxLines, @NotNull String ellipsis) {
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        if (this.builder.getMaxLines() != maxLines || !Intrinsics.areEqual((Object)this.builder.getEllipsis(), (Object)ellipsis)) {
            this.builder.setMaxLines(maxLines);
            this.builder.setEllipsis(ellipsis);
            ParagraphLayouter.invalidateParagraph$default(this, false, 1, null);
        }
    }

    public final void setColor-8_81llA(long color) {
        long l;
        long $this$takeOrElse_u2dDxMtmZc$iv = color;
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != 16L) {
            l = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            boolean bl3 = false;
            l = this.builder.getTextStyle().getColor-0d7_KjU();
        }
        long actualColor = l;
        if (!Color.equals-impl0(this.builder.getTextStyle().getColor-0d7_KjU(), actualColor)) {
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default(this.builder.getTextStyle(), actualColor, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFE, null));
            this.invalidateParagraph(true);
        }
    }

    public final void setBrush-12SF9DM(@Nullable Brush brush, long brushSize, float alpha2) {
        block3: {
            block2: {
                long actualSize = this.builder.getBrushSize-NH-jbRc();
                if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getBrush(), (Object)brush)) break block2;
                long $this$isUnspecified$iv = actualSize;
                boolean bl = false;
                if ($this$isUnspecified$iv == 9205357640488583168L) break block2;
                boolean bl2 = false;
                long value$iv$iv = actualSize;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                float f = Float.intBitsToFloat(bits$iv$iv$iv);
                bl2 = false;
                value$iv$iv = brushSize;
                $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits = false;
                if (!ParagraphLayouter_skikoKt.access$sameValueAs(f, Float.intBitsToFloat(bits$iv$iv$iv))) break block2;
                boolean bl3 = false;
                value$iv$iv = actualSize;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                float f2 = Float.intBitsToFloat(bits$iv$iv$iv);
                bl3 = false;
                value$iv$iv = brushSize;
                $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                if (ParagraphLayouter_skikoKt.access$sameValueAs(f2, Float.intBitsToFloat(bits$iv$iv$iv)) && ParagraphLayouter_skikoKt.access$sameValueAs(this.builder.getTextStyle().getAlpha(), alpha2)) break block3;
            }
            this.builder.setTextStyle(TextStyle.copy-Ns73l9s$default(this.builder.getTextStyle(), brush, alpha2, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0x1FFFFFC, null));
            this.builder.setBrushSize-uvyYCjk(brushSize);
            this.invalidateParagraph(true);
        }
    }

    public final void setBrushSize-uvyYCjk(long brushSize) {
        block8: {
            block9: {
                boolean bl;
                block7: {
                    if (Size.equals-impl0(this.builder.getBrushSize-NH-jbRc(), brushSize)) break block8;
                    this.builder.setBrushSize-uvyYCjk(brushSize);
                    if (this.builder.getTextStyle().getBrush() instanceof ShaderBrush) break block9;
                    Iterable $this$any$iv = this.builder.getAnnotations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            AnnotatedString.Range it = (AnnotatedString.Range)element$iv;
                            boolean bl2 = false;
                            if (!(it.getItem() instanceof SpanStyle && ((SpanStyle)it.getItem()).getBrush() instanceof ShaderBrush)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block8;
            }
            this.invalidateParagraph(true);
        }
    }

    public final void setTextStyle(@Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        if (!Intrinsics.areEqual((Object)this.builder.getTextStyle().getShadow(), (Object)shadow) || !Intrinsics.areEqual((Object)this.builder.getTextStyle().getTextDecoration(), (Object)textDecoration)) {
            this.builder.setTextStyle(TextStyle.copy-p1EtxEg$default(this.builder.getTextStyle(), 0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, textDecoration, shadow, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFCFFF, null));
            ParagraphLayouter.invalidateParagraph$default(this, false, 1, null);
        }
    }

    public final void setDrawStyle(@Nullable DrawStyle drawStyle) {
        if (!Intrinsics.areEqual((Object)this.builder.getDrawStyle(), (Object)drawStyle)) {
            this.builder.setDrawStyle(drawStyle);
            this.invalidateParagraph(true);
        }
    }

    public final void setBlendMode-s9anfk8(int blendMode) {
        if (!BlendMode.equals-impl0(this.builder.getBlendMode-0nO6VwU(), blendMode)) {
            this.builder.setBlendMode-s9anfk8(blendMode);
            ParagraphLayouter.invalidateParagraph$default(this, false, 1, null);
        }
    }

    @NotNull
    public final Paragraph layoutParagraph(float width) {
        Paragraph paragraph = this.paragraphCache;
        if (paragraph != null) {
            boolean layoutRequired = false;
            if (this.updateForeground) {
                this.builder.updateForegroundPaint(paragraph);
                this.updateForeground = false;
                paragraph.markDirty();
                layoutRequired = true;
            }
            if (!ParagraphLayouter_skikoKt.access$sameValueAs(this.width, width)) {
                this.width = width;
                layoutRequired = true;
            }
            if (layoutRequired) {
                paragraph.layout(width);
            }
        } else {
            paragraph = this.builder.build();
            paragraph.layout(width);
            this.paragraphCache = paragraph;
            this.updateForeground = false;
            return paragraph;
        }
        return paragraph;
    }
}

