/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.FontRasterizationSettings;
import androidx.compose.ui.text.FontRasterizationSettings_skikoKt;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.PlatformParagraphStyle;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontFamilyResolverImpl;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontSynthesis;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.PlatformFontLoader;
import androidx.compose.ui.text.font.SkiaFontLoader;
import androidx.compose.ui.text.platform.ComputedStyle;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt;
import androidx.compose.ui.text.style.LineHeightStyle;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.unit.Density;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.BaselineMode;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.FontRastrSettings;
import org.jetbrains.skia.paragraph.HeightMode;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.Paragraph;
import org.jetbrains.skia.paragraph.ParagraphStyle;
import org.jetbrains.skia.paragraph.PlaceholderStyle;
import org.jetbrains.skia.paragraph.TextIndent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nParagraphBuilder.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphBuilder.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,750:1\n1010#2,2:751\n1#3:753\n*S KotlinDebug\n*F\n+ 1 ParagraphBuilder.skiko.kt\nandroidx/compose/ui/text/platform/ParagraphBuilder\n*L\n444#1:751,2\n*E\n"})
public final class ParagraphBuilder {
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    @NotNull
    private final String text;
    @NotNull
    private TextStyle textStyle;
    private long brushSize;
    @NotNull
    private String ellipsis;
    private int maxLines;
    @NotNull
    private List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @NotNull
    private final Density density;
    @NotNull
    private final ResolvedTextDirection textDirection;
    @Nullable
    private DrawStyle drawStyle;
    private int blendMode;
    @NotNull
    private final ComputedStyle defaultStyle;
    private SpanStyle initialStyle;
    private List<? extends Op> ops;
    @NotNull
    private final Lazy defaultFont$delegate;
    public static final int $stable = 8;

    private ParagraphBuilder(FontFamily.Resolver fontFamilyResolver, String text2, TextStyle textStyle, long brushSize, String ellipsis, int maxLines, List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations, List<AnnotatedString.Range<Placeholder>> placeholders, Density density, ResolvedTextDirection textDirection, DrawStyle drawStyle, int blendMode) {
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)ellipsis, (String)"ellipsis");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)textDirection), (String)"textDirection");
        this.fontFamilyResolver = fontFamilyResolver;
        this.text = text2;
        this.textStyle = textStyle;
        this.brushSize = brushSize;
        this.ellipsis = ellipsis;
        this.maxLines = maxLines;
        this.annotations = annotations;
        this.placeholders = placeholders;
        this.density = density;
        this.textDirection = textDirection;
        this.drawStyle = drawStyle;
        this.blendMode = blendMode;
        this.defaultStyle = new ComputedStyle(null, 0L, 0.0f, null, null, null, null, null, null, null, null, null, 0L, null, null, null, null, 0, null, 0.0f, 1048575, null);
        this.defaultFont$delegate = LazyKt.lazy(() -> ParagraphBuilder.defaultFont_delegate$lambda$6(this));
    }

    public /* synthetic */ ParagraphBuilder(FontFamily.Resolver resolver, String string, TextStyle textStyle, long l, String string2, int n, List list2, List list3, Density density, ResolvedTextDirection resolvedTextDirection, DrawStyle drawStyle, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            l = Size.Companion.getUnspecified-NH-jbRc();
        }
        if ((n3 & 0x10) != 0) {
            string2 = "";
        }
        if ((n3 & 0x20) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 0x400) != 0) {
            drawStyle = null;
        }
        if ((n3 & 0x800) != 0) {
            n2 = DrawScope.Companion.getDefaultBlendMode-0nO6VwU();
        }
        this(resolver, string, textStyle, l, string2, n, list2, list3, density, resolvedTextDirection, drawStyle, n2, null);
    }

    @NotNull
    public final TextStyle getTextStyle() {
        return this.textStyle;
    }

    public final void setTextStyle(@NotNull TextStyle textStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"<set-?>");
        this.textStyle = textStyle;
    }

    public final long getBrushSize-NH-jbRc() {
        return this.brushSize;
    }

    public final void setBrushSize-uvyYCjk(long l) {
        this.brushSize = l;
    }

    @NotNull
    public final String getEllipsis() {
        return this.ellipsis;
    }

    public final void setEllipsis(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ellipsis = string;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final void setMaxLines(int n) {
        this.maxLines = n;
    }

    @NotNull
    public final List<AnnotatedString.Range<? extends AnnotatedString.Annotation>> getAnnotations() {
        return this.annotations;
    }

    @Nullable
    public final DrawStyle getDrawStyle() {
        return this.drawStyle;
    }

    public final void setDrawStyle(@Nullable DrawStyle drawStyle) {
        this.drawStyle = drawStyle;
    }

    public final int getBlendMode-0nO6VwU() {
        return this.blendMode;
    }

    public final void setBlendMode-s9anfk8(int n) {
        this.blendMode = n;
    }

    private final void prepareDefaultStyle() {
        this.initialStyle = SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$copyWithDefaultFontSize(this.textStyle.toSpanStyle(), this.drawStyle);
        SpanStyle spanStyle = this.initialStyle;
        if (spanStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialStyle");
            spanStyle = null;
        }
        this.defaultStyle.set-qIERHQ8(this.density, spanStyle, this.brushSize, this.blendMode, this.textStyle.getLineHeight-XSAIIZE(), this.textStyle.getLineHeightStyle());
    }

    public final void updateForegroundPaint(@Nullable Paragraph paragraph) {
        if (paragraph == null) {
            return;
        }
        this.prepareDefaultStyle();
        Paint foregroundPaint = this.defaultStyle.getForegroundPaint();
        paragraph.updateForegroundPaint(0, this.text.length(), foregroundPaint);
    }

    @NotNull
    public final Paragraph build() {
        this.prepareDefaultStyle();
        this.ops = this.makeOps(this.annotations, this.placeholders);
        int pos = 0;
        ParagraphStyle ps = this.textStyleToParagraphStyle(this.textStyle, this.defaultStyle);
        if (this.maxLines != Integer.MAX_VALUE) {
            ps.setMaxLinesCount(this.maxLines);
            ps.setEllipsis(this.ellipsis);
        }
        FontFamily.Resolver resolver = this.fontFamilyResolver;
        Intrinsics.checkNotNull((Object)resolver, (String)"null cannot be cast to non-null type androidx.compose.ui.text.font.FontFamilyResolverImpl");
        PlatformFontLoader platformFontLoader = ((FontFamilyResolverImpl)resolver).getPlatformFontLoader$ui_text();
        if (!(platformFontLoader instanceof SkiaFontLoader)) {
            throw new IllegalStateException("Unsupported font loader " + platformFontLoader);
        }
        FontCollection fontCollection = ((SkiaFontLoader)platformFontLoader).getFontCollection();
        org.jetbrains.skia.paragraph.ParagraphBuilder pb = new org.jetbrains.skia.paragraph.ParagraphBuilder(ps, fontCollection);
        boolean addText = true;
        List<? extends Op> list2 = this.ops;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ops");
            list2 = null;
        }
        for (Op op : list2) {
            Op op2;
            if (addText && pos < op.getPosition()) {
                pb.addText(((Object)this.text.subSequence(pos, op.getPosition())).toString());
            }
            if ((op2 = op) instanceof Op.StyleAdd) {
                FontFamilyResolverImpl fontFamilyResolverImpl = (FontFamilyResolverImpl)this.fontFamilyResolver;
                FontFamily fontFamily = ((Op.StyleAdd)op).getStyle().getFontFamily();
                FontWeight fontWeight = ((Op.StyleAdd)op).getStyle().getFontWeight();
                if (fontWeight == null) {
                    fontWeight = FontWeight.Companion.getNormal();
                }
                FontStyle fontStyle = ((Op.StyleAdd)op).getStyle().getFontStyle-4Lr2A7w();
                FontSynthesis fontSynthesis = ((Op.StyleAdd)op).getStyle().getFontSynthesis-ZQGJjVo();
                fontFamilyResolverImpl.resolve-DPcqOEQ(fontFamily, fontWeight, fontStyle != null ? fontStyle.unbox-impl() : FontStyle.Companion.getNormal-_-LCdwA(), fontSynthesis != null ? fontSynthesis.unbox-impl() : FontSynthesis.Companion.getAll-GVVA2EU());
                pb.pushStyle(this.makeSkTextStyle(((Op.StyleAdd)op).getStyle()));
            } else if (op2 instanceof Op.PutPlaceholder) {
                PlaceholderStyle placeholderStyle = new PlaceholderStyle(((Op.PutPlaceholder)op).getWidth(), ((Op.PutPlaceholder)op).getHeight(), SkiaParagraph_skikoKt.toSkPlaceholderAlignment-do9X-Gg(((Op.PutPlaceholder)op).getCut().getPlaceholder().getPlaceholderVerticalAlign-J6kI3mc()), BaselineMode.ALPHABETIC, 0.0f);
                pb.addPlaceholder(placeholderStyle);
                addText = false;
            } else if (op2 instanceof Op.EndPlaceholder) {
                addText = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            pos = op.getPosition();
        }
        if (addText && pos < this.text.length()) {
            pb.addText(((Object)this.text.subSequence(pos, this.text.length())).toString());
        }
        return pb.build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Op> makeOps(List<? extends AnnotatedString.Range<? extends AnnotatedString.Annotation>> annotations, List<AnnotatedString.Range<Placeholder>> placeholders) {
        List cuts = new ArrayList();
        for (AnnotatedString.Range<? extends AnnotatedString.Annotation> range : annotations) {
            if (!(range.getItem() instanceof SpanStyle)) continue;
            cuts.add(new Cut.StyleAdd(range.getStart(), (SpanStyle)range.getItem()));
            cuts.add(new Cut.StyleRemove(range.getEnd(), (SpanStyle)range.getItem()));
        }
        for (AnnotatedString.Range<Object> range : placeholders) {
            cuts.add(new Cut.PutPlaceholder(range.getStart(), (Placeholder)range.getItem()));
            cuts.add(new Cut.EndPlaceholder(range.getEnd()));
        }
        Object[] objectArray = new Op[]{new Op.StyleAdd(0, this.defaultStyle)};
        List ops = CollectionsKt.mutableListOf((Object[])objectArray);
        List list2 = cuts;
        boolean $i$f$sortBy = false;
        if (list2.size() > 1) {
            CollectionsKt.sortWith((List)list2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Cut it = (Cut)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition());
                    it = (Cut)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition()));
                }
            });
        }
        SpanStyle[] spanStyleArray = new SpanStyle[1];
        SpanStyle spanStyle = this.initialStyle;
        if (spanStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialStyle");
            spanStyle = null;
        }
        spanStyleArray[0] = spanStyle;
        List list3 = CollectionsKt.mutableListOf((Object[])spanStyleArray);
        for (Cut cut2 : cuts) {
            Cut cut3 = cut2;
            if (cut3 instanceof Cut.StyleAdd) {
                list3.add(((Cut.StyleAdd)cut2).getStyle());
                Op.StyleAdd prev = this.previousStyleAddAtTheSamePosition(((Cut.StyleAdd)cut2).getPosition(), ops);
                if (prev == null) {
                    void it;
                    ComputedStyle computedStyle;
                    ComputedStyle computedStyle2 = computedStyle = this.mergeStyles(list3);
                    int n = ((Cut.StyleAdd)cut2).getPosition();
                    List list4 = ops;
                    boolean bl = false;
                    it.merge(this.density, ((Cut.StyleAdd)cut2).getStyle());
                    Unit unit = Unit.INSTANCE;
                    ComputedStyle computedStyle3 = computedStyle;
                    int n2 = n;
                    list4.add(new Op.StyleAdd(n2, computedStyle3));
                    continue;
                }
                prev.getStyle().merge(this.density, ((Cut.StyleAdd)cut2).getStyle());
                continue;
            }
            if (cut3 instanceof Cut.StyleRemove) {
                list3.remove(((Cut.StyleRemove)cut2).getStyle());
                ops.add(new Op.StyleAdd(((Cut.StyleRemove)cut2).getPosition(), this.mergeStyles(list3)));
                continue;
            }
            if (cut3 instanceof Cut.PutPlaceholder) {
                ComputedStyle currentStyle = this.mergeStyles(list3);
                Op.PutPlaceholder op = new Op.PutPlaceholder((Cut.PutPlaceholder)cut2, SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toPx-o2QH7mI(((Cut.PutPlaceholder)cut2).getPlaceholder().getWidth-XSAIIZE(), this.density, currentStyle.getFontSize()), SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toPx-o2QH7mI(((Cut.PutPlaceholder)cut2).getPlaceholder().getHeight-XSAIIZE(), this.density, currentStyle.getFontSize()));
                ops.add(op);
                continue;
            }
            if (cut3 instanceof Cut.EndPlaceholder) {
                ops.add(new Op.EndPlaceholder((Cut.EndPlaceholder)cut2));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return ops;
    }

    private final ComputedStyle mergeStyles(List<SpanStyle> activeStyles) {
        ComputedStyle style = new ComputedStyle(this.density, activeStyles.get(0), this.brushSize, this.blendMode, this.textStyle.getLineHeight-XSAIIZE(), this.textStyle.getLineHeightStyle(), null);
        int n = activeStyles.size();
        for (int i2 = 1; i2 < n; ++i2) {
            style.merge(this.density, activeStyles.get(i2));
        }
        return style;
    }

    private final Op.StyleAdd previousStyleAddAtTheSamePosition(int position, List<? extends Op> ops) {
        for (Op prevOp : CollectionsKt.asReversed(ops)) {
            if (prevOp.getPosition() < position) {
                return null;
            }
            if (!(prevOp instanceof Op.StyleAdd)) continue;
            return (Op.StyleAdd)prevOp;
        }
        return null;
    }

    private final FontRastrSettings makeSkFontRasterizationSettings(TextStyle style) {
        Object object = style.getParagraphStyle$ui_text().getPlatformStyle();
        if (object == null || (object = ((PlatformParagraphStyle)object).getFontRasterizationSettings()) == null) {
            object = FontRasterizationSettings.Companion.getPlatformDefault();
        }
        Object rasterizationSettings = object;
        return FontRasterizationSettings_skikoKt.toSkFontRastrSettings((FontRasterizationSettings)rasterizationSettings);
    }

    private final ParagraphStyle textStyleToParagraphStyle(TextStyle style, ComputedStyle computedStyle) {
        ParagraphStyle pStyle;
        block3: {
            pStyle = new ParagraphStyle();
            pStyle.setReplaceTabCharacters(true);
            pStyle.setFontRastrSettings(this.makeSkFontRasterizationSettings(style));
            pStyle.setTextStyle(this.makeSkTextStyle(computedStyle));
            int it = style.getTextAlign-e0LSkKk();
            boolean bl = false;
            pStyle.setAlignment(SkiaParagraph_skikoKt.toSkAlignment-aXe7zB0(it));
            Float lineHeight = computedStyle.getLineHeight();
            if (lineHeight != null && lineHeight.floatValue() > computedStyle.getFontSize()) {
                LineHeightStyle lineHeightStyle = style.getLineHeightStyle();
                if (lineHeightStyle == null) {
                    lineHeightStyle = LineHeightStyle.Companion.getDefault();
                }
                LineHeightStyle lineHeightStyle2 = lineHeightStyle;
                pStyle.setHeightMode(SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$toHeightMode-XeJ9Kts(lineHeightStyle2.getTrim-EVpEnUU()));
            } else {
                pStyle.setHeightMode(HeightMode.DISABLE_ALL);
            }
            pStyle.setDirection(SkiaParagraph_skikoKt.toSkDirection(this.textDirection));
            androidx.compose.ui.text.style.TextIndent textIndent = this.textStyle.getTextIndent();
            if (textIndent == null) break block3;
            androidx.compose.ui.text.style.TextIndent $this$textStyleToParagraphStyle_u24lambda_u244 = textIndent;
            boolean bl2 = false;
            Density $this$textStyleToParagraphStyle_u24lambda_u244_u24lambda_u243 = this.density;
            boolean bl3 = false;
            pStyle.setTextIndent(new TextIndent($this$textStyleToParagraphStyle_u24lambda_u244_u24lambda_u243.toPx--R2X_6o($this$textStyleToParagraphStyle_u24lambda_u244.getFirstLine-XSAIIZE()), $this$textStyleToParagraphStyle_u24lambda_u244_u24lambda_u243.toPx--R2X_6o($this$textStyleToParagraphStyle_u24lambda_u244.getRestLine-XSAIIZE())));
        }
        return pStyle;
    }

    private final org.jetbrains.skia.paragraph.TextStyle makeSkTextStyle(ComputedStyle style) {
        return (org.jetbrains.skia.paragraph.TextStyle)SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$getSkTextStylesCache$p().get(style, arg_0 -> ParagraphBuilder.makeSkTextStyle$lambda$5(this, arg_0));
    }

    @NotNull
    public final Font getDefaultFont$ui_text() {
        Lazy lazy = this.defaultFont$delegate;
        return (Font)lazy.getValue();
    }

    @NotNull
    public final LineMetrics[] emptyLineMetrics$ui_text(@NotNull Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        FontMetrics metrics = this.getDefaultFont$ui_text().getMetrics();
        double ascent = metrics.getAscent();
        double descent = metrics.getDescent();
        double baseline = paragraph.getAlphabeticBaseline();
        Float lineHeight = this.defaultStyle.getLineHeight();
        if (lineHeight != null) {
            float topRatio = this.defaultStyle.getTopRatio();
            boolean bl = 0.0f <= topRatio ? topRatio <= 1.0f : false;
            if (bl) {
                float extraLeading = lineHeight.floatValue() - this.defaultStyle.getFontSize();
                ascent -= (double)(extraLeading * topRatio);
                descent += (double)(extraLeading * (1.0f - topRatio));
            } else {
                float multiplier = lineHeight.floatValue() / this.defaultStyle.getFontSize();
                ascent *= (double)multiplier;
                descent *= (double)multiplier;
            }
        }
        double height = descent - ascent;
        LineMetrics[] lineMetricsArray = new LineMetrics[]{new LineMetrics(0, 0, 0, 0, true, -ascent, descent, ascent, height, 0.0, 0.0, baseline, 0)};
        return lineMetricsArray;
    }

    private static final org.jetbrains.skia.paragraph.TextStyle makeSkTextStyle$lambda$5(ParagraphBuilder this$0, ComputedStyle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toSkTextStyle(this$0.fontFamilyResolver);
    }

    private static final Font defaultFont_delegate$lambda$6(ParagraphBuilder this$0) {
        FontLoadResult loadResult;
        FontLoadResult fontLoadResult = loadResult = SkiaParagraph_skikoKt__ParagraphBuilder_skikoKt.access$resolveFontFamily(this$0.textStyle, this$0.fontFamilyResolver);
        return new Font((Typeface)(fontLoadResult != null ? fontLoadResult.getTypeface() : null), this$0.defaultStyle.getFontSize());
    }

    public /* synthetic */ ParagraphBuilder(FontFamily.Resolver fontFamilyResolver, String text2, TextStyle textStyle, long brushSize, String ellipsis, int maxLines, List annotations, List placeholders, Density density, ResolvedTextDirection textDirection, DrawStyle drawStyle, int blendMode, DefaultConstructorMarker $constructor_marker) {
        this(fontFamilyResolver, text2, textStyle, brushSize, ellipsis, maxLines, annotations, placeholders, density, textDirection, drawStyle, blendMode);
    }

    private static abstract class Cut {
        private Cut() {
        }

        public abstract int getPosition();

        public /* synthetic */ Cut(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class EndPlaceholder
        extends Cut {
            private final int position;

            public EndPlaceholder(int position) {
                super(null);
                this.position = position;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public String toString() {
                return "EndPlaceholder(position=" + this.position + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.position);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EndPlaceholder)) {
                    return false;
                }
                EndPlaceholder endPlaceholder = (EndPlaceholder)other;
                return this.position == endPlaceholder.position;
            }
        }

        public static final class PutPlaceholder
        extends Cut {
            private final int position;
            @NotNull
            private final Placeholder placeholder;

            public PutPlaceholder(int position, @NotNull Placeholder placeholder) {
                Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
                super(null);
                this.position = position;
                this.placeholder = placeholder;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final Placeholder getPlaceholder() {
                return this.placeholder;
            }

            @NotNull
            public String toString() {
                return "PutPlaceholder(position=" + this.position + ", placeholder=" + this.placeholder + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.position);
                result2 = result2 * 31 + this.placeholder.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PutPlaceholder)) {
                    return false;
                }
                PutPlaceholder putPlaceholder = (PutPlaceholder)other;
                if (this.position != putPlaceholder.position) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.placeholder, (Object)putPlaceholder.placeholder);
            }
        }

        public static final class StyleAdd
        extends Cut {
            private final int position;
            @NotNull
            private final SpanStyle style;

            public StyleAdd(int position, @NotNull SpanStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                super(null);
                this.position = position;
                this.style = style;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final SpanStyle getStyle() {
                return this.style;
            }

            @NotNull
            public String toString() {
                return "StyleAdd(position=" + this.position + ", style=" + this.style + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.position);
                result2 = result2 * 31 + this.style.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StyleAdd)) {
                    return false;
                }
                StyleAdd styleAdd = (StyleAdd)other;
                if (this.position != styleAdd.position) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.style, (Object)styleAdd.style);
            }
        }

        public static final class StyleRemove
        extends Cut {
            private final int position;
            @NotNull
            private final SpanStyle style;

            public StyleRemove(int position, @NotNull SpanStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                super(null);
                this.position = position;
                this.style = style;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final SpanStyle getStyle() {
                return this.style;
            }

            @NotNull
            public String toString() {
                return "StyleRemove(position=" + this.position + ", style=" + this.style + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.position);
                result2 = result2 * 31 + this.style.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StyleRemove)) {
                    return false;
                }
                StyleRemove styleRemove = (StyleRemove)other;
                if (this.position != styleRemove.position) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.style, (Object)styleRemove.style);
            }
        }
    }

    private static abstract class Op {
        private Op() {
        }

        public abstract int getPosition();

        public /* synthetic */ Op(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class EndPlaceholder
        extends Op {
            @NotNull
            private final Cut.EndPlaceholder cut;
            public static final int $stable = 8;

            public EndPlaceholder(@NotNull Cut.EndPlaceholder cut2) {
                Intrinsics.checkNotNullParameter((Object)cut2, (String)"cut");
                super(null);
                this.cut = cut2;
            }

            @Override
            public int getPosition() {
                return this.cut.getPosition();
            }

            @NotNull
            public String toString() {
                return "EndPlaceholder(cut=" + this.cut + ")";
            }

            public int hashCode() {
                return this.cut.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EndPlaceholder)) {
                    return false;
                }
                EndPlaceholder endPlaceholder = (EndPlaceholder)other;
                return Intrinsics.areEqual((Object)this.cut, (Object)endPlaceholder.cut);
            }
        }

        public static final class PutPlaceholder
        extends Op {
            @NotNull
            private final Cut.PutPlaceholder cut;
            private float width;
            private float height;
            public static final int $stable = 8;

            public PutPlaceholder(@NotNull Cut.PutPlaceholder cut2, float width, float height) {
                Intrinsics.checkNotNullParameter((Object)cut2, (String)"cut");
                super(null);
                this.cut = cut2;
                this.width = width;
                this.height = height;
            }

            @NotNull
            public final Cut.PutPlaceholder getCut() {
                return this.cut;
            }

            public final float getWidth() {
                return this.width;
            }

            public final float getHeight() {
                return this.height;
            }

            @Override
            public int getPosition() {
                return this.cut.getPosition();
            }

            @NotNull
            public String toString() {
                return "PutPlaceholder(cut=" + this.cut + ", width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                int result2 = this.cut.hashCode();
                result2 = result2 * 31 + Float.hashCode(this.width);
                result2 = result2 * 31 + Float.hashCode(this.height);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PutPlaceholder)) {
                    return false;
                }
                PutPlaceholder putPlaceholder = (PutPlaceholder)other;
                if (!Intrinsics.areEqual((Object)this.cut, (Object)putPlaceholder.cut)) {
                    return false;
                }
                if (Float.compare(this.width, putPlaceholder.width) != 0) {
                    return false;
                }
                return Float.compare(this.height, putPlaceholder.height) == 0;
            }
        }

        public static final class StyleAdd
        extends Op {
            private final int position;
            @NotNull
            private final ComputedStyle style;
            public static final int $stable = 8;

            public StyleAdd(int position, @NotNull ComputedStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                super(null);
                this.position = position;
                this.style = style;
            }

            @Override
            public int getPosition() {
                return this.position;
            }

            @NotNull
            public final ComputedStyle getStyle() {
                return this.style;
            }

            @NotNull
            public String toString() {
                return "StyleAdd(position=" + this.position + ", style=" + this.style + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.position);
                result2 = result2 * 31 + this.style.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StyleAdd)) {
                    return false;
                }
                StyleAdd styleAdd = (StyleAdd)other;
                if (this.position != styleAdd.position) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.style, (Object)styleAdd.style);
            }
        }
    }
}

