/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.Cache;
import androidx.compose.ui.text.ExpireAfterAccessCache;
import androidx.compose.ui.text.font.DefaultFontFamily;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.GenericFontFamily;
import androidx.compose.ui.text.font.LoadedFontFamily;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FontLoadResult;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.SkiaBackedTypeface;
import androidx.compose.ui.text.platform.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.platform.SystemFont;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontMgrWithFallback;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.TypefaceFontProviderWithFallback;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nPlatformFont.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n37#2:433\n36#2,3:434\n808#3,11:437\n1557#3:448\n1628#3,3:449\n*S KotlinDebug\n*F\n+ 1 PlatformFont.skiko.kt\nandroidx/compose/ui/text/platform/FontCache\n*L\n319#1:433\n319#1:434,3\n332#1:437,11\n334#1:448\n334#1:449,3\n*E\n"})
public final class FontCache {
    @NotNull
    private final FontCollection fonts = new FontCollection();
    @NotNull
    private final TypefaceFontProviderWithFallback fontProvider = new TypefaceFontProviderWithFallback();
    @NotNull
    private final Set<String> registered = new HashSet();
    @NotNull
    private final Cache<String, Typeface> typefacesCache = new ExpireAfterAccessCache(60000000000L, null, 2, null);
    public static final int $stable = 8;

    public FontCache() {
        this.fonts.setDefaultFontManager((FontMgr)new FontMgrWithFallback(this.fontProvider));
        this.fonts.setAssetFontManager((FontMgr)this.fontProvider);
    }

    @NotNull
    public final FontCollection getFonts$ui_text() {
        return this.fonts;
    }

    @NotNull
    public final FontLoadResult load$ui_text(@NotNull PlatformFont font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Typeface typeface2 = this.typefacesCache.get(font.getCacheKey$ui_text(), (Function1<String, Typeface>)((Function1)arg_0 -> FontCache.load$lambda$0(font, arg_0)));
        this.ensureRegistered(typeface2, font.getCacheKey$ui_text());
        return new FontLoadResult(typeface2, CollectionsKt.listOf((Object)font.getCacheKey$ui_text()));
    }

    @NotNull
    public final FontLoadResult loadPlatformTypes-RetOiIg$ui_text(@NotNull FontFamily fontFamily, @NotNull FontWeight fontWeight, int fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        List<String> aliases = this.ensureRegistered(fontFamily);
        FontStyle style = SkiaParagraph_skikoKt.toSkFontStyle-nzbMABs(fontStyle).withWeight(fontWeight.getWeight());
        Collection $this$toTypedArray$iv = aliases;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new FontLoadResult((Typeface)ArraysKt.first((Object[])this.fonts.findTypefaces(thisCollection$iv.toArray(new String[0]), style)), aliases);
    }

    private final void ensureRegistered(Typeface typeface2, String key) {
        if (!this.registered.contains(key)) {
            this.fontProvider.registerTypeface(typeface2, key);
            this.registered.add(key);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<String> ensureRegistered(FontFamily fontFamily) {
        List list2;
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((FontListFontFamily)fontFamily).getFonts();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SystemFont)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List fonts = (List)destination$iv$iv;
            if (fonts.size() != ((FontListFontFamily)fontFamily).getFonts().size()) throw new IllegalArgumentException("Don't load FontListFontFamily through ensureRegistered: " + fontFamily);
            Iterable $this$map$iv = fonts;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SystemFont systemFont = (SystemFont)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIdentity());
            }
            list2 = (List)destination$iv$iv;
            return list2;
        } else if (fontFamily2 instanceof LoadedFontFamily) {
            androidx.compose.ui.text.font.Typeface typeface2 = ((LoadedFontFamily)fontFamily).getTypeface();
            Intrinsics.checkNotNull((Object)typeface2, (String)"null cannot be cast to non-null type androidx.compose.ui.text.platform.SkiaBackedTypeface");
            SkiaBackedTypeface typeface3 = (SkiaBackedTypeface)typeface2;
            this.ensureRegistered(typeface3.getNativeTypeface(), typeface3.getAlias());
            list2 = CollectionsKt.listOf((Object)typeface3.getAlias());
            return list2;
        } else if (fontFamily2 instanceof GenericFontFamily) {
            list2 = PlatformFont_skikoKt.getAliases((GenericFontFamily)fontFamily);
            return list2;
        } else {
            if (!(fontFamily2 instanceof DefaultFontFamily)) throw new IllegalArgumentException("Unknown font family type: " + fontFamily);
            list2 = PlatformFont_skikoKt.getAliases(FontFamily.Companion.getSansSerif());
        }
        return list2;
    }

    private static final Typeface load$lambda$0(PlatformFont $font, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DesktopFont_desktopKt.loadTypeface($font);
    }
}

