/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.PlatformTextInputService;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputService;
import kotlin.Deprecated;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use PlatformTextInputModifierNode instead.")
@SourceDebugExtension(value={"SMAP\nTextInputService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInputService.kt\nandroidx/compose/ui/text/input/TextInputSession\n*L\n1#1,363:1\n175#1,5:364\n175#1,5:369\n175#1,5:374\n175#1,5:379\n175#1,5:384\n*S KotlinDebug\n*F\n+ 1 TextInputService.kt\nandroidx/compose/ui/text/input/TextInputSession\n*L\n194#1:364,5\n218#1:369,5\n245#1:374,5\n265#1:379,5\n282#1:384,5\n*E\n"})
public final class TextInputSession {
    @NotNull
    private final TextInputService textInputService;
    @NotNull
    private final PlatformTextInputService platformTextInputService;
    public static final int $stable = 8;

    public TextInputSession(@NotNull TextInputService textInputService, @NotNull PlatformTextInputService platformTextInputService) {
        Intrinsics.checkNotNullParameter((Object)textInputService, (String)"textInputService");
        Intrinsics.checkNotNullParameter((Object)platformTextInputService, (String)"platformTextInputService");
        this.textInputService = textInputService;
        this.platformTextInputService = platformTextInputService;
    }

    public final boolean isOpen() {
        return Intrinsics.areEqual((Object)this.textInputService.getCurrentInputSession$ui_text(), (Object)this);
    }

    public final void dispose() {
        this.textInputService.stopInput(this);
    }

    public final boolean notifyFocusedRect(@NotNull Rect rect) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        TextInputSession this_$iv = this;
        boolean $i$f$ensureOpenSession = false;
        boolean applying$iv = bl = this_$iv.isOpen();
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.platformTextInputService.notifyFocusedRect(rect);
        }
        return bl;
    }

    public final boolean updateTextLayoutResult(@NotNull TextFieldValue textFieldValue, @NotNull OffsetMapping offsetMapping, @NotNull TextLayoutResult textLayoutResult, @NotNull Function1<? super Matrix, Unit> textFieldToRootTransform, @NotNull Rect innerTextFieldBounds, @NotNull Rect decorationBoxBounds) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter(textFieldToRootTransform, (String)"textFieldToRootTransform");
        Intrinsics.checkNotNullParameter((Object)innerTextFieldBounds, (String)"innerTextFieldBounds");
        Intrinsics.checkNotNullParameter((Object)decorationBoxBounds, (String)"decorationBoxBounds");
        TextInputSession this_$iv = this;
        boolean $i$f$ensureOpenSession = false;
        boolean applying$iv = bl = this_$iv.isOpen();
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.platformTextInputService.updateTextLayoutResult(textFieldValue, offsetMapping, textLayoutResult, textFieldToRootTransform, innerTextFieldBounds, decorationBoxBounds);
        }
        return bl;
    }

    public final boolean updateState(@Nullable TextFieldValue oldValue, @NotNull TextFieldValue newValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        TextInputSession this_$iv = this;
        boolean $i$f$ensureOpenSession = false;
        boolean applying$iv = bl = this_$iv.isOpen();
        boolean bl2 = false;
        if (applying$iv) {
            boolean bl3 = false;
            this.platformTextInputService.updateState(oldValue, newValue);
        }
        return bl;
    }
}

