/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetComposingRegionCommand
implements EditCommand {
    private final int start;
    private final int end;

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        int clampedEnd;
        int clampedStart;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text()) {
            buffer.commitComposition$ui_text();
        }
        if ((clampedStart = RangesKt.coerceIn((int)this.start, (int)0, (int)buffer.getLength$ui_text())) != (clampedEnd = RangesKt.coerceIn((int)this.end, (int)0, (int)buffer.getLength$ui_text()))) {
            if (clampedStart < clampedEnd) {
                buffer.setComposition$ui_text(clampedStart, clampedEnd);
            } else {
                buffer.setComposition$ui_text(clampedEnd, clampedStart);
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetComposingRegionCommand)) {
            return false;
        }
        if (this.start != ((SetComposingRegionCommand)other).start) {
            return false;
        }
        return this.end == ((SetComposingRegionCommand)other).end;
    }

    public int hashCode() {
        int result2 = this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }

    @NotNull
    public String toString() {
        return "SetComposingRegionCommand(start=" + this.start + ", end=" + this.end + ")";
    }
}

