/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import androidx.compose.ui.text.internal.InlineClassHelperKt;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nFontWeight.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontWeight.kt\nandroidx/compose/ui/text/font/FontWeight\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,120:1\n118#2,4:121\n*S KotlinDebug\n*F\n+ 1 FontWeight.kt\nandroidx/compose/ui/text/font/FontWeight\n*L\n78#1:121,4\n*E\n"})
public final class FontWeight
implements Comparable<FontWeight> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int weight;
    @NotNull
    private static final FontWeight W100 = new FontWeight(100);
    @NotNull
    private static final FontWeight W200 = new FontWeight(200);
    @NotNull
    private static final FontWeight W300 = new FontWeight(300);
    @NotNull
    private static final FontWeight W400 = new FontWeight(400);
    @NotNull
    private static final FontWeight W500 = new FontWeight(500);
    @NotNull
    private static final FontWeight W600 = new FontWeight(600);
    @NotNull
    private static final FontWeight W700 = new FontWeight(700);
    @NotNull
    private static final FontWeight W800 = new FontWeight(800);
    @NotNull
    private static final FontWeight W900 = new FontWeight(900);
    @NotNull
    private static final FontWeight Thin = W100;
    @NotNull
    private static final FontWeight ExtraLight = W200;
    @NotNull
    private static final FontWeight Light = W300;
    @NotNull
    private static final FontWeight Normal = W400;
    @NotNull
    private static final FontWeight Medium = W500;
    @NotNull
    private static final FontWeight SemiBold = W600;
    @NotNull
    private static final FontWeight Bold = W700;
    @NotNull
    private static final FontWeight ExtraBold = W800;
    @NotNull
    private static final FontWeight Black = W900;
    @NotNull
    private static final List<FontWeight> values;

    public FontWeight(int weight) {
        this.weight = weight;
        int n = this.weight;
        boolean value$iv = 1 <= n ? n < 1001 : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Font weight can be in range [1, 1000]. Current value: " + this.weight);
        }
    }

    public final int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(@NotNull FontWeight other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)this.weight, (int)other.weight);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FontWeight)) {
            return false;
        }
        return this.weight == ((FontWeight)other).weight;
    }

    public int hashCode() {
        return this.weight;
    }

    @NotNull
    public String toString() {
        return "FontWeight(weight=" + this.weight + ")";
    }

    static {
        Object[] objectArray = new FontWeight[]{W100, W200, W300, W400, W500, W600, W700, W800, W900};
        values = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontWeight getW400() {
            return W400;
        }

        @NotNull
        public final FontWeight getW500() {
            return W500;
        }

        @NotNull
        public final FontWeight getW700() {
            return W700;
        }

        @NotNull
        public final FontWeight getLight() {
            return Light;
        }

        @NotNull
        public final FontWeight getNormal() {
            return Normal;
        }

        @NotNull
        public final FontWeight getMedium() {
            return Medium;
        }

        @NotNull
        public final FontWeight getSemiBold() {
            return SemiBold;
        }

        @NotNull
        public final FontWeight getBold() {
            return Bold;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

