/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nSkiaParagraph.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph_skikoKt\n+ 7 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 8 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,672:1\n587#1,4:682\n587#1,4:706\n587#1,4:710\n587#1,4:737\n33#2:673\n33#2:741\n53#3,3:674\n60#3:715\n70#3:718\n70#3:720\n60#3:723\n60#3:726\n70#3:729\n60#3:732\n70#3:735\n53#3,3:742\n1#4:677\n11158#5:678\n11493#5,3:679\n661#6,10:686\n661#6,10:696\n65#7:714\n69#7:717\n69#7:719\n65#7:722\n65#7:725\n69#7:728\n65#7:731\n69#7:734\n22#8:716\n22#8:721\n22#8:724\n22#8:727\n22#8:730\n22#8:733\n22#8:736\n*S KotlinDebug\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n*L\n209#1:682,4\n316#1:706,4\n332#1:710,4\n486#1:737,4\n90#1:673\n567#1:741\n90#1:674,3\n395#1:715\n395#1:718\n415#1:720\n419#1:723\n444#1:726\n445#1:729\n446#1:732\n447#1:735\n567#1:742,3\n131#1:678\n131#1:679,3\n211#1:686,10\n255#1:696,10\n395#1:714\n395#1:717\n415#1:719\n419#1:722\n444#1:725\n445#1:728\n446#1:731\n447#1:734\n395#1:716\n415#1:721\n419#1:724\n444#1:727\n445#1:730\n446#1:733\n447#1:736\n*E\n"})
public final class SkiaParagraph
implements Paragraph {
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final long constraints;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    @Nullable
    private LineMetrics[] _lineMetrics;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, int overflow, long constraints) {
        void width$iv;
        void $this$layouter_u24lambda_u240;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter((Object)paragraphIntrinsics, (String)"paragraphIntrinsics");
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.constraints = constraints;
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        Object[] objectArray = new TextOverflow[]{TextOverflow.box-impl(TextOverflow.Companion.getEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getStartEllipsis-gIe3tQ8())};
        String ellipsisChar = CollectionsKt.listOf((Object[])objectArray).contains(TextOverflow.box-impl(overflow)) ? "\u2026" : "";
        $this$layouter_u24lambda_u240.setParagraphStyle(this.maxLines, ellipsisChar);
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        float f = this.getWidth();
        float height$iv = this.getHeight();
        boolean $i$f$Size = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv);
        this.layouter.setBrushSize-uvyYCjk(Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        this.paragraph.layout(this.getWidth());
    }

    @NotNull
    public final Font getDefaultFont$ui_text() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph value2) {
        this.paragraph = value2;
        this._lineMetrics = null;
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl(this.constraints);
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_firstBaseline__u24lambda_u241 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_firstBaseline__u24lambda_u241.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_lastBaseline__u24lambda_u242 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_lastBaseline__u24lambda_u242.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual((Object)this.getText(), (Object)"") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.paragraph.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect(it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start2, int end) {
        TextBox[] boxes = this.paragraph.getRectsForRange(start2, end, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path2 = SkiaBackedPath_skikoKt.Path();
        for (TextBox b : boxes) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath(path2), (org.jetbrains.skia.Rect)b.getRect(), null, (int)0, (int)6, null);
        }
        return path2;
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        double d;
        double d2;
        float horizontal = this.getHorizontalPosition(offset, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics line = lineMetrics;
        boolean isNewEmptyLine = offset - 1 == line.getStartIndex() && offset == this.getText().length();
        FontMetrics metrics = this.getDefaultFont$ui_text().getMetrics();
        double it = line.getAscent();
        boolean bl = false;
        if (isNewEmptyLine) {
            double ascent = -((double)metrics.getAscent());
            d2 = RangesKt.coerceAtMost((double)it, (double)ascent);
        } else {
            d2 = it;
        }
        double asc = d2;
        double it2 = line.getDescent();
        boolean bl2 = false;
        if (isNewEmptyLine) {
            double descent = metrics.getDescent();
            d = RangesKt.coerceAtMost((double)it2, (double)descent);
        } else {
            d = it2;
        }
        double desc = d;
        return new Rect(horizontal, (float)(line.getBaseline() - asc), horizontal, (float)(line.getBaseline() + desc));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    private final LineMetrics lineMetricsForOffset(int offset) {
        Object object;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        Object[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            object = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])$this$binarySearchFirstMatchingOrLast$iv), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(offset){
                final /* synthetic */ int $offset$inlined;
                {
                    this.$offset$inlined = n;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return this.$offset$inlined < it2.getEndIncludingNewline() ? 1 : -1;
                }
            }), (int)3, null);
            object = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost((int)(-index$iv - 1), (int)ArraysKt.getLastIndex((Object[])$this$binarySearchFirstMatchingOrLast$iv))];
        }
        return object;
    }

    @Override
    public float getLineHeight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public int getLineStart(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics metrics = lineMetrics;
        return visibleEnd ? (lineIndex > 0 && metrics.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics.getEndIndex() : (metrics.getStartIndex() < this.getText().length() && this.getText().charAt(metrics.getStartIndex()) == '\n' ? metrics.getStartIndex() : metrics.getEndExcludingWhitespaces())) : metrics.getEndIndex();
    }

    @Override
    public int getLineForOffset(int offset) {
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(vertical);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float vertical) {
        Object object;
        Object[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            object = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])$this$binarySearchFirstMatchingOrLast$iv), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(vertical){
                final /* synthetic */ float $vertical$inlined;
                {
                    this.$vertical$inlined = f;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return (double)this.$vertical$inlined < it2.getBaseline() + it2.getDescent() ? 1 : -1;
                }
            }), (int)3, null);
            object = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost((int)(-index$iv - 1), (int)ArraysKt.getLastIndex((Object[])$this$binarySearchFirstMatchingOrLast$iv))];
        }
        return object;
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset);
        boolean isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean isLtr = !isRtl;
        if (prevBox == null && nextBox == null) {
            f = this.getAlignedStartingPosition(isRtl);
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull((Object)textBox);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isLtr && prevBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isRtl && prevBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)))));
        }
        return f;
    }

    private final float getAlignedStartingPosition(boolean isRtl) {
        int n = this.layouter.getTextStyle().getTextAlign-e0LSkKk();
        return TextAlign.equals-impl0(n, TextAlign.Companion.getLeft-e0LSkKk()) ? 0.0f : (TextAlign.equals-impl0(n, TextAlign.Companion.getRight-e0LSkKk()) ? this.getWidth() : (TextAlign.equals-impl0(n, TextAlign.Companion.getCenter-e0LSkKk()) ? this.getWidth() / (float)2 : (TextAlign.equals-impl0(n, TextAlign.Companion.getStart-e0LSkKk()) ? (isRtl ? this.getWidth() : 0.0f) : (TextAlign.equals-impl0(n, TextAlign.Companion.getEnd-e0LSkKk()) ? (isRtl ? 0.0f : this.getWidth()) : 0.0f))));
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray = this._lineMetrics;
        if (this._lineMetrics == null) {
            LineMetrics[] lineMetricsArray2;
            LineMetrics[] it = lineMetricsArray2 = this.receiveLineMetrics();
            boolean bl = false;
            this._lineMetrics = it;
            lineMetricsArray = lineMetricsArray2;
        }
        LineMetrics[] lineMetrics = lineMetricsArray;
        return lineMetrics;
    }

    private final LineMetrics[] receiveLineMetrics() {
        LineMetrics[] lineMetrics = ((CharSequence)this.getText()).length() == 0 ? this.layouter.emptyLineMetrics$ui_text(this.paragraph) : this.paragraph.getLineMetrics();
        FontMetrics fontMetrics = this.getDefaultFont$ui_text().getMetrics();
        if (!(lineMetrics.length == 0)) {
            lineMetrics[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetrics[0], fontMetrics, this.layouter.getTextStyle());
            lineMetrics[lineMetrics.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetrics[lineMetrics.length - 1], fontMetrics, this.layouter.getTextStyle());
        }
        return lineMetrics;
    }

    private final TextBox getBoxForwardByOffset(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException(string.toString());
        }
        for (int to = offset + 1; to <= this.getText().length(); ++to) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(offset, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset, int end) {
        boolean isRtl;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        boolean bl = isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int from = offset - 1; from >= 0; --from) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(from, end, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from) == '\n') {
                TextBox textBox;
                if (!isRtl) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                    return new TextBox(rect, box.getDirection());
                }
                if (from == StringsKt.getLastIndex((CharSequence)this.getText())) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(this.getWidth(), box.getRect().getBottom(), this.getWidth(), bottom);
                    textBox = new TextBox(rect, box.getDirection());
                } else {
                    TextBox nextBox = (TextBox)ArraysKt.first((Object[])this.paragraph.getRectsForRange(offset, offset + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(nextBox.getRect().getLeft(), nextBox.getRect().getTop(), nextBox.getRect().getLeft(), nextBox.getRect().getBottom());
                    textBox = new TextBox(rect, nextBox.getDirection());
                }
                return textBox;
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(offset);
        Object object = textBox != null ? textBox.getDirection() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        boolean $i$f$unpackFloat2;
        float rightX;
        TextBox rects;
        TextBox textBox;
        boolean bl = false;
        long value$iv$iv = position;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        boolean bl2 = false;
        value$iv$iv = position;
        boolean $i$f$unpackFloat22 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        int glyphPosition = this.paragraph.getGlyphPositionAtCoordinate(f, Float.intBitsToFloat(bits$iv$iv$iv)).getPosition();
        $i$f$getY-impl = false;
        long value$iv$iv2 = position;
        boolean $i$f$unpackFloat23 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Float.intBitsToFloat(bits$iv$iv$iv2));
        if (lineMetrics == null) {
            return glyphPosition;
        }
        LineMetrics expectedLine = lineMetrics;
        boolean isNotEmptyLine = expectedLine.getStartIndex() < expectedLine.getEndIndex();
        $i$f$getX-impl = false;
        value$iv$iv2 = position;
        boolean $i$f$unpackFloat12 = false;
        bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
        $i$f$floatFromBits2 = false;
        if ((double)Float.intBitsToFloat(bits$iv$iv$iv2) > expectedLine.getLeft()) {
            $i$f$getX-impl = false;
            value$iv$iv2 = position;
            $i$f$unpackFloat12 = false;
            bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
            $i$f$floatFromBits2 = false;
            if ((double)Float.intBitsToFloat(bits$iv$iv$iv2) < expectedLine.getRight()) {
                return glyphPosition;
            }
        }
        float leftX = (textBox = (rects = isNotEmptyLine ? this.paragraph.getRectsForRange(expectedLine.getStartIndex(), expectedLine.isHardBreak() ? expectedLine.getEndIndex() : expectedLine.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null)) != null && (textBox = (TextBox[])ArraysKt.firstOrNull(textBox)) != null && (textBox = textBox.getRect()) != null ? textBox.getLeft() : (float)expectedLine.getLeft();
        TextBox textBox2 = rects;
        float f2 = rightX = textBox2 != null && (textBox2 = (TextBox)ArraysKt.lastOrNull((Object[])textBox2)) != null && (textBox2 = textBox2.getRect()) != null ? textBox2.getRight() : (float)expectedLine.getRight();
        if (leftX == rightX) {
            return glyphPosition;
        }
        int correctedGlyphPosition = glyphPosition;
        $i$f$getX-impl = false;
        long value$iv$iv3 = position;
        boolean $i$f$unpackFloat13 = false;
        int bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
        boolean $i$f$floatFromBits3 = false;
        if (Float.intBitsToFloat(bits$iv$iv$iv3) <= leftX) {
            $i$f$getY-impl = false;
            value$iv$iv3 = position;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
            $i$f$floatFromBits3 = false;
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(leftX + 1.0f, Float.intBitsToFloat(bits$iv$iv$iv3)).getPosition();
        } else {
            $i$f$getX-impl = false;
            value$iv$iv3 = position;
            $i$f$unpackFloat13 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            $i$f$floatFromBits3 = false;
            if (Float.intBitsToFloat(bits$iv$iv$iv3) >= rightX) {
                boolean isNeutralChar;
                $i$f$getY-impl = false;
                value$iv$iv3 = position;
                $i$f$unpackFloat2 = false;
                bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
                $i$f$floatFromBits3 = false;
                correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(rightX - 1.0f, Float.intBitsToFloat(bits$iv$iv$iv3)).getPosition();
                boolean bl3 = isNeutralChar = (0 <= correctedGlyphPosition ? correctedGlyphPosition < ((CharSequence)this.getText()).length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), correctedGlyphPosition)) : false;
                if (!isNeutralChar) {
                    TextBox textBox3 = SkiaParagraph.getBoxBackwardByOffset$default(this, correctedGlyphPosition, 0, 2, null);
                    if ((textBox3 != null ? textBox3.getDirection() : null) == Direction.RTL) {
                        --correctedGlyphPosition;
                    }
                }
            }
        }
        return correctedGlyphPosition;
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextBox textBox = this.getBoxForwardByOffset(offset);
        if (textBox == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(offset, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull((Object)textBox2);
        }
        TextBox box = textBox;
        return Rects_skikoKt.toComposeRect(box.getRect());
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException(string.toString());
        }
        if (offset < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(offset)) || offset == this.getText().length()) {
            return offset > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(offset - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset - 1)) : TextRangeKt.TextRange(offset, offset);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-LG529CI(@NotNull Canvas canvas, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_LG529CI_u24lambda_u2412;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u2412.setColor-8_81llA(color);
        $this$paint_LG529CI_u24lambda_u2412.setTextStyle(shadow, textDecoration);
        $this$paint_LG529CI_u24lambda_u2412.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u2412.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_LG529CI_u24lambda_u2412.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha2, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_hn5TExg_u24lambda_u2413;
        void width$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        float f = this.getWidth();
        float height$iv = this.getHeight();
        boolean $i$f$Size = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv);
        $this$paint_hn5TExg_u24lambda_u2413.setBrush-12SF9DM(brush, Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL), alpha2);
        $this$paint_hn5TExg_u24lambda_u2413.setTextStyle(shadow, textDecoration);
        $this$paint_hn5TExg_u24lambda_u2413.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u2413.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_hn5TExg_u24lambda_u2413.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    public /* synthetic */ SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, int overflow, long constraints, DefaultConstructorMarker $constructor_marker) {
        this(paragraphIntrinsics, maxLines, overflow, constraints);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

