/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.ParagraphStyleKt;
import androidx.compose.ui.text.PlatformParagraphStyle;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.text.style.Hyphens;
import androidx.compose.ui.text.style.LineBreak;
import androidx.compose.ui.text.style.LineHeightStyle;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDirection;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.text.style.TextMotion;
import androidx.compose.ui.unit.TextUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nParagraphStyle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphStyle.kt\nandroidx/compose/ui/text/ParagraphStyle\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,535:1\n81#2,4:536\n*S KotlinDebug\n*F\n+ 1 ParagraphStyle.kt\nandroidx/compose/ui/text/ParagraphStyle\n*L\n208#1:536,4\n*E\n"})
public final class ParagraphStyle
implements AnnotatedString.Annotation {
    private final int textAlign;
    private final int textDirection;
    private final long lineHeight;
    @Nullable
    private final TextIndent textIndent;
    @Nullable
    private final PlatformParagraphStyle platformStyle;
    @Nullable
    private final LineHeightStyle lineHeightStyle;
    private final int lineBreak;
    private final int hyphens;
    @Nullable
    private final TextMotion textMotion;

    private ParagraphStyle(int textAlign, int textDirection, long lineHeight, TextIndent textIndent, PlatformParagraphStyle platformStyle, LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, TextMotion textMotion) {
        this.textAlign = textAlign;
        this.textDirection = textDirection;
        this.lineHeight = lineHeight;
        this.textIndent = textIndent;
        this.platformStyle = platformStyle;
        this.lineHeightStyle = lineHeightStyle;
        this.lineBreak = lineBreak;
        this.hyphens = hyphens;
        this.textMotion = textMotion;
        if (!TextUnit.equals-impl0(this.lineHeight, TextUnit.Companion.getUnspecified-XSAIIZE())) {
            boolean value$iv = TextUnit.getValue-impl(this.lineHeight) >= 0.0f;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("lineHeight can't be negative (" + TextUnit.getValue-impl(this.lineHeight) + ")");
            }
        }
    }

    public final int getTextAlign-e0LSkKk() {
        return this.textAlign;
    }

    public final int getTextDirection-s_7X-co() {
        return this.textDirection;
    }

    public final long getLineHeight-XSAIIZE() {
        return this.lineHeight;
    }

    @Nullable
    public final TextIndent getTextIndent() {
        return this.textIndent;
    }

    @Nullable
    public final PlatformParagraphStyle getPlatformStyle() {
        return this.platformStyle;
    }

    @Nullable
    public final LineHeightStyle getLineHeightStyle() {
        return this.lineHeightStyle;
    }

    public final int getLineBreak-rAG3T2k() {
        return this.lineBreak;
    }

    public final int getHyphens-vmbZdU8() {
        return this.hyphens;
    }

    @Nullable
    public final TextMotion getTextMotion() {
        return this.textMotion;
    }

    @NotNull
    public final ParagraphStyle merge(@Nullable ParagraphStyle other) {
        if (other == null) {
            return this;
        }
        return ParagraphStyleKt.fastMerge-j5T8yCg(this, other.textAlign, other.textDirection, other.lineHeight, other.textIndent, other.platformStyle, other.lineHeightStyle, other.lineBreak, other.hyphens, other.textMotion);
    }

    @NotNull
    public final ParagraphStyle copy-ykzQM6k(int textAlign, int textDirection, long lineHeight, @Nullable TextIndent textIndent, @Nullable PlatformParagraphStyle platformStyle, @Nullable LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, @Nullable TextMotion textMotion) {
        return new ParagraphStyle(textAlign, textDirection, lineHeight, textIndent, platformStyle, lineHeightStyle, lineBreak, hyphens, textMotion, null);
    }

    public static /* synthetic */ ParagraphStyle copy-ykzQM6k$default(ParagraphStyle paragraphStyle, int n, int n2, long l, TextIndent textIndent, PlatformParagraphStyle platformParagraphStyle, LineHeightStyle lineHeightStyle, int n3, int n4, TextMotion textMotion, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = paragraphStyle.textAlign;
        }
        if ((n5 & 2) != 0) {
            n2 = paragraphStyle.textDirection;
        }
        if ((n5 & 4) != 0) {
            l = paragraphStyle.lineHeight;
        }
        if ((n5 & 8) != 0) {
            textIndent = paragraphStyle.textIndent;
        }
        if ((n5 & 0x10) != 0) {
            platformParagraphStyle = paragraphStyle.platformStyle;
        }
        if ((n5 & 0x20) != 0) {
            lineHeightStyle = paragraphStyle.lineHeightStyle;
        }
        if ((n5 & 0x40) != 0) {
            n3 = paragraphStyle.lineBreak;
        }
        if ((n5 & 0x80) != 0) {
            n4 = paragraphStyle.hyphens;
        }
        if ((n5 & 0x100) != 0) {
            textMotion = paragraphStyle.textMotion;
        }
        return paragraphStyle.copy-ykzQM6k(n, n2, l, textIndent, platformParagraphStyle, lineHeightStyle, n3, n4, textMotion);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParagraphStyle)) {
            return false;
        }
        if (!TextAlign.equals-impl0(this.textAlign, ((ParagraphStyle)other).textAlign)) {
            return false;
        }
        if (!TextDirection.equals-impl0(this.textDirection, ((ParagraphStyle)other).textDirection)) {
            return false;
        }
        if (!TextUnit.equals-impl0(this.lineHeight, ((ParagraphStyle)other).lineHeight)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textIndent, (Object)((ParagraphStyle)other).textIndent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.platformStyle, (Object)((ParagraphStyle)other).platformStyle)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineHeightStyle, (Object)((ParagraphStyle)other).lineHeightStyle)) {
            return false;
        }
        if (!LineBreak.equals-impl0(this.lineBreak, ((ParagraphStyle)other).lineBreak)) {
            return false;
        }
        if (!Hyphens.equals-impl0(this.hyphens, ((ParagraphStyle)other).hyphens)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textMotion, (Object)((ParagraphStyle)other).textMotion);
    }

    public int hashCode() {
        int result2 = TextAlign.hashCode-impl(this.textAlign);
        result2 = 31 * result2 + TextDirection.hashCode-impl(this.textDirection);
        result2 = 31 * result2 + TextUnit.hashCode-impl(this.lineHeight);
        TextIndent textIndent = this.textIndent;
        result2 = 31 * result2 + (textIndent != null ? textIndent.hashCode() : 0);
        PlatformParagraphStyle platformParagraphStyle = this.platformStyle;
        result2 = 31 * result2 + (platformParagraphStyle != null ? platformParagraphStyle.hashCode() : 0);
        LineHeightStyle lineHeightStyle = this.lineHeightStyle;
        result2 = 31 * result2 + (lineHeightStyle != null ? lineHeightStyle.hashCode() : 0);
        result2 = 31 * result2 + LineBreak.hashCode-impl(this.lineBreak);
        result2 = 31 * result2 + Hyphens.hashCode-impl(this.hyphens);
        TextMotion textMotion = this.textMotion;
        result2 = 31 * result2 + (textMotion != null ? textMotion.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append("ParagraphStyle(");
        $this$toString_u24lambda_u241.append("textAlign=" + TextAlign.toString-impl(this.textAlign) + ", ");
        $this$toString_u24lambda_u241.append("textDirection=" + TextDirection.toString-impl(this.textDirection) + ", ");
        $this$toString_u24lambda_u241.append("lineHeight=" + TextUnit.toString-impl(this.lineHeight) + ", ");
        $this$toString_u24lambda_u241.append("textIndent=" + this.textIndent + ", ");
        $this$toString_u24lambda_u241.append("platformStyle=" + this.platformStyle + ", ");
        $this$toString_u24lambda_u241.append("lineHeightStyle=" + this.lineHeightStyle + ", ");
        $this$toString_u24lambda_u241.append("lineBreak=" + LineBreak.toString-impl(this.lineBreak) + ", ");
        $this$toString_u24lambda_u241.append("hyphens=" + Hyphens.toString-impl(this.hyphens) + ", ");
        $this$toString_u24lambda_u241.append("textMotion=" + this.textMotion);
        $this$toString_u24lambda_u241.append(")");
        return stringBuilder.toString();
    }

    public /* synthetic */ ParagraphStyle(int textAlign, int textDirection, long lineHeight, TextIndent textIndent, PlatformParagraphStyle platformStyle, LineHeightStyle lineHeightStyle, int lineBreak, int hyphens, TextMotion textMotion, DefaultConstructorMarker $constructor_marker) {
        this(textAlign, textDirection, lineHeight, textIndent, platformStyle, lineHeightStyle, lineBreak, hyphens, textMotion);
    }
}

