/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMultiParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/ParagraphInfo\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n*L\n1#1,1227:1\n65#2:1228\n69#2:1231\n60#3:1229\n70#3:1232\n53#3,3:1234\n53#3,3:1238\n53#3,3:1242\n53#3,3:1246\n22#4:1230\n30#5:1233\n30#5:1237\n30#5:1241\n30#5:1245\n*S KotlinDebug\n*F\n+ 1 MultiParagraph.kt\nandroidx/compose/ui/text/ParagraphInfo\n*L\n1183#1:1228\n1183#1:1231\n1183#1:1229\n1183#1:1232\n1183#1:1234,3\n1191#1:1238,3\n1199#1:1242,3\n1209#1:1246,3\n1183#1:1230\n1183#1:1233\n1191#1:1237\n1199#1:1241\n1209#1:1245\n*E\n"})
public final class ParagraphInfo {
    @NotNull
    private final Paragraph paragraph;
    private final int startIndex;
    private final int endIndex;
    private int startLineIndex;
    private int endLineIndex;
    private float top;
    private float bottom;
    public static final int $stable = 8;

    public ParagraphInfo(@NotNull Paragraph paragraph, int startIndex, int endIndex, int startLineIndex, int endLineIndex, float top, float bottom) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        this.paragraph = paragraph;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.startLineIndex = startLineIndex;
        this.endLineIndex = endLineIndex;
        this.top = top;
        this.bottom = bottom;
    }

    @NotNull
    public final Paragraph getParagraph() {
        return this.paragraph;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final int getStartLineIndex() {
        return this.startLineIndex;
    }

    public final int getEndLineIndex() {
        return this.endLineIndex;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final int getLength() {
        return this.endIndex - this.startIndex;
    }

    public final int toLocalIndex(int $this$toLocalIndex) {
        return RangesKt.coerceIn((int)$this$toLocalIndex, (int)this.startIndex, (int)this.endIndex) - this.startIndex;
    }

    public final int toGlobalIndex(int $this$toGlobalIndex) {
        return $this$toGlobalIndex + this.startIndex;
    }

    public final int toLocalLineIndex(int $this$toLocalLineIndex) {
        return $this$toLocalLineIndex - this.startLineIndex;
    }

    public final int toGlobalLineIndex(int $this$toGlobalLineIndex) {
        return $this$toGlobalLineIndex + this.startLineIndex;
    }

    public final float toGlobalYPosition(float $this$toGlobalYPosition) {
        return $this$toGlobalYPosition + this.top;
    }

    public final float toLocalYPosition(float $this$toLocalYPosition) {
        return $this$toLocalYPosition - this.top;
    }

    /*
     * WARNING - void declaration
     */
    public final long toLocal-MK-Hz9U(long $this$toLocal_u2dMK_u2dHz9U) {
        void x$iv;
        boolean $i$f$getX-impl22 = false;
        long value$iv$iv = $this$toLocal_u2dMK_u2dHz9U;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float $i$f$getX-impl22 = Float.intBitsToFloat(bits$iv$iv$iv);
        boolean bl = false;
        long value$iv$iv2 = $this$toLocal_u2dMK_u2dHz9U;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float y$iv = Float.intBitsToFloat(bits$iv$iv$iv2) - this.top;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        return Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rect toGlobal(@NotNull Rect $this$toGlobal) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toGlobal, (String)"<this>");
        float f = 0.0f;
        float y$iv = this.top;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        return $this$toGlobal.translate-k-4lQ0M(Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path toGlobal(@NotNull Path $this$toGlobal) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toGlobal, (String)"<this>");
        float f = 0.0f;
        float y$iv = this.top;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        $this$toGlobal.translate-k-4lQ0M(Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        return $this$toGlobal;
    }

    public final long toGlobal-xdX6-G0(long $this$toGlobal_u2dxdX6_u2dG0, boolean treatZeroAsNull) {
        if (treatZeroAsNull && TextRange.equals-impl0($this$toGlobal_u2dxdX6_u2dG0, TextRange.Companion.getZero-d9O1mEE())) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        return TextRangeKt.TextRange(this.toGlobalIndex(TextRange.getStart-impl($this$toGlobal_u2dxdX6_u2dG0)), this.toGlobalIndex(TextRange.getEnd-impl($this$toGlobal_u2dxdX6_u2dG0)));
    }

    @NotNull
    public String toString() {
        return "ParagraphInfo(paragraph=" + this.paragraph + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", startLineIndex=" + this.startLineIndex + ", endLineIndex=" + this.endLineIndex + ", top=" + this.top + ", bottom=" + this.bottom + ")";
    }

    public int hashCode() {
        int result2 = this.paragraph.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.startIndex);
        result2 = result2 * 31 + Integer.hashCode(this.endIndex);
        result2 = result2 * 31 + Integer.hashCode(this.startLineIndex);
        result2 = result2 * 31 + Integer.hashCode(this.endLineIndex);
        result2 = result2 * 31 + Float.hashCode(this.top);
        result2 = result2 * 31 + Float.hashCode(this.bottom);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParagraphInfo)) {
            return false;
        }
        ParagraphInfo paragraphInfo = (ParagraphInfo)other;
        if (!Intrinsics.areEqual((Object)this.paragraph, (Object)paragraphInfo.paragraph)) {
            return false;
        }
        if (this.startIndex != paragraphInfo.startIndex) {
            return false;
        }
        if (this.endIndex != paragraphInfo.endIndex) {
            return false;
        }
        if (this.startLineIndex != paragraphInfo.startLineIndex) {
            return false;
        }
        if (this.endLineIndex != paragraphInfo.endLineIndex) {
            return false;
        }
        if (Float.compare(this.top, paragraphInfo.top) != 0) {
            return false;
        }
        return Float.compare(this.bottom, paragraphInfo.bottom) == 0;
    }
}

