/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessible;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

public final class ComposeSceneAccessible
implements Accessible {
    private final boolean forceEnableA11y;
    @NotNull
    private final Function0<List<AccessibilityController>> accessibilityControllersProvider;
    @NotNull
    private final Lazy a11yEnabled$delegate;
    @NotNull
    private final Lazy _accessibleContext$delegate;
    public static final int $stable = 8;

    public ComposeSceneAccessible(boolean forceEnableA11y, @NotNull Function0<? extends List<AccessibilityController>> accessibilityControllersProvider) {
        Intrinsics.checkNotNullParameter(accessibilityControllersProvider, (String)"accessibilityControllersProvider");
        this.forceEnableA11y = forceEnableA11y;
        this.accessibilityControllersProvider = accessibilityControllersProvider;
        this.a11yEnabled$delegate = LazyKt.lazy(() -> ComposeSceneAccessible.a11yEnabled_delegate$lambda$0(this));
        this._accessibleContext$delegate = LazyKt.lazy(() -> ComposeSceneAccessible._accessibleContext_delegate$lambda$1(this));
    }

    public /* synthetic */ ComposeSceneAccessible(boolean bl, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, (Function0<? extends List<AccessibilityController>>)function0);
    }

    private final boolean getA11yEnabled() {
        Lazy lazy = this.a11yEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    private final ComposeSceneAccessibleContext get_accessibleContext() {
        Lazy lazy = this._accessibleContext$delegate;
        return (ComposeSceneAccessibleContext)lazy.getValue();
    }

    @Override
    @Nullable
    public ComposeSceneAccessibleContext getAccessibleContext() {
        if (!this.getA11yEnabled()) {
            return null;
        }
        return this.get_accessibleContext();
    }

    private static final boolean a11yEnabled_delegate$lambda$0(ComposeSceneAccessible this$0) {
        return this$0.forceEnableA11y || !Intrinsics.areEqual((Object)System.getProperty("compose.accessibility.enable"), (Object)"false") && System.getenv("COMPOSE_DISABLE_ACCESSIBILITY") == null;
    }

    private static final ComposeSceneAccessibleContext _accessibleContext_delegate$lambda$1(ComposeSceneAccessible this$0) {
        return this$0.new ComposeSceneAccessibleContext();
    }

    public final class ComposeSceneAccessibleContext
    extends AccessibleContext
    implements AccessibleComponent {
        @NotNull
        public final List<AccessibilityController> getAccessibilityControllers$ui() {
            return (List)ComposeSceneAccessible.this.accessibilityControllersProvider.invoke();
        }

        private final AccessibilityController getAccessibilityController() {
            return (AccessibilityController)CollectionsKt.firstOrNull(this.getAccessibilityControllers$ui());
        }

        private final ComposeAccessible getMainOwnerAccessibleRoot() {
            AccessibilityController accessibilityController = this.getAccessibilityController();
            return accessibilityController != null ? accessibilityController.getRootAccessible() : null;
        }

        @Override
        @Nullable
        public Accessible getAccessibleAt(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            for (AccessibilityController controller : this.getAccessibilityControllers$ui()) {
                Accessible accessibleOnPoint;
                ComposeAccessible rootAccessible = controller.getRootAccessible();
                ComposeAccessible.ComposeAccessibleComponent context2 = rootAccessible.getComposeAccessibleContext();
                if (context2.getAccessibleAt(p) == null || Intrinsics.areEqual((Object)accessibleOnPoint, (Object)rootAccessible)) continue;
                return accessibleOnPoint;
            }
            return null;
        }

        @Override
        public boolean contains(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return true;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.getAccessibilityControllers$ui().size();
        }

        @Override
        @NotNull
        public Accessible getAccessibleChild(int i2) {
            return this.getAccessibilityControllers$ui().get(i2).getRootAccessible();
        }

        @Override
        @Nullable
        public Dimension getSize() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getSize() : null;
        }

        @Override
        @Nullable
        public Point getLocationOnScreen() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getLocationOnScreen() : null;
        }

        @Override
        @Nullable
        public Point getLocation() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getLocation() : null;
        }

        @Override
        @Nullable
        public Rectangle getBounds() {
            Object object = this.getMainOwnerAccessibleRoot();
            return object != null && (object = ((ComposeAccessible)object).getComposeAccessibleContext()) != null ? ((ComposeAccessible.ComposeAccessibleComponent)object).getBounds() : null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        @Nullable
        public Accessible getAccessibleParent() {
            return null;
        }

        @Override
        @NotNull
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        @NotNull
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            if (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()] == 1) {
                AccessibleRole accessibleRole2 = AccessibleRole.PANEL;
                accessibleRole = accessibleRole2;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole2, (String)"PANEL");
            } else {
                AccessibleRole accessibleRole3 = AccessibleRole.UNKNOWN;
                accessibleRole = accessibleRole3;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole3, (String)"UNKNOWN");
            }
            return accessibleRole;
        }

        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public void setLocation(@Nullable Point p) {
        }

        @Override
        public void setBounds(@Nullable Rectangle r) {
        }

        @Override
        public void setSize(@Nullable Dimension d) {
        }

        @Override
        public void setVisible(boolean b) {
        }

        @Override
        @Nullable
        public Color getBackground() {
            return null;
        }

        @Override
        public void setBackground(@Nullable Color c) {
        }

        @Override
        @Nullable
        public Color getForeground() {
            return null;
        }

        @Override
        public void setForeground(@Nullable Color c) {
        }

        @Override
        @Nullable
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(@Nullable Cursor cursor2) {
        }

        @Override
        @Nullable
        public Font getFont() {
            return null;
        }

        @Override
        public void setFont(@Nullable Font f) {
        }

        @Override
        @Nullable
        public FontMetrics getFontMetrics(@Nullable Font f) {
            return null;
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void addFocusListener(@Nullable FocusListener l) {
        }

        @Override
        public void removeFocusListener(@Nullable FocusListener l) {
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OS.values().length];
                try {
                    nArray[OS.MacOS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

