/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopTextInputService2Kt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nDesktopTextInputService2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopTextInputService2.kt\nandroidx/compose/ui/platform/InputMethodRequestsImpl\n+ 2 Rect.kt\nandroidx/compose/ui/geometry/Rect\n*L\n1#1,222:1\n56#2,6:223\n*S KotlinDebug\n*F\n+ 1 DesktopTextInputService2.kt\nandroidx/compose/ui/platform/InputMethodRequestsImpl\n*L\n155#1:223,6\n*E\n"})
final class InputMethodRequestsImpl
implements InputMethodRequests {
    @NotNull
    private final PlatformComponent component;
    @NotNull
    private final TextEditorState state;
    @NotNull
    private final Function1<Function1<? super TextEditingScope, Unit>, Unit> editText;
    @Nullable
    private Rect focusedRect;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;

    public InputMethodRequestsImpl(@NotNull PlatformComponent component, @NotNull TextEditorState state2, @NotNull Function1<? super Function1<? super TextEditingScope, Unit>, Unit> editText) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter(editText, (String)"editText");
        this.component = component;
        this.state = state2;
        this.editText = editText;
    }

    private final long getSelection-d9O1mEE() {
        return this.state.getSelection-d9O1mEE();
    }

    private final TextRange getComposition-MzsxiRA() {
        return this.state.getComposition-MzsxiRA();
    }

    public final void setFocusedRect(@Nullable Rect rect) {
        this.focusedRect = rect;
    }

    public final void setCharKeyPressed(boolean bl) {
        this.charKeyPressed = bl;
    }

    @Override
    @Nullable
    public TextHitInfo getLocationOffset(int x, int y) {
        if (this.getComposition-MzsxiRA() != null) {
            return TextHitInfo.leading(0);
        }
        return null;
    }

    @Override
    @Nullable
    public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        TextRange textRange = this.getComposition-MzsxiRA();
        int composedStartIndex = textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : 0;
        TextRange textRange2 = this.getComposition-MzsxiRA();
        int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl(textRange2.unbox-impl()) : 0;
        int caretIndex = TextRange.getStart-impl(this.getSelection-d9O1mEE());
        if (caretIndex < composedStartIndex) {
            return caretIndex;
        }
        if (caretIndex < composedEndIndex) {
            return composedStartIndex;
        }
        return caretIndex - (composedEndIndex - composedStartIndex);
    }

    @Override
    public int getCommittedTextLength() {
        TextRange textRange = this.getComposition-MzsxiRA();
        return this.state.length() - (textRange != null ? TextRange.getLength-impl(textRange.unbox-impl()) : 0);
    }

    @Override
    @NotNull
    public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
        if (this.charKeyPressed && OsArch_jvmKt.getHostOs() == OS.MacOS) {
            this.needToDeletePreviousChar = true;
        }
        String str = TextRangeKt.substring-FDrldGo(this.state, this.getSelection-d9O1mEE());
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(str).getIterator();
        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
        return attributedCharacterIterator;
    }

    @Override
    @Nullable
    public Rectangle getTextLocation(@Nullable TextHitInfo offset) {
        Rectangle rectangle;
        Rect rect = this.focusedRect;
        if (rect != null) {
            Rect it = rect;
            boolean bl = false;
            int x = (int)(it.getRight() / this.component.getDensity().getDensity()) + this.component.getLocationOnScreen().x;
            int y = (int)(it.getTop() / this.component.getDensity().getDensity()) + this.component.getLocationOnScreen().y;
            Rect this_$iv = it;
            boolean $i$f$getWidth = false;
            int n = (int)(this_$iv.getRight() - this_$iv.getLeft());
            this_$iv = it;
            boolean $i$f$getHeight = false;
            Rectangle rectangle2 = new Rectangle(x, y, n, (int)(this_$iv.getBottom() - this_$iv.getTop()));
            rectangle = rectangle2;
        } else {
            rectangle = null;
        }
        return rectangle;
    }

    @Override
    @NotNull
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
        TextRange comp = this.getComposition-MzsxiRA();
        long range = TextRangeKt.TextRange(RangesKt.coerceAtMost((int)beginIndex, (int)this.state.length()), RangesKt.coerceAtMost((int)endIndex, (int)this.state.length()));
        if (comp == null) {
            String res2 = TextRangeKt.substring-FDrldGo(this.state, range);
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res2).getIterator();
            Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
            return attributedCharacterIterator;
        }
        String committed = TextRangeKt.substring-FDrldGo(this.state, TextRangeKt.TextRange(RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl(range), TextRange.getMin-impl(comp.unbox-impl())), (int)this.state.length()), RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl(range), TextRange.getMax-impl(comp.unbox-impl())), (int)this.state.length())));
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
        return attributedCharacterIterator;
    }

    public final void replaceInputMethodText(@NotNull InputMethodEvent event) {
        Object object;
        Object committed;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object2 = event.getText();
        if (object2 == null || (object2 = DesktopTextInputService2Kt.access$toStringUntil((AttributedCharacterIterator)object2, event.getCommittedCharacterCount())) == null) {
            object2 = committed = "";
        }
        if ((object = event.getText()) == null || (object = DesktopTextInputService2Kt.access$toStringFrom((AttributedCharacterIterator)object, event.getCommittedCharacterCount())) == null) {
            object = "";
        }
        Object composing = object;
        this.editText.invoke(arg_0 -> InputMethodRequestsImpl.replaceInputMethodText$lambda$1(this, composing, committed, arg_0));
    }

    private static final Unit replaceInputMethodText$lambda$1(InputMethodRequestsImpl this$0, Object $composing, Object $committed, TextEditingScope $this$editText) {
        Intrinsics.checkNotNullParameter((Object)$this$editText, (String)"$this$editText");
        if (this$0.needToDeletePreviousChar && TextRange.getMin-impl(this$0.getSelection-d9O1mEE()) > 0 && ((CharSequence)$composing).length() == 0) {
            this$0.needToDeletePreviousChar = false;
            $this$editText.deleteSurroundingTextInCodePoints(1, 0);
        }
        $this$editText.commitText((CharSequence)$committed, 1);
        if (((CharSequence)$composing).length() > 0) {
            $this$editText.setComposingText((CharSequence)$composing, 1);
        }
        return Unit.INSTANCE;
    }
}

