/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,728:1\n684#1:739\n691#1,2:740\n687#1,6:742\n684#1:748\n684#1:749\n679#1:750\n666#1:752\n666#1:753\n35#2,5:729\n35#2,5:734\n69#3:751\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n503#1:739\n505#1:740,2\n507#1:742,6\n514#1:748\n516#1:749\n529#1:750\n651#1:752\n657#1:753\n405#1:729,5\n440#1:734,5\n529#1:751\n*E\n"})
public final class VelocityTrackerKt {
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    private static final void set(DataPointAtTime[] $this$set, int index, long time2, float dataPoint) {
        DataPointAtTime currentEntry = $this$set[index];
        if (currentEntry == null) {
            $this$set[index] = new DataPointAtTime(time2, dataPoint);
        } else {
            currentEntry.setTime(time2);
            currentEntry.setDataPoint(dataPoint);
        }
    }

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (VelocityTrackerAddPointsFix) {
            VelocityTrackerKt.addPointerInputChangeWithFix($this$addPointerInputChange, event);
        } else {
            VelocityTrackerKt.addPointerInputChangeLegacy($this$addPointerInputChange, event);
        }
    }

    private static final void addPointerInputChangeLegacy(VelocityTracker $this$addPointerInputChangeLegacy, PointerInputChange event) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(event.getPosition-F1C5BW0());
            $this$addPointerInputChangeLegacy.resetTracking();
        }
        long previousPointerPosition = 0L;
        previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long historicalDelta = Offset.minus-MK-Hz9U(it.getPosition-F1C5BW0(), previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), historicalDelta));
            $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
        }
        long delta = Offset.minus-MK-Hz9U(event.getPosition-F1C5BW0(), previousPointerPosition);
        $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U($this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), delta));
        $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(event.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
    }

    private static final void addPointerInputChangeWithFix(VelocityTracker $this$addPointerInputChangeWithFix, PointerInputChange event) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
            List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                HistoricalChange item$iv;
                HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(it.getUptimeMillis(), it.getOriginalEventPosition-F1C5BW0$ui());
            }
            $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(event.getUptimeMillis(), event.getOriginalEventPosition-F1C5BW0$ui());
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - $this$addPointerInputChangeWithFix.getLastMoveEventTimeStamp$ui() > 40L) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
        $this$addPointerInputChangeWithFix.setLastMoveEventTimeStamp$ui(event.getUptimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[] polyFitLeastSquares(@NotNull float[] x, @NotNull float[] y, int sampleCount, int degree, @NotNull float[] coefficients) {
        int $i$f$get;
        int $i$f$set;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        if (degree < 1) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= sampleCount ? sampleCount - 1 : degree;
        int m = sampleCount;
        int n = truncatedDegree + 1;
        boolean $i$f$Matrix = false;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        while (n2 < n) {
            int n3 = n2++;
            fArrayArray[n3] = new float[m];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] fArrayArray2 = a;
            boolean bl = false;
            float value$iv22 = 1.0f;
            $i$f$set = 0;
            $this$set$iv[row$iv][h] = value$iv22;
            for (int i2 = 1; i2 < n; ++i2) {
                void $this$get$iv;
                float[][] row$iv = a;
                float[][] value$iv22 = a;
                int row$iv2 = i2 - 1;
                $i$f$get = 0;
                value$iv22 = $this$get$iv[row$iv2][h] * x[h];
                $i$f$set = 0;
                $this$set$iv[i2][h] = value$iv22;
            }
        }
        boolean $i$f$Matrix2 = false;
        int $this$set$iv = 0;
        float[][] value$iv32 = new float[n][];
        while ($this$set$iv < n) {
            $i$f$set = $this$set$iv++;
            value$iv32[$i$f$set] = new float[m];
        }
        float[][] q = value$iv32;
        boolean $i$f$Matrix3 = false;
        int value$iv32 = 0;
        float[][] $i$f$set2 = new float[n][];
        while (value$iv32 < n) {
            $i$f$get = value$iv32++;
            $i$f$set2[$i$f$get] = new float[n];
        }
        float[][] r = $i$f$set2;
        for (int j = 0; j < n; ++j) {
            void $this$fastCoerceAtLeast$iv;
            float[] w = q[j];
            ArraysKt.copyInto((float[])a[j], (float[])w, (int)0, (int)0, (int)m);
            for (int i3 = 0; i3 < j; ++i3) {
                float[] z = q[i3];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n4 = h;
                    w[n4] = w[n4] - dot * z[h];
                }
            }
            float[] $this$norm$iv22 = w;
            boolean $i$f$norm = false;
            float $this$norm$iv22 = (float)Math.sqrt(VelocityTrackerKt.dot($this$norm$iv22, $this$norm$iv22));
            float minimumValue$iv2 = 1.0E-6f;
            boolean $i$f$fastCoerceAtLeast = false;
            float inverseNorm = 1.0f / ($this$fastCoerceAtLeast$iv < minimumValue$iv2 ? minimumValue$iv2 : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int minimumValue$iv2 = h++;
                w[minimumValue$iv2] = w[minimumValue$iv2] * inverseNorm;
            }
            float[] v = r[j];
            for (int i4 = 0; i4 < n; ++i4) {
                v[i4] = i4 < j ? 0.0f : VelocityTrackerKt.dot(w, a[i4]);
            }
        }
        float[] wy = y;
        for (int i5 = n - 1; -1 < i5; --i5) {
            float c = VelocityTrackerKt.dot(q[i5], wy);
            float[] ri = r[i5];
            int n5 = i5 + 1;
            int j = n - 1;
            if (n5 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == n5) break;
                    --j;
                }
            }
            coefficients[i5] = c / ri[i5];
        }
        return coefficients;
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time2, int sampleCount, boolean isDataDifferential) {
        float work = 0.0f;
        int start2 = sampleCount - 1;
        float nextTime = time2[start2];
        for (int i2 = start2; 0 < i2; --i2) {
            float currentTime = nextTime;
            if (currentTime == (nextTime = time2[i2 - 1])) continue;
            float dataPointsDelta = isDataDifferential ? -dataPoints[i2 - 1] : dataPoints[i2] - dataPoints[i2 - 1];
            float vCurr = dataPointsDelta / (currentTime - nextTime);
            boolean $i$f$kineticEnergyToVelocity = false;
            float vPrev = Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i2 != start2) continue;
            work *= 0.5f;
        }
        boolean $i$f$kineticEnergyToVelocity = false;
        return Math.signum(work) * (float)Math.sqrt((float)2 * Math.abs(work));
    }

    private static final float dot(float[] $this$dot, float[] a) {
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i2 = 0; i2 < n; ++i2) {
            result2 += $this$dot[i2] * a[i2];
        }
        return result2;
    }

    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index, long time2, float dataPoint) {
        VelocityTrackerKt.set($receiver, index, time2, dataPoint);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time2, int sampleCount, boolean isDataDifferential) {
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, time2, sampleCount, isDataDifferential);
    }
}

