/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.input.pointer.util.VelocityTracker_notMobileKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTracker1D\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,728:1\n57#2,4:729\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTracker1D\n*L\n301#1:729,4\n*E\n"})
public final class VelocityTracker1D {
    private final boolean isDataDifferential;
    @NotNull
    private final Strategy strategy;
    private final int minSampleSize;
    @NotNull
    private final DataPointAtTime[] samples;
    private int index;
    @NotNull
    private final float[] reusableDataPointsArray;
    @NotNull
    private final float[] reusableTimeArray;
    @NotNull
    private final float[] reusableVelocityCoefficients;
    public static final int $stable = 8;

    public VelocityTracker1D(boolean isDataDifferential, @NotNull Strategy strategy) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.isDataDifferential = isDataDifferential;
        this.strategy = strategy;
        if (this.isDataDifferential && this.strategy.equals((Object)Strategy.Lsq2)) {
            throw new IllegalStateException("Lsq2 not (yet) supported for differential axes");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.minSampleSize = n;
        this.samples = new DataPointAtTime[20];
        this.reusableDataPointsArray = new float[20];
        this.reusableTimeArray = new float[20];
        this.reusableVelocityCoefficients = new float[3];
    }

    public /* synthetic */ VelocityTracker1D(boolean bl, Strategy strategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            strategy = Strategy.Lsq2;
        }
        this(bl, strategy);
    }

    public VelocityTracker1D(boolean isDataDifferential) {
        this(isDataDifferential, Strategy.Impulse);
    }

    public final void addDataPoint(long timeMillis, float dataPoint) {
        this.index = (this.index + 1) % 20;
        VelocityTrackerKt.access$set(this.samples, this.index, timeMillis, dataPoint);
    }

    public final float calculateVelocity() {
        DataPointAtTime newestSample;
        float[] dataPoints = this.reusableDataPointsArray;
        float[] time2 = this.reusableTimeArray;
        int sampleCount = 0;
        int index = this.index;
        DataPointAtTime dataPointAtTime = this.samples[index];
        if (dataPointAtTime == null) {
            return 0.0f;
        }
        DataPointAtTime previousSample = newestSample = dataPointAtTime;
        boolean afterPointerStop = false;
        while (this.samples[index] != null) {
            DataPointAtTime sample;
            float age = newestSample.getTime() - sample.getTime();
            float delta = Math.abs(sample.getTime() - previousSample.getTime());
            DataPointAtTime dataPointAtTime2 = previousSample = this.strategy == Strategy.Lsq2 || this.isDataDifferential ? sample : newestSample;
            if (delta > 40.0f) {
                afterPointerStop = true;
                break;
            }
            if (age > 100.0f) break;
            dataPoints[sampleCount] = sample.getDataPoint();
            time2[sampleCount] = -age;
            index = (index == 0 ? 20 : index) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount >= this.minSampleSize && VelocityTracker_notMobileKt.shouldUseDataPoints(this, dataPoints, time2, sampleCount, afterPointerStop)) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
                case 1: {
                    f = VelocityTrackerKt.access$calculateImpulseVelocity(dataPoints, time2, sampleCount, this.isDataDifferential);
                    break;
                }
                case 2: {
                    f = this.calculateLeastSquaresVelocity(dataPoints, time2, sampleCount);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f * (float)1000;
        }
        return 0.0f;
    }

    public final float calculateVelocity(float maximumVelocity) {
        boolean value$iv = maximumVelocity > 0.0f;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("maximumVelocity should be a positive value. You specified=" + maximumVelocity);
        }
        float velocity = this.calculateVelocity();
        return velocity == 0.0f || Float.isNaN(velocity) ? 0.0f : (velocity > 0.0f ? RangesKt.coerceAtMost((float)velocity, (float)maximumVelocity) : RangesKt.coerceAtLeast((float)velocity, (float)(-maximumVelocity)));
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
        this.index = 0;
    }

    private final float calculateLeastSquaresVelocity(float[] dataPoints, float[] time2, int sampleCount) {
        float f;
        try {
            f = VelocityTrackerKt.polyFitLeastSquares(time2, dataPoints, sampleCount, 2, this.reusableVelocityCoefficients)[1];
        }
        catch (IllegalArgumentException exception) {
            f = 0.0f;
        }
        return f;
    }

    public VelocityTracker1D() {
        this(false, null, 3, null);
    }

    public static final class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy Lsq2 = new Strategy();
        public static final /* enum */ Strategy Impulse = new Strategy();
        private static final /* synthetic */ Strategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        static {
            $VALUES = strategyArray = new Strategy[]{Strategy.Lsq2, Strategy.Impulse};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Strategy.values().length];
            try {
                nArray[Strategy.Impulse.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Strategy.Lsq2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

