/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.vector.PathNode;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParserKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,546:1\n545#1:552\n35#2,5:547\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParserKt\n*L\n405#1:552\n207#1:547,5\n*E\n"})
public final class PathParserKt {
    @NotNull
    private static final float[] EmptyArray = new float[0];

    @NotNull
    public static final Path toPath(@NotNull List<? extends PathNode> $this$toPath, @NotNull Path target) {
        Intrinsics.checkNotNullParameter($this$toPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int fillType = target.getFillType-Rg-k1Os();
        target.rewind();
        target.setFillType-oQ8Xj4U(fillType);
        float currentX = 0.0f;
        float currentY = 0.0f;
        float ctrlX = 0.0f;
        float ctrlY = 0.0f;
        float segmentX = 0.0f;
        float segmentY = 0.0f;
        float reflectiveCtrlX = 0.0f;
        float reflectiveCtrlY = 0.0f;
        PathNode previousNode = null;
        previousNode = $this$toPath.isEmpty() ? (PathNode)PathNode.Close.INSTANCE : $this$toPath.get(0);
        List<? extends PathNode> $this$fastForEach$iv = $this$toPath;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            PathNode item$iv;
            PathNode node2 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            PathNode pathNode = node2;
            if (pathNode instanceof PathNode.Close) {
                currentX = segmentX;
                currentY = segmentY;
                ctrlX = segmentX;
                ctrlY = segmentY;
                target.close();
            } else if (pathNode instanceof PathNode.RelativeMoveTo) {
                target.relativeMoveTo(((PathNode.RelativeMoveTo)node2).getDx(), ((PathNode.RelativeMoveTo)node2).getDy());
                segmentX = currentX += ((PathNode.RelativeMoveTo)node2).getDx();
                segmentY = currentY += ((PathNode.RelativeMoveTo)node2).getDy();
            } else if (pathNode instanceof PathNode.MoveTo) {
                currentX = ((PathNode.MoveTo)node2).getX();
                currentY = ((PathNode.MoveTo)node2).getY();
                target.moveTo(((PathNode.MoveTo)node2).getX(), ((PathNode.MoveTo)node2).getY());
                segmentX = currentX;
                segmentY = currentY;
            } else if (pathNode instanceof PathNode.RelativeLineTo) {
                target.relativeLineTo(((PathNode.RelativeLineTo)node2).getDx(), ((PathNode.RelativeLineTo)node2).getDy());
                currentX += ((PathNode.RelativeLineTo)node2).getDx();
                currentY += ((PathNode.RelativeLineTo)node2).getDy();
            } else if (pathNode instanceof PathNode.LineTo) {
                target.lineTo(((PathNode.LineTo)node2).getX(), ((PathNode.LineTo)node2).getY());
                currentX = ((PathNode.LineTo)node2).getX();
                currentY = ((PathNode.LineTo)node2).getY();
            } else if (pathNode instanceof PathNode.RelativeHorizontalTo) {
                target.relativeLineTo(((PathNode.RelativeHorizontalTo)node2).getDx(), 0.0f);
                currentX += ((PathNode.RelativeHorizontalTo)node2).getDx();
            } else if (pathNode instanceof PathNode.HorizontalTo) {
                target.lineTo(((PathNode.HorizontalTo)node2).getX(), currentY);
                currentX = ((PathNode.HorizontalTo)node2).getX();
            } else if (pathNode instanceof PathNode.RelativeVerticalTo) {
                target.relativeLineTo(0.0f, ((PathNode.RelativeVerticalTo)node2).getDy());
                currentY += ((PathNode.RelativeVerticalTo)node2).getDy();
            } else if (pathNode instanceof PathNode.VerticalTo) {
                target.lineTo(currentX, ((PathNode.VerticalTo)node2).getY());
                currentY = ((PathNode.VerticalTo)node2).getY();
            } else if (pathNode instanceof PathNode.RelativeCurveTo) {
                target.relativeCubicTo(((PathNode.RelativeCurveTo)node2).getDx1(), ((PathNode.RelativeCurveTo)node2).getDy1(), ((PathNode.RelativeCurveTo)node2).getDx2(), ((PathNode.RelativeCurveTo)node2).getDy2(), ((PathNode.RelativeCurveTo)node2).getDx3(), ((PathNode.RelativeCurveTo)node2).getDy3());
                ctrlX = currentX + ((PathNode.RelativeCurveTo)node2).getDx2();
                ctrlY = currentY + ((PathNode.RelativeCurveTo)node2).getDy2();
                currentX += ((PathNode.RelativeCurveTo)node2).getDx3();
                currentY += ((PathNode.RelativeCurveTo)node2).getDy3();
            } else if (pathNode instanceof PathNode.CurveTo) {
                target.cubicTo(((PathNode.CurveTo)node2).getX1(), ((PathNode.CurveTo)node2).getY1(), ((PathNode.CurveTo)node2).getX2(), ((PathNode.CurveTo)node2).getY2(), ((PathNode.CurveTo)node2).getX3(), ((PathNode.CurveTo)node2).getY3());
                ctrlX = ((PathNode.CurveTo)node2).getX2();
                ctrlY = ((PathNode.CurveTo)node2).getY2();
                currentX = ((PathNode.CurveTo)node2).getX3();
                currentY = ((PathNode.CurveTo)node2).getY3();
            } else if (pathNode instanceof PathNode.RelativeReflectiveCurveTo) {
                if (previousNode.isCurve()) {
                    reflectiveCtrlX = currentX - ctrlX;
                    reflectiveCtrlY = currentY - ctrlY;
                } else {
                    reflectiveCtrlX = 0.0f;
                    reflectiveCtrlY = 0.0f;
                }
                target.relativeCubicTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.RelativeReflectiveCurveTo)node2).getDx1(), ((PathNode.RelativeReflectiveCurveTo)node2).getDy1(), ((PathNode.RelativeReflectiveCurveTo)node2).getDx2(), ((PathNode.RelativeReflectiveCurveTo)node2).getDy2());
                ctrlX = currentX + ((PathNode.RelativeReflectiveCurveTo)node2).getDx1();
                ctrlY = currentY + ((PathNode.RelativeReflectiveCurveTo)node2).getDy1();
                currentX += ((PathNode.RelativeReflectiveCurveTo)node2).getDx2();
                currentY += ((PathNode.RelativeReflectiveCurveTo)node2).getDy2();
            } else if (pathNode instanceof PathNode.ReflectiveCurveTo) {
                if (previousNode.isCurve()) {
                    reflectiveCtrlX = (float)2 * currentX - ctrlX;
                    reflectiveCtrlY = (float)2 * currentY - ctrlY;
                } else {
                    reflectiveCtrlX = currentX;
                    reflectiveCtrlY = currentY;
                }
                target.cubicTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.ReflectiveCurveTo)node2).getX1(), ((PathNode.ReflectiveCurveTo)node2).getY1(), ((PathNode.ReflectiveCurveTo)node2).getX2(), ((PathNode.ReflectiveCurveTo)node2).getY2());
                ctrlX = ((PathNode.ReflectiveCurveTo)node2).getX1();
                ctrlY = ((PathNode.ReflectiveCurveTo)node2).getY1();
                currentX = ((PathNode.ReflectiveCurveTo)node2).getX2();
                currentY = ((PathNode.ReflectiveCurveTo)node2).getY2();
            } else if (pathNode instanceof PathNode.RelativeQuadTo) {
                target.relativeQuadraticTo(((PathNode.RelativeQuadTo)node2).getDx1(), ((PathNode.RelativeQuadTo)node2).getDy1(), ((PathNode.RelativeQuadTo)node2).getDx2(), ((PathNode.RelativeQuadTo)node2).getDy2());
                ctrlX = currentX + ((PathNode.RelativeQuadTo)node2).getDx1();
                ctrlY = currentY + ((PathNode.RelativeQuadTo)node2).getDy1();
                currentX += ((PathNode.RelativeQuadTo)node2).getDx2();
                currentY += ((PathNode.RelativeQuadTo)node2).getDy2();
            } else if (pathNode instanceof PathNode.QuadTo) {
                target.quadraticTo(((PathNode.QuadTo)node2).getX1(), ((PathNode.QuadTo)node2).getY1(), ((PathNode.QuadTo)node2).getX2(), ((PathNode.QuadTo)node2).getY2());
                ctrlX = ((PathNode.QuadTo)node2).getX1();
                ctrlY = ((PathNode.QuadTo)node2).getY1();
                currentX = ((PathNode.QuadTo)node2).getX2();
                currentY = ((PathNode.QuadTo)node2).getY2();
            } else if (pathNode instanceof PathNode.RelativeReflectiveQuadTo) {
                if (previousNode.isQuad()) {
                    reflectiveCtrlX = currentX - ctrlX;
                    reflectiveCtrlY = currentY - ctrlY;
                } else {
                    reflectiveCtrlX = 0.0f;
                    reflectiveCtrlY = 0.0f;
                }
                target.relativeQuadraticTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.RelativeReflectiveQuadTo)node2).getDx(), ((PathNode.RelativeReflectiveQuadTo)node2).getDy());
                ctrlX = currentX + reflectiveCtrlX;
                ctrlY = currentY + reflectiveCtrlY;
                currentX += ((PathNode.RelativeReflectiveQuadTo)node2).getDx();
                currentY += ((PathNode.RelativeReflectiveQuadTo)node2).getDy();
            } else if (pathNode instanceof PathNode.ReflectiveQuadTo) {
                if (previousNode.isQuad()) {
                    reflectiveCtrlX = (float)2 * currentX - ctrlX;
                    reflectiveCtrlY = (float)2 * currentY - ctrlY;
                } else {
                    reflectiveCtrlX = currentX;
                    reflectiveCtrlY = currentY;
                }
                target.quadraticTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.ReflectiveQuadTo)node2).getX(), ((PathNode.ReflectiveQuadTo)node2).getY());
                ctrlX = reflectiveCtrlX;
                ctrlY = reflectiveCtrlY;
                currentX = ((PathNode.ReflectiveQuadTo)node2).getX();
                currentY = ((PathNode.ReflectiveQuadTo)node2).getY();
            } else if (pathNode instanceof PathNode.RelativeArcTo) {
                float arcStartX = ((PathNode.RelativeArcTo)node2).getArcStartDx() + currentX;
                float arcStartY = ((PathNode.RelativeArcTo)node2).getArcStartDy() + currentY;
                PathParserKt.drawArc(target, currentX, currentY, arcStartX, arcStartY, ((PathNode.RelativeArcTo)node2).getHorizontalEllipseRadius(), ((PathNode.RelativeArcTo)node2).getVerticalEllipseRadius(), ((PathNode.RelativeArcTo)node2).getTheta(), ((PathNode.RelativeArcTo)node2).isMoreThanHalf(), ((PathNode.RelativeArcTo)node2).isPositiveArc());
                currentX = arcStartX;
                currentY = arcStartY;
                ctrlX = currentX;
                ctrlY = currentY;
            } else if (pathNode instanceof PathNode.ArcTo) {
                PathParserKt.drawArc(target, currentX, currentY, ((PathNode.ArcTo)node2).getArcStartX(), ((PathNode.ArcTo)node2).getArcStartY(), ((PathNode.ArcTo)node2).getHorizontalEllipseRadius(), ((PathNode.ArcTo)node2).getVerticalEllipseRadius(), ((PathNode.ArcTo)node2).getTheta(), ((PathNode.ArcTo)node2).isMoreThanHalf(), ((PathNode.ArcTo)node2).isPositiveArc());
                currentX = ((PathNode.ArcTo)node2).getArcStartX();
                currentY = ((PathNode.ArcTo)node2).getArcStartY();
                ctrlX = currentX;
                ctrlY = currentY;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            previousNode = node2;
        }
        return target;
    }

    private static final void drawArc(Path p, double x0, double y0, double x1, double y1, double a, double b, double theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double $this$toRadians$iv = theta;
        boolean $i$f$toRadians = false;
        double thetaD = $this$toRadians$iv / (double)180 * Math.PI;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = (x0 * cosTheta + y0 * sinTheta) / a;
        double y0p = (-x0 * sinTheta + y0 * cosTheta) / b;
        double x1p = (x1 * cosTheta + y1 * sinTheta) / a;
        double y1p = (-x1 * sinTheta + y1 * cosTheta) / b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / (double)2;
        double ym = (y0p + y1p) / (double)2;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            PathParserKt.drawArc(p, x0, y0, x1, y1, a * (double)adjust, b * (double)adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        double cx = 0.0;
        double cy = 0.0;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= a;
        cx = cx * cosTheta - (cy *= b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        PathParserKt.arcToBezier(p, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static final void arcToBezier(Path p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start2, double sweep) {
        double eta1x = e1x;
        double eta1y = e1y;
        int numSegments = (int)Math.ceil(Math.abs(sweep * (double)4 / Math.PI));
        double eta1 = start2;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i2 = 0; i2 < numSegments; ++i2) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / (double)2);
            double alpha2 = Math.sin(eta2 - eta1) * (Math.sqrt((double)4 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / (double)3;
            double q1x = eta1x + alpha2 * ep1x;
            double q1y = eta1y + alpha2 * ep1y;
            double q2x = e2x - alpha2 * ep2x;
            double q2y = e2y - alpha2 * ep2y;
            p.cubicTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
            eta1 = eta2;
            eta1x = e2x;
            eta1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }
}

