/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.vector.PathNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PathBuilder {
    @NotNull
    private final ArrayList<PathNode> _nodes = new ArrayList(32);

    @NotNull
    public final List<PathNode> getNodes() {
        return this._nodes;
    }

    @NotNull
    public final PathBuilder close() {
        this._nodes.add(PathNode.Close.INSTANCE);
        return this;
    }

    @NotNull
    public final PathBuilder moveTo(float x, float y) {
        this._nodes.add(new PathNode.MoveTo(x, y));
        return this;
    }

    @NotNull
    public final PathBuilder moveToRelative(float dx, float dy) {
        this._nodes.add(new PathNode.RelativeMoveTo(dx, dy));
        return this;
    }

    @NotNull
    public final PathBuilder lineTo(float x, float y) {
        this._nodes.add(new PathNode.LineTo(x, y));
        return this;
    }

    @NotNull
    public final PathBuilder lineToRelative(float dx, float dy) {
        this._nodes.add(new PathNode.RelativeLineTo(dx, dy));
        return this;
    }

    @NotNull
    public final PathBuilder horizontalLineTo(float x) {
        this._nodes.add(new PathNode.HorizontalTo(x));
        return this;
    }

    @NotNull
    public final PathBuilder verticalLineTo(float y) {
        this._nodes.add(new PathNode.VerticalTo(y));
        return this;
    }

    @NotNull
    public final PathBuilder curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this._nodes.add(new PathNode.CurveTo(x1, y1, x2, y2, x3, y3));
        return this;
    }

    @NotNull
    public final PathBuilder curveToRelative(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        this._nodes.add(new PathNode.RelativeCurveTo(dx1, dy1, dx2, dy2, dx3, dy3));
        return this;
    }

    @NotNull
    public final PathBuilder reflectiveCurveToRelative(float dx1, float dy1, float dx2, float dy2) {
        this._nodes.add(new PathNode.RelativeReflectiveCurveTo(dx1, dy1, dx2, dy2));
        return this;
    }

    @NotNull
    public final PathBuilder arcTo(float horizontalEllipseRadius, float verticalEllipseRadius, float theta, boolean isMoreThanHalf, boolean isPositiveArc, float x1, float y1) {
        this._nodes.add(new PathNode.ArcTo(horizontalEllipseRadius, verticalEllipseRadius, theta, isMoreThanHalf, isPositiveArc, x1, y1));
        return this;
    }

    @NotNull
    public final PathBuilder arcToRelative(float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc, float dx1, float dy1) {
        this._nodes.add(new PathNode.RelativeArcTo(a, b, theta, isMoreThanHalf, isPositiveArc, dx1, dy1));
        return this;
    }
}

