/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WhitePoint {
    private final float x;
    private final float y;

    public WhitePoint(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    @Size(value=3L)
    @NotNull
    public final float[] toXyz$ui_graphics() {
        float[] fArray = new float[]{this.x / this.y, 1.0f, (1.0f - this.x - this.y) / this.y};
        return fArray;
    }

    @NotNull
    public String toString() {
        return "WhitePoint(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhitePoint)) {
            return false;
        }
        WhitePoint whitePoint = (WhitePoint)other;
        if (Float.compare(this.x, whitePoint.x) != 0) {
            return false;
        }
        return Float.compare(this.y, whitePoint.y) == 0;
    }
}

