/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.collection.MutableIntObjectMap;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Connector;
import androidx.compose.ui.graphics.colorspace.ConnectorKt;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nColorSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n+ 2 Connector.kt\nandroidx/compose/ui/graphics/colorspace/ConnectorKt\n+ 3 IntObjectMap.kt\nandroidx/collection/MutableIntObjectMap\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,717:1\n326#2:718\n679#3:719\n1#4:720\n*S KotlinDebug\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n*L\n401#1:718\n401#1:719\n401#1:720\n*E\n"})
public final class ColorSpaceKt {
    private static final Connector createConnector-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
        Connector connector;
        if (source == destination) {
            connector = Connector.Companion.identity$ui_graphics(source);
        } else if (ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) && ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
            Intrinsics.checkNotNull((Object)source, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
            Rgb rgb = (Rgb)source;
            Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
            connector = new Connector.RgbConnector(rgb, (Rgb)destination, intent, null);
        } else {
            connector = new Connector(source, destination, intent, null);
        }
        return connector;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Connector connect-YBCOT_4(@NotNull ColorSpace $this$connect_u2dYBCOT_4, @NotNull ColorSpace destination, int intent) {
        Connector connector;
        Intrinsics.checkNotNullParameter((Object)$this$connect_u2dYBCOT_4, (String)"$this$connect");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int srcId = $this$connect_u2dYBCOT_4.getId$ui_graphics();
        int dstId = destination.getId$ui_graphics();
        if ((srcId | dstId) < 0) {
            connector = ColorSpaceKt.createConnector-YBCOT_4($this$connect_u2dYBCOT_4, destination, intent);
        } else {
            void key$iv;
            void this_$iv;
            MutableIntObjectMap<Connector> mutableIntObjectMap = ConnectorKt.getConnectors();
            int n = 0;
            n = srcId | dstId << 6 | intent << 12;
            boolean $i$f$getOrPut = false;
            Object object = this_$iv.get((int)key$iv);
            if (object == null) {
                Connector connector2;
                boolean bl = false;
                Connector it$iv = connector2 = ColorSpaceKt.createConnector-YBCOT_4($this$connect_u2dYBCOT_4, destination, intent);
                boolean bl2 = false;
                this_$iv.set((int)key$iv, (Object)it$iv);
                object = connector2;
            }
            connector = (Connector)object;
        }
        return connector;
    }

    public static /* synthetic */ Connector connect-YBCOT_4$default(ColorSpace colorSpace, ColorSpace colorSpace2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorSpace2 = ColorSpaces.INSTANCE.getSrgb();
        }
        if ((n2 & 2) != 0) {
            n = RenderIntent.Companion.getPerceptual-uksYyKA();
        }
        return ColorSpaceKt.connect-YBCOT_4(colorSpace, colorSpace2, n);
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint, @NotNull Adaptation adaptation) {
        Intrinsics.checkNotNullParameter((Object)$this$adapt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)adaptation, (String)"adaptation");
        if (ColorModel.equals-impl0($this$adapt.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
            Rgb rgb = (Rgb)$this$adapt;
            if (ColorSpaceKt.compare(rgb.getWhitePoint(), whitePoint)) {
                return $this$adapt;
            }
            float[] xyz = whitePoint.toXyz$ui_graphics();
            float[] adaptationTransform = ColorSpaceKt.chromaticAdaptation(adaptation.getTransform$ui_graphics(), rgb.getWhitePoint().toXyz$ui_graphics(), xyz);
            float[] transform2 = ColorSpaceKt.mul3x3(adaptationTransform, rgb.getTransform$ui_graphics());
            return new Rgb(rgb, transform2, whitePoint);
        }
        return $this$adapt;
    }

    public static /* synthetic */ ColorSpace adapt$default(ColorSpace colorSpace, WhitePoint whitePoint, Adaptation adaptation, int n, Object object) {
        if ((n & 2) != 0) {
            adaptation = Adaptation.Companion.getBradford();
        }
        return ColorSpaceKt.adapt(colorSpace, whitePoint, adaptation);
    }

    public static final double rcpResponse(double x, double a, double b, double c, double d, double g) {
        return x >= d * c ? (Math.pow(x, 1.0 / g) - b) / a : x / c;
    }

    public static final double response(double x, double a, double b, double c, double d, double g) {
        return x >= d ? Math.pow(a * x + b, g) : c * x;
    }

    public static final double rcpResponse(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d * c ? (Math.pow(x - e, 1.0 / g) - b) / a : (x - f) / c;
    }

    public static final double response(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d ? Math.pow(a * x + b, g) + e : c * x + f;
    }

    public static final double absRcpResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpaceKt.rcpResponse(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    public static final double absResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpaceKt.response(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    public static final boolean compare(@NotNull WhitePoint a, @NotNull WhitePoint b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        return Math.abs(a.getX() - b.getX()) < 0.001f && Math.abs(a.getY() - b.getY()) < 0.001f;
    }

    public static final boolean compare(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        int n = a.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (Float.compare(a[i2], b[i2]) == 0 || !(Math.abs(a[i2] - b[i2]) > 0.001f)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final float[] inverse3x3(@NotNull float[] m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float a = m[0];
        float b = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i2 = m[8];
        float xA = e * i2 - f * h;
        float xB = f * g - d * i2;
        float xC = d * h - e * g;
        float det = a * xA + b * xB + c * xC;
        float[] inverted = new float[m.length];
        inverted[0] = xA / det;
        inverted[1] = xB / det;
        inverted[2] = xC / det;
        inverted[3] = (c * h - b * i2) / det;
        inverted[4] = (a * i2 - c * g) / det;
        inverted[5] = (b * g - a * h) / det;
        inverted[6] = (b * f - c * e) / det;
        inverted[7] = (c * d - a * f) / det;
        inverted[8] = (a * e - b * d) / det;
        return inverted;
    }

    @NotNull
    public static final float[] mul3x3(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] r = new float[9];
        if (lhs.length < 9) {
            return r;
        }
        if (rhs.length < 9) {
            return r;
        }
        r[0] = lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2];
        r[1] = lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2];
        r[2] = lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2];
        r[3] = lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5];
        r[4] = lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5];
        r[5] = lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5];
        r[6] = lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8];
        r[7] = lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8];
        r[8] = lhs[2] * rhs[6] + lhs[5] * rhs[7] + lhs[8] * rhs[8];
        return r;
    }

    @NotNull
    public static final float[] mul3x3Float3(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        if (lhs.length < 9) {
            return rhs;
        }
        if (rhs.length < 3) {
            return rhs;
        }
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
        return rhs;
    }

    @NotNull
    public static final float[] mul3x3Diag(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] fArray = new float[]{lhs[0] * rhs[0], lhs[1] * rhs[1], lhs[2] * rhs[2], lhs[0] * rhs[3], lhs[1] * rhs[4], lhs[2] * rhs[5], lhs[0] * rhs[6], lhs[1] * rhs[7], lhs[2] * rhs[8]};
        return fArray;
    }

    @NotNull
    public static final float[] chromaticAdaptation(@NotNull float[] matrix, @NotNull float[] srcWhitePoint, @NotNull float[] dstWhitePoint) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)srcWhitePoint, (String)"srcWhitePoint");
        Intrinsics.checkNotNullParameter((Object)dstWhitePoint, (String)"dstWhitePoint");
        float[] srcLMS = ColorSpaceKt.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpaceKt.mul3x3Float3(matrix, dstWhitePoint);
        float[] fArray = new float[]{dstLMS[0] / srcLMS[0], dstLMS[1] / srcLMS[1], dstLMS[2] / srcLMS[2]};
        float[] LMS = fArray;
        return ColorSpaceKt.mul3x3(ColorSpaceKt.inverse3x3(matrix), ColorSpaceKt.mul3x3Diag(LMS, matrix));
    }
}

