/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.DesktopImageAsset_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.ImageInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SkiaBackedImageBitmap
implements ImageBitmap {
    @NotNull
    private final Bitmap bitmap;
    @NotNull
    private final ColorSpace colorSpace;
    private final int config;
    private final boolean hasAlpha;

    public SkiaBackedImageBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.bitmap = bitmap;
        this.colorSpace = SkiaImageAsset_skikoKt.access$toComposeColorSpace(this.bitmap.getColorSpace());
        this.config = SkiaImageAsset_skikoKt.access$toComposeConfig(this.bitmap.getColorType());
        this.hasAlpha = !this.bitmap.isOpaque();
    }

    @NotNull
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public int getConfig-_sVssgQ() {
        return this.config;
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public void prepareToDraw() {
    }

    @Override
    public void readPixels(@NotNull int[] buffer, int startX, int startY, int width, int height, int bufferOffset, int stride) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int lastScanline = bufferOffset + (height - 1) * stride;
        if (!(startX >= 0 && startY >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(width > 0 && startX + width <= this.getWidth())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(height > 0 && startY + height <= this.getHeight())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(Math.abs(stride) >= width)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(bufferOffset >= 0 && bufferOffset + width <= buffer.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(lastScanline >= 0 && lastScanline + width <= buffer.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ColorInfo colorInfo = new ColorInfo(ColorType.BGRA_8888, ColorAlphaType.UNPREMUL, org.jetbrains.skia.ColorSpace.Companion.getSRGB());
        ImageInfo imageInfo = new ImageInfo(colorInfo, width, height);
        int bytesPerPixel = 4;
        byte[] byArray = this.bitmap.readPixels(imageInfo, stride * bytesPerPixel, startX, startY);
        Intrinsics.checkNotNull((Object)byArray);
        byte[] bytes2 = byArray;
        DesktopImageAsset_desktopKt.putBytesInto(bytes2, buffer, bufferOffset, bytes2.length / bytesPerPixel);
    }
}

