/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.PainterImage;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nDesktopImageConverters.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/DesktopImageConverters_desktopKt\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,266:1\n148#2:267\n*S KotlinDebug\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/DesktopImageConverters_desktopKt\n*L\n120#1:267\n*E\n"})
public final class DesktopImageConverters_desktopKt {
    @NotNull
    public static final Image toAwtImage-Ug5Nnss(@NotNull Painter $this$toAwtImage_u2dUg5Nnss, @NotNull Density density, @NotNull LayoutDirection layoutDirection, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtImage_u2dUg5Nnss, (String)"$this$toAwtImage");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        long $this$isSpecified$iv = size;
        boolean bl = false;
        if (!($this$isSpecified$iv != 9205357640488583168L)) {
            boolean bl2 = false;
            String string = "Cannot convert Painter with unspecified size. Please set size explicitly.";
            throw new IllegalArgumentException(string.toString());
        }
        return new PainterImage($this$toAwtImage_u2dUg5Nnss, density, layoutDirection, size, null);
    }

    @NotNull
    public static final BufferedImage toAwtImage(@NotNull ImageBitmap $this$toAwtImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtImage, (String)"<this>");
        int[] pixels = new int[$this$toAwtImage.getWidth() * $this$toAwtImage.getHeight()];
        ImageBitmap.readPixels$default($this$toAwtImage, pixels, 0, 0, 0, 0, 0, 0, 126, null);
        int a = -16777216;
        int r = 0xFF0000;
        int g = 65280;
        int b = 255;
        int[] nArray = new int[]{r, g, b, a};
        int[] bitMasks = nArray;
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(3, $this$toAwtImage.getWidth(), $this$toAwtImage.getHeight(), bitMasks);
        DataBufferInt db = new DataBufferInt(pixels, pixels.length);
        WritableRaster wr = Raster.createWritableRaster(sm, db, new Point());
        return new BufferedImage(ColorModel.getRGBdefault(), wr, false, null);
    }

    @NotNull
    public static final ImageBitmap toComposeImageBitmap(@NotNull BufferedImage $this$toComposeImageBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toComposeImageBitmap, (String)"<this>");
        int bytesPerPixel = 4;
        byte[] pixels = new byte[$this$toComposeImageBitmap.getWidth() * $this$toComposeImageBitmap.getHeight() * bytesPerPixel];
        int k = 0;
        int n = $this$toComposeImageBitmap.getHeight();
        for (int y = 0; y < n; ++y) {
            int n2 = $this$toComposeImageBitmap.getWidth();
            for (int x = 0; x < n2; ++x) {
                int argb = $this$toComposeImageBitmap.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                pixels[k++] = (byte)b;
                pixels[k++] = (byte)g;
                pixels[k++] = (byte)r;
                pixels[k++] = (byte)a;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32($this$toComposeImageBitmap.getWidth(), $this$toComposeImageBitmap.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(pixels);
        return SkiaImageAsset_skikoKt.asComposeImageBitmap(bitmap);
    }
}

