/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.draw.PainterNode;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.LayoutModifierNodeKt;
import androidx.compose.ui.node.ModifierNodeElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PainterElement
extends ModifierNodeElement<PainterNode> {
    @NotNull
    private final Painter painter;
    private final boolean sizeToIntrinsics;
    @NotNull
    private final Alignment alignment;
    @NotNull
    private final ContentScale contentScale;
    private final float alpha;
    @Nullable
    private final ColorFilter colorFilter;

    public PainterElement(@NotNull Painter painter, boolean sizeToIntrinsics, @NotNull Alignment alignment, @NotNull ContentScale contentScale, float alpha2, @Nullable ColorFilter colorFilter) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        this.painter = painter;
        this.sizeToIntrinsics = sizeToIntrinsics;
        this.alignment = alignment;
        this.contentScale = contentScale;
        this.alpha = alpha2;
        this.colorFilter = colorFilter;
    }

    @Override
    @NotNull
    public PainterNode create() {
        return new PainterNode(this.painter, this.sizeToIntrinsics, this.alignment, this.contentScale, this.alpha, this.colorFilter);
    }

    @Override
    public void update(@NotNull PainterNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        boolean intrinsicsChanged = node2.getSizeToIntrinsics() != this.sizeToIntrinsics || this.sizeToIntrinsics && !Size.equals-impl0(node2.getPainter().getIntrinsicSize-NH-jbRc(), this.painter.getIntrinsicSize-NH-jbRc());
        node2.setPainter(this.painter);
        node2.setSizeToIntrinsics(this.sizeToIntrinsics);
        node2.setAlignment(this.alignment);
        node2.setContentScale(this.contentScale);
        node2.setAlpha(this.alpha);
        node2.setColorFilter(this.colorFilter);
        if (intrinsicsChanged) {
            LayoutModifierNodeKt.invalidateMeasurement(node2);
        }
        DrawModifierNodeKt.invalidateDraw(node2);
    }

    @NotNull
    public String toString() {
        return "PainterElement(painter=" + this.painter + ", sizeToIntrinsics=" + this.sizeToIntrinsics + ", alignment=" + this.alignment + ", contentScale=" + this.contentScale + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ")";
    }

    public int hashCode() {
        int result2 = this.painter.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.sizeToIntrinsics);
        result2 = result2 * 31 + this.alignment.hashCode();
        result2 = result2 * 31 + this.contentScale.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + (this.colorFilter == null ? 0 : this.colorFilter.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PainterElement)) {
            return false;
        }
        PainterElement painterElement = (PainterElement)other;
        if (!Intrinsics.areEqual((Object)this.painter, (Object)painterElement.painter)) {
            return false;
        }
        if (this.sizeToIntrinsics != painterElement.sizeToIntrinsics) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alignment, (Object)painterElement.alignment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentScale, (Object)painterElement.contentScale)) {
            return false;
        }
        if (Float.compare(this.alpha, painterElement.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorFilter, (Object)painterElement.colorFilter);
    }
}

