/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui;

import androidx.compose.ui.CombinedModifier;
import androidx.compose.ui.ModifierNodeDetachedCancellationException;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.ObserverNodeOwnerScope;
import java.util.concurrent.CancellationException;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Modifier {
    @NotNull
    public static final Companion Companion = androidx.compose.ui.Modifier$Companion.$$INSTANCE;

    public <R> R foldIn(R var1, @NotNull Function2<? super R, ? super Element, ? extends R> var2);

    public boolean all(@NotNull Function1<? super Element, Boolean> var1);

    @NotNull
    default public Modifier then(@NotNull Modifier other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other == Companion ? this : (Modifier)new CombinedModifier(this, other);
    }

    public static final class Companion
    implements Modifier {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Override
        public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Element, ? extends R> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            return initial;
        }

        @Override
        public boolean all(@NotNull Function1<? super Element, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            return true;
        }

        @Override
        @NotNull
        public Modifier then(@NotNull Modifier other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other;
        }

        @NotNull
        public String toString() {
            return "Modifier";
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    public static interface Element
    extends Modifier {
        @Override
        default public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Element, ? extends R> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            return (R)operation.invoke(initial, (Object)this);
        }

        @Override
        default public boolean all(@NotNull Function1<? super Element, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            return (Boolean)predicate.invoke((Object)this);
        }
    }

    @SourceDebugExtension(value={"SMAP\nModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Modifier.kt\nandroidx/compose/ui/Modifier$Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,421:1\n1#2:422\n57#3,4:423\n57#3,4:427\n57#3,4:431\n57#3,4:435\n57#3,4:439\n57#3,4:443\n57#3,4:447\n57#3,4:451\n57#3,4:455\n57#3,4:459\n57#3,4:463\n*S KotlinDebug\n*F\n+ 1 Modifier.kt\nandroidx/compose/ui/Modifier$Node\n*L\n255#1:423,4\n256#1:427,4\n264#1:431,4\n267#1:435,4\n276#1:439,4\n277#1:443,4\n280#1:447,4\n290#1:451,4\n291#1:455,4\n294#1:459,4\n306#1:463,4\n*E\n"})
    public static abstract class Node
    implements DelegatableNode {
        @NotNull
        private Node node = this;
        @Nullable
        private CoroutineScope scope;
        private int kindSet;
        private int aggregateChildKindSet = -1;
        @Nullable
        private Node parent;
        @Nullable
        private Node child;
        @Nullable
        private ObserverNodeOwnerScope ownerScope;
        @Nullable
        private NodeCoordinator coordinator;
        private boolean insertedNodeAwaitingAttachForInvalidation;
        private boolean updatedNodeAwaitingAttachForInvalidation;
        private boolean onAttachRunExpected;
        private boolean onDetachRunExpected;
        @Nullable
        private Function0<Unit> detachedListener;
        private boolean isAttached;
        public static final int $stable = 8;

        @Override
        @NotNull
        public final Node getNode() {
            return this.node;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            CoroutineScope coroutineScope = this.scope;
            if (coroutineScope == null) {
                CoroutineScope coroutineScope2;
                CoroutineScope it = coroutineScope2 = CoroutineScopeKt.CoroutineScope((CoroutineContext)DelegatableNodeKt.requireOwner(this).getCoroutineContext().plus((CoroutineContext)JobKt.Job((Job)((Job)DelegatableNodeKt.requireOwner(this).getCoroutineContext().get((CoroutineContext.Key)Job.Key)))));
                boolean bl = false;
                this.scope = it;
                coroutineScope = coroutineScope2;
            }
            return coroutineScope;
        }

        public final int getKindSet$ui() {
            return this.kindSet;
        }

        public final void setKindSet$ui(int n) {
            this.kindSet = n;
        }

        public final int getAggregateChildKindSet$ui() {
            return this.aggregateChildKindSet;
        }

        public final void setAggregateChildKindSet$ui(int n) {
            this.aggregateChildKindSet = n;
        }

        @Nullable
        public final Node getParent$ui() {
            return this.parent;
        }

        public final void setParent$ui(@Nullable Node node2) {
            this.parent = node2;
        }

        @Nullable
        public final Node getChild$ui() {
            return this.child;
        }

        public final void setChild$ui(@Nullable Node node2) {
            this.child = node2;
        }

        @Nullable
        public final ObserverNodeOwnerScope getOwnerScope$ui() {
            return this.ownerScope;
        }

        public final void setOwnerScope$ui(@Nullable ObserverNodeOwnerScope observerNodeOwnerScope) {
            this.ownerScope = observerNodeOwnerScope;
        }

        @Nullable
        public final NodeCoordinator getCoordinator$ui() {
            return this.coordinator;
        }

        public final boolean getInsertedNodeAwaitingAttachForInvalidation$ui() {
            return this.insertedNodeAwaitingAttachForInvalidation;
        }

        public final void setInsertedNodeAwaitingAttachForInvalidation$ui(boolean bl) {
            this.insertedNodeAwaitingAttachForInvalidation = bl;
        }

        public final boolean getUpdatedNodeAwaitingAttachForInvalidation$ui() {
            return this.updatedNodeAwaitingAttachForInvalidation;
        }

        public final void setUpdatedNodeAwaitingAttachForInvalidation$ui(boolean bl) {
            this.updatedNodeAwaitingAttachForInvalidation = bl;
        }

        public final void setDetachedListener$ui(@Nullable Function0<Unit> function0) {
            this.detachedListener = function0;
        }

        public final boolean isAttached() {
            return this.isAttached;
        }

        public boolean getShouldAutoInvalidate() {
            return true;
        }

        public void updateCoordinator$ui(@Nullable NodeCoordinator coordinator) {
            this.coordinator = coordinator;
        }

        public void markAsAttached$ui() {
            boolean value$iv = !this.isAttached;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("node attached multiple times");
            }
            value$iv = this.coordinator != null;
            $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("attach invoked on a node without a coordinator");
            }
            this.isAttached = true;
            this.onAttachRunExpected = true;
        }

        public void runAttachLifecycle$ui() {
            boolean value$iv = this.isAttached;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("Must run markAsAttached() prior to runAttachLifecycle");
            }
            value$iv = this.onAttachRunExpected;
            $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("Must run runAttachLifecycle() only once after markAsAttached()");
            }
            this.onAttachRunExpected = false;
            this.onAttach();
            this.onDetachRunExpected = true;
        }

        public void runDetachLifecycle$ui() {
            boolean value$iv = this.isAttached;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("node detached multiple times");
            }
            value$iv = this.coordinator != null;
            $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("detach invoked on a node without a coordinator");
            }
            value$iv = this.onDetachRunExpected;
            $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("Must run runDetachLifecycle() once after runAttachLifecycle() and before markAsDetached()");
            }
            this.onDetachRunExpected = false;
            Function0<Unit> function0 = this.detachedListener;
            if (function0 != null) {
                function0.invoke();
            }
            this.onDetach();
        }

        public void markAsDetached$ui() {
            block3: {
                boolean value$iv = this.isAttached;
                boolean $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("Cannot detach a node that is not attached");
                }
                value$iv = !this.onAttachRunExpected;
                $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("Must run runAttachLifecycle() before markAsDetached()");
                }
                value$iv = !this.onDetachRunExpected;
                $i$f$checkPrecondition = false;
                if (!value$iv) {
                    boolean bl = false;
                    InlineClassHelperKt.throwIllegalStateException("Must run runDetachLifecycle() before markAsDetached()");
                }
                this.isAttached = false;
                CoroutineScope coroutineScope = this.scope;
                if (coroutineScope == null) break block3;
                CoroutineScope it = coroutineScope;
                boolean bl = false;
                CoroutineScopeKt.cancel((CoroutineScope)it, (CancellationException)new ModifierNodeDetachedCancellationException());
                this.scope = null;
            }
        }

        public void reset$ui() {
            boolean value$iv = this.isAttached;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("reset() called on an unattached node");
            }
            this.onReset();
        }

        public void onAttach() {
        }

        public void onDetach() {
        }

        public void onReset() {
        }

        public final void sideEffect(@NotNull Function0<Unit> effect2) {
            Intrinsics.checkNotNullParameter(effect2, (String)"effect");
            DelegatableNodeKt.requireOwner(this).registerOnEndApplyChangesListener(effect2);
        }

        public void setAsDelegateTo$ui(@NotNull Node owner2) {
            Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
            this.node = owner2;
        }
    }
}

