/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.snapshots.SnapshotStateMap;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSnapshotStateMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateMap.kt\nandroidx/compose/runtime/snapshots/StateMapMutableIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n360#1,4:417\n1#2:421\n1#2:422\n*S KotlinDebug\n*F\n+ 1 SnapshotStateMap.kt\nandroidx/compose/runtime/snapshots/StateMapMutableIterator\n*L\n341#1:417,4\n341#1:421\n*E\n"})
abstract class StateMapMutableIterator<K, V> {
    @NotNull
    private final SnapshotStateMap<K, V> map;
    @NotNull
    private final Iterator<Map.Entry<K, V>> iterator;
    private int modification;
    @Nullable
    private Map.Entry<? extends K, ? extends V> current;
    @Nullable
    private Map.Entry<? extends K, ? extends V> next;

    public StateMapMutableIterator(@NotNull SnapshotStateMap<K, V> map2, @NotNull Iterator<? extends Map.Entry<? extends K, ? extends V>> iterator2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
        this.map = map2;
        this.iterator = iterator2;
        this.modification = this.map.getModification$runtime();
        this.advance();
    }

    @NotNull
    public final SnapshotStateMap<K, V> getMap() {
        return this.map;
    }

    @Nullable
    protected final Map.Entry<K, V> getCurrent() {
        return this.current;
    }

    @Nullable
    protected final Map.Entry<K, V> getNext() {
        return this.next;
    }

    public final void remove() {
        Unit unit;
        StateMapMutableIterator this_$iv = this;
        boolean $i$f$modify = false;
        if (this_$iv.getMap().getModification$runtime() != this_$iv.modification) {
            throw new ConcurrentModificationException();
        }
        boolean bl = false;
        Map.Entry<K, V> value2 = this.current;
        if (value2 == null) {
            throw new IllegalStateException();
        }
        this.map.remove(value2.getKey());
        this.current = null;
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl2 = false;
        this_$iv.modification = this_$iv.getMap().getModification$runtime();
    }

    public final boolean hasNext() {
        return this.next != null;
    }

    protected final void advance() {
        this.current = this.next;
        this.next = this.iterator.hasNext() ? this.iterator.next() : null;
    }
}

