/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateListKt;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSnapshotStateList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateList.kt\nandroidx/compose/runtime/snapshots/StateListIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,539:1\n1#2:540\n*E\n"})
final class StateListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    @NotNull
    private final SnapshotStateList<T> list;
    private int index;
    private int lastRequested;
    private int structure;

    public StateListIterator(@NotNull SnapshotStateList<T> list2, int offset) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.list = list2;
        this.index = offset - 1;
        this.lastRequested = -1;
        this.structure = this.list.getStructure$runtime();
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= 0;
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public T previous() {
        T t2;
        this.validateModification();
        SnapshotStateListKt.access$validateRange(this.index, this.list.size());
        this.lastRequested = this.index;
        T it = t2 = this.list.get(this.index);
        boolean bl = false;
        int n = this.index;
        this.index = n + -1;
        return t2;
    }

    @Override
    public int previousIndex() {
        return this.index;
    }

    @Override
    public void add(T element) {
        this.validateModification();
        this.list.add(this.index + 1, element);
        this.lastRequested = -1;
        int n = this.index;
        this.index = n + 1;
        this.structure = this.list.getStructure$runtime();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size() - 1;
    }

    @Override
    public T next() {
        T t2;
        int newIndex;
        this.validateModification();
        this.lastRequested = newIndex = this.index + 1;
        SnapshotStateListKt.access$validateRange(newIndex, this.list.size());
        T it = t2 = this.list.get(newIndex);
        boolean bl = false;
        this.index = newIndex;
        return t2;
    }

    @Override
    public void remove() {
        this.validateModification();
        this.list.remove(this.index);
        int n = this.index;
        this.index = n + -1;
        this.lastRequested = -1;
        this.structure = this.list.getStructure$runtime();
    }

    @Override
    public void set(T element) {
        this.validateModification();
        if (this.lastRequested < 0) {
            SnapshotStateListKt.access$invalidIteratorSet();
            throw new KotlinNothingValueException();
        }
        this.list.set(this.lastRequested, element);
        this.structure = this.list.getStructure$runtime();
    }

    private final void validateModification() {
        if (this.list.getStructure$runtime() != this.structure) {
            throw new ConcurrentModificationException();
        }
    }
}

