/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.compose.runtime.SynchronizedObject;
import androidx.compose.runtime.snapshots.MutableSnapshot;
import androidx.compose.runtime.snapshots.SnapshotApplyResult;
import androidx.compose.runtime.snapshots.SnapshotIdSet;
import androidx.compose.runtime.snapshots.SnapshotKt;
import androidx.compose.runtime.snapshots.StateObject;
import androidx.compose.runtime.snapshots.tooling.SnapshotObserverKt;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/NestedMutableSnapshot\n+ 2 Snapshot.kt\nandroidx/compose/runtime/snapshots/SnapshotKt\n+ 3 Synchronization.desktop.kt\nandroidx/compose/runtime/platform/Synchronization_desktopKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 SnapshotId.jvm.kt\nandroidx/compose/runtime/snapshots/SnapshotId_jvmKt\n*L\n1#1,2623:1\n2031#2:2624\n26#3:2625\n1#4:2626\n31#5:2627\n*S KotlinDebug\n*F\n+ 1 Snapshot.kt\nandroidx/compose/runtime/snapshots/NestedMutableSnapshot\n*L\n1699#1:2624\n1699#1:2625\n1717#1:2627\n*E\n"})
public final class NestedMutableSnapshot
extends MutableSnapshot {
    @NotNull
    private final MutableSnapshot parent;
    private boolean deactivated;
    public static final int $stable = 8;

    public NestedMutableSnapshot(long snapshotId, @NotNull SnapshotIdSet invalid, @Nullable Function1<Object, Unit> readObserver, @Nullable Function1<Object, Unit> writeObserver, @NotNull MutableSnapshot parent) {
        Intrinsics.checkNotNullParameter((Object)invalid, (String)"invalid");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(snapshotId, invalid, readObserver, writeObserver);
        this.parent = parent;
        this.parent.nestedActivated$runtime(this);
    }

    @Override
    public void dispose() {
        if (!this.getDisposed$runtime()) {
            super.dispose();
            this.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public SnapshotApplyResult apply() {
        if (this.parent.getApplied$runtime()) return new SnapshotApplyResult.Failure(this);
        if (this.parent.getDisposed$runtime()) {
            return new SnapshotApplyResult.Failure(this);
        }
        MutableScatterSet<StateObject> modified = this.getModified$runtime();
        long id = this.getSnapshotId();
        Map optimisticMerges = modified != null ? SnapshotKt.access$optimisticMerges(this.parent.getSnapshotId(), this, this.parent.getInvalid$runtime()) : null;
        boolean $i$f$sync = false;
        SynchronizedObject lock$iv$iv = SnapshotKt.getLock();
        boolean $i$f$synchronized = false;
        SynchronizedObject synchronizedObject = lock$iv$iv;
        synchronized (synchronizedObject) {
            block9: {
                MutableScatterSet<StateObject> mutableScatterSet;
                MutableScatterSet<StateObject> mutableScatterSet2;
                block10: {
                    block8: {
                        boolean bl = false;
                        SnapshotKt.access$validateOpen(this);
                        if (modified != null && modified.getSize() != 0) break block8;
                        this.closeAndReleasePinning$runtime();
                        mutableScatterSet2 = Unit.INSTANCE;
                        break block9;
                    }
                    SnapshotApplyResult result2 = this.innerApplyLocked$runtime(this.parent.getSnapshotId(), modified, optimisticMerges, this.parent.getInvalid$runtime());
                    if (!Intrinsics.areEqual((Object)result2, (Object)SnapshotApplyResult.Success.INSTANCE)) {
                        return result2;
                    }
                    mutableScatterSet2 = this.parent.getModified$runtime();
                    if (mutableScatterSet2 == null) break block10;
                    MutableScatterSet<StateObject> $this$apply_u24lambda_u242_u24lambda_u240 = mutableScatterSet = mutableScatterSet2;
                    boolean bl = false;
                    $this$apply_u24lambda_u242_u24lambda_u240.addAll((ScatterSet)modified);
                    mutableScatterSet2 = mutableScatterSet;
                    if (mutableScatterSet2 != null) break block9;
                }
                MutableScatterSet<StateObject> it = mutableScatterSet = modified;
                boolean bl = false;
                this.parent.setModified$runtime(it);
                this.setModified$runtime(null);
                mutableScatterSet2 = mutableScatterSet;
            }
            long $this$compareTo$iv = this.parent.getSnapshotId();
            boolean $i$f$compareTo = false;
            if (Intrinsics.compare((long)$this$compareTo$iv, (long)id) < 0) {
                this.parent.advance$runtime();
            }
            this.parent.setInvalid$runtime(this.parent.getInvalid$runtime().clear(id).andNot(this.getPreviousIds$runtime()));
            this.parent.recordPrevious$runtime(id);
            this.parent.recordPreviousPinnedSnapshot$runtime(this.takeoverPinnedSnapshot$runtime());
            this.parent.recordPreviousList$runtime(this.getPreviousIds$runtime());
            this.parent.recordPreviousPinnedSnapshots$runtime(this.getPreviousPinnedSnapshots$runtime());
            Unit unit = Unit.INSTANCE;
        }
        this.setApplied$runtime(true);
        this.deactivate();
        SnapshotObserverKt.dispatchObserverOnApplied(this, (ScatterSet<StateObject>)((ScatterSet)modified));
        return SnapshotApplyResult.Success.INSTANCE;
    }

    private final void deactivate() {
        if (!this.deactivated) {
            this.deactivated = true;
            this.parent.nestedDeactivated$runtime(this);
        }
    }
}

