/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.persistentOrderedSet;

import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentSet;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.persistentOrderedSet.Links;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.persistentOrderedSet.PersistentOrderedSetIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.EndOfChain;
import java.util.Iterator;
import java.util.Map;
import kotlin.collections.AbstractSet;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nPersistentOrderedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentOrderedSet.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/persistentOrderedSet/PersistentOrderedSet\n+ 2 extensions.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,109:1\n31#2:110\n31#2:111\n31#2:112\n31#2:113\n*S KotlinDebug\n*F\n+ 1 PersistentOrderedSet.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/persistentOrderedSet/PersistentOrderedSet\n*L\n56#1:110\n81#1:111\n85#1:112\n89#1:113\n*E\n"})
public final class PersistentOrderedSet<E>
extends AbstractSet<E>
implements PersistentSet<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Object firstElement;
    @Nullable
    private final Object lastElement;
    @NotNull
    private final PersistentHashMap<E, Links> hashMap;
    public static final int $stable = 8;
    @NotNull
    private static final PersistentOrderedSet EMPTY = new PersistentOrderedSet(EndOfChain.INSTANCE, EndOfChain.INSTANCE, PersistentHashMap.Companion.emptyOf$runtime());

    public PersistentOrderedSet(@Nullable Object firstElement, @Nullable Object lastElement, @NotNull PersistentHashMap<E, Links> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"hashMap");
        this.firstElement = firstElement;
        this.lastElement = lastElement;
        this.hashMap = hashMap;
    }

    public int getSize() {
        return this.hashMap.size();
    }

    @Override
    public boolean contains(Object element) {
        return this.hashMap.containsKey((E)element);
    }

    @Override
    @NotNull
    public PersistentSet<E> add(E element) {
        if (this.hashMap.containsKey(element)) {
            return this;
        }
        if (this.isEmpty()) {
            PersistentHashMap<E, Links> newMap = this.hashMap.put(element, new Links());
            return new PersistentOrderedSet<E>(element, element, newMap);
        }
        Object lastElement = this.lastElement;
        Links links = this.hashMap.get((E)lastElement);
        Intrinsics.checkNotNull((Object)links);
        Links lastLinks = links;
        PersistentHashMap<Object, Links> newMap = this.hashMap.put(lastElement, lastLinks.withNext(element)).put(element, new Links(lastElement));
        return new PersistentOrderedSet<Object>(this.firstElement, element, newMap);
    }

    @Override
    @NotNull
    public PersistentSet<E> remove(E element) {
        Links links = this.hashMap.get(element);
        if (links == null) {
            return this;
        }
        Links links2 = links;
        PersistentHashMap<Object, Links> newMap = this.hashMap.remove(element);
        if (links2.getHasPrevious()) {
            Object v = ((Map)newMap).get(links2.getPrevious());
            Intrinsics.checkNotNull(v);
            Links previousLinks = (Links)v;
            newMap = newMap.put(links2.getPrevious(), previousLinks.withNext(links2.getNext()));
        }
        if (links2.getHasNext()) {
            Object v = ((Map)newMap).get(links2.getNext());
            Intrinsics.checkNotNull(v);
            Links nextLinks = (Links)v;
            newMap = newMap.put(links2.getNext(), nextLinks.withPrevious(links2.getPrevious()));
        }
        Object newFirstElement = !links2.getHasPrevious() ? links2.getNext() : this.firstElement;
        Object newLastElement = !links2.getHasNext() ? links2.getPrevious() : this.lastElement;
        return new PersistentOrderedSet<E>(newFirstElement, newLastElement, newMap);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new PersistentOrderedSetIterator(this.firstElement, (Map)this.hashMap);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <E> PersistentSet<E> emptyOf$runtime() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

