/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap;

import androidx.compose.runtime.external.kotlinx.collections.immutable.ImmutableCollection;
import androidx.compose.runtime.external.kotlinx.collections.immutable.ImmutableSet;
import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentMap;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapEntries;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapKeys;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapValues;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import java.util.Map;
import java.util.Set;
import kotlin.PublishedApi;
import kotlin.collections.AbstractMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nPersistentHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentHashMap.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMap\n+ 2 extensions.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,85:1\n53#2:86\n*S KotlinDebug\n*F\n+ 1 PersistentHashMap.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableMap/PersistentHashMap\n*L\n69#1:86\n*E\n"})
public class PersistentHashMap<K, V>
extends AbstractMap<K, V>
implements PersistentMap<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrieNode<K, V> node;
    private final int size;
    public static final int $stable = 8;
    @NotNull
    private static final PersistentHashMap EMPTY = new PersistentHashMap(TrieNode.Companion.getEMPTY$runtime(), 0);

    public PersistentHashMap(@NotNull TrieNode<K, V> node2, int size) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        this.node = node2;
        this.size = size;
    }

    @NotNull
    public final TrieNode<K, V> getNode$runtime() {
        return this.node;
    }

    public int getSize() {
        return this.size;
    }

    @NotNull
    public ImmutableSet<K> getKeys() {
        return new PersistentHashMapKeys(this);
    }

    @NotNull
    public ImmutableCollection<V> getValues() {
        return new PersistentHashMapValues(this);
    }

    private final ImmutableSet<Map.Entry<K, V>> createEntries() {
        return new PersistentHashMapEntries(this);
    }

    @PublishedApi
    @NotNull
    public final Set<Map.Entry<K, V>> getEntries() {
        return this.createEntries();
    }

    public boolean containsKey(K key) {
        K k = key;
        return this.node.containsKey(k != null ? k.hashCode() : 0, key, 0);
    }

    @Nullable
    public V get(K key) {
        K k = key;
        return this.node.get(k != null ? k.hashCode() : 0, key, 0);
    }

    @NotNull
    public PersistentHashMap<K, V> put(K key, V value2) {
        K k = key;
        TrieNode.ModificationResult<K, V> modificationResult = this.node.put(k != null ? k.hashCode() : 0, key, value2, 0);
        if (modificationResult == null) {
            return this;
        }
        TrieNode.ModificationResult<K, V> newNodeResult = modificationResult;
        return new PersistentHashMap<K, V>(newNodeResult.getNode(), this.size() + newNodeResult.getSizeDelta());
    }

    @NotNull
    public PersistentHashMap<K, V> remove(K key) {
        K k = key;
        TrieNode<K, V> newNode = this.node.remove(k != null ? k.hashCode() : 0, key, 0);
        if (this.node == newNode) {
            return this;
        }
        if (newNode == null) {
            return Companion.emptyOf$runtime();
        }
        return new PersistentHashMap<K, V>(newNode, this.size() - 1);
    }

    @Override
    @NotNull
    public PersistentHashMapBuilder<K, V> builder() {
        return new PersistentHashMapBuilder(this);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <K, V> PersistentHashMap<K, V> emptyOf$runtime() {
            PersistentHashMap persistentHashMap = EMPTY;
            Intrinsics.checkNotNull((Object)persistentHashMap, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap<K of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap.Companion.emptyOf, V of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap.Companion.emptyOf>");
            return persistentHashMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

