/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.AnchoredGroupPath;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SourceInformationGroupIterator;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 3 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n*L\n1#1,3963:1\n3672#2:3964\n3726#2:3965\n3681#2:3966\n3666#2,4:3967\n3777#2:3978\n3777#2:3979\n158#3,7:3971\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n*L\n3238#1:3964\n3239#1:3965\n3243#1:3966\n3247#1:3967,4\n3278#1:3978\n3280#1:3979\n3258#1:3971,7\n*E\n"})
final class SlotTableGroup
implements CompositionGroup,
Iterable<CompositionGroup>,
KMappedMarker {
    @NotNull
    private final SlotTable table;
    private final int group;
    private final int version;

    public SlotTableGroup(@NotNull SlotTable table, int group, int version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.group = group;
        this.version = version;
    }

    @Override
    @NotNull
    public Iterator<CompositionGroup> iterator() {
        Iterator iterator2;
        this.validateRead();
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            GroupSourceInformation it = groupSourceInformation;
            boolean bl = false;
            iterator2 = new SourceInformationGroupIterator(this.table, this.group, it, new AnchoredGroupPath(this.group));
        } else {
            iterator2 = new GroupIterator(this.table, this.group + 1, this.group + SlotTableKt.access$groupSize(this.table.getGroups(), this.group));
        }
        return iterator2;
    }

    private final void validateRead() {
        if (this.table.getVersion$runtime() != this.version) {
            SlotTableKt.throwConcurrentModificationException();
        }
    }
}

