/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/GroupSourceInformation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n+ 4 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,3963:1\n1#2:3964\n799#3,8:3965\n789#3,7:3973\n91#4:3980\n34#4,5:3981\n92#4:3986\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/GroupSourceInformation\n*L\n733#1:3965,8\n749#1:3973,7\n760#1:3980\n760#1:3981,5\n760#1:3986\n*E\n"})
public final class GroupSourceInformation {
    private final int key;
    @Nullable
    private String sourceInformation;
    private final int dataStartOffset;
    @Nullable
    private ArrayList<Object> groups;
    private boolean closed;
    private int dataEndOffset;
    public static final int $stable = 8;

    public GroupSourceInformation(int key, @Nullable String sourceInformation, int dataStartOffset) {
        this.key = key;
        this.sourceInformation = sourceInformation;
        this.dataStartOffset = dataStartOffset;
    }

    public final int getKey() {
        return this.key;
    }

    @Nullable
    public final ArrayList<Object> getGroups() {
        return this.groups;
    }

    public final void startGrouplessCall(int key, @NotNull String sourceInformation, int dataOffset) {
        Intrinsics.checkNotNullParameter((Object)sourceInformation, (String)"sourceInformation");
        this.openInformation().add(new GroupSourceInformation(key, sourceInformation, dataOffset));
    }

    public final void endGrouplessCall(int dataOffset) {
        this.openInformation().close(dataOffset);
    }

    public final void reportGroup(@NotNull SlotWriter writer2, int group) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        this.openInformation().add(writer2.anchor(group));
    }

    public final void reportGroup(@NotNull SlotTable table, int group) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.openInformation().add(table.anchor(group));
    }

    public final void addGroupAfter(@NotNull SlotWriter writer2, int predecessor, int group) {
        int n;
        ArrayList<Object> groups;
        block6: {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            ArrayList<Object> arrayList = this.groups;
            if (arrayList == null) {
                ArrayList arrayList2;
                ArrayList it = arrayList2 = new ArrayList();
                boolean bl = false;
                this.groups = it;
                arrayList = groups = arrayList2;
            }
            if (predecessor >= 0) {
                Anchor anchor = writer2.tryAnchor$runtime(predecessor);
                if (anchor != null) {
                    ArrayList<Object> $this$fastIndexOf$iv = groups;
                    boolean $i$f$fastIndexOf = false;
                    int size$iv = $this$fastIndexOf$iv.size();
                    for (int index$iv = 0; index$iv < size$iv; ++index$iv) {
                        Object value$iv;
                        Object it = value$iv = $this$fastIndexOf$iv.get(index$iv);
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it, (Object)anchor) || it instanceof GroupSourceInformation && ((GroupSourceInformation)it).hasAnchor(anchor))) continue;
                        n = index$iv;
                        break block6;
                    }
                    n = -1;
                } else {
                    n = 0;
                }
            } else {
                n = 0;
            }
        }
        int index = n;
        groups.add(index, writer2.anchor(group));
    }

    public final void close(int dataOffset) {
        this.closed = true;
        this.dataEndOffset = dataOffset;
    }

    private final GroupSourceInformation openInformation() {
        Object object;
        block3: {
            ArrayList<Object> arrayList = this.groups;
            if (arrayList != null) {
                ArrayList<Object> groups = arrayList;
                boolean bl = false;
                ArrayList<Object> $this$fastLastOrNull$iv = groups;
                boolean $i$f$fastLastOrNull = false;
                for (int index$iv = $this$fastLastOrNull$iv.size() - 1; index$iv >= 0; --index$iv) {
                    Object value$iv;
                    Object it = value$iv = $this$fastLastOrNull$iv.get(index$iv);
                    boolean bl2 = false;
                    if (!(it instanceof GroupSourceInformation && !((GroupSourceInformation)it).closed)) continue;
                    object = value$iv;
                    break block3;
                }
                object = null;
            } else {
                object = null;
            }
        }
        GroupSourceInformation groupSourceInformation = object;
        GroupSourceInformation groupSourceInformation2 = groupSourceInformation instanceof GroupSourceInformation ? (GroupSourceInformation)groupSourceInformation : null;
        return groupSourceInformation2 != null && (groupSourceInformation = groupSourceInformation2.openInformation()) != null ? groupSourceInformation : this;
    }

    private final void add(Object group) {
        ArrayList<Object> arrayList = this.groups;
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        ArrayList<Object> groups = arrayList;
        this.groups = groups;
        groups.add(group);
    }

    private final boolean hasAnchor(Anchor anchor) {
        boolean bl;
        ArrayList<Object> arrayList = this.groups;
        if (arrayList != null) {
            boolean bl2;
            block3: {
                List $this$fastAny$iv = arrayList;
                boolean $i$f$fastAny = false;
                List $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv$iv).size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Object item$iv$iv;
                    Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl3 = false;
                    Object it = it$iv;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual(it, (Object)anchor) || it instanceof GroupSourceInformation && ((GroupSourceInformation)it).hasAnchor(anchor))) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean removeAnchor(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ArrayList<Object> groups = this.groups;
        if (groups != null) {
            for (int index = groups.size() - 1; index >= 0; --index) {
                Object item2;
                Intrinsics.checkNotNullExpressionValue((Object)groups.get(index), (String)"get(...)");
                if (item2 instanceof Anchor) {
                    if (!Intrinsics.areEqual((Object)item2, (Object)anchor)) continue;
                    groups.remove(index);
                    continue;
                }
                if (!(item2 instanceof GroupSourceInformation) || ((GroupSourceInformation)item2).removeAnchor(anchor)) continue;
                groups.remove(index);
            }
            if (groups.isEmpty()) {
                this.groups = null;
                return false;
            }
            return true;
        }
        return true;
    }
}

