/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.PersistentCompositionLocalMap;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.ValueHolder;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicValueHolder<T>
implements ValueHolder<T> {
    @NotNull
    private final MutableState<T> state;

    public DynamicValueHolder(@NotNull MutableState<T> state2) {
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        this.state = state2;
    }

    @NotNull
    public final MutableState<T> getState() {
        return this.state;
    }

    @Override
    public T readValue(@NotNull PersistentCompositionLocalMap map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        return this.state.getValue();
    }

    @Override
    @NotNull
    public ProvidedValue<T> toProvided(@NotNull CompositionLocal<T> local) {
        Intrinsics.checkNotNullParameter(local, (String)"local");
        return new ProvidedValue<Object>(local, null, false, null, this.state, null, true);
    }

    @NotNull
    public String toString() {
        return "DynamicValueHolder(state=" + this.state + ")";
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DynamicValueHolder)) {
            return false;
        }
        DynamicValueHolder dynamicValueHolder = (DynamicValueHolder)other;
        return Intrinsics.areEqual(this.state, dynamicValueHolder.state);
    }
}

