/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.RememberObserver;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DisposableEffectImpl
implements RememberObserver {
    @NotNull
    private final Function1<DisposableEffectScope, DisposableEffectResult> effect;
    @Nullable
    private DisposableEffectResult onDispose;

    public DisposableEffectImpl(@NotNull Function1<? super DisposableEffectScope, ? extends DisposableEffectResult> effect2) {
        Intrinsics.checkNotNullParameter(effect2, (String)"effect");
        this.effect = effect2;
    }

    @Override
    public void onRemembered() {
        this.onDispose = (DisposableEffectResult)this.effect.invoke((Object)EffectsKt.access$getInternalDisposableEffectScope$p());
    }

    @Override
    public void onForgotten() {
        DisposableEffectResult disposableEffectResult = this.onDispose;
        if (disposableEffectResult != null) {
            disposableEffectResult.dispose();
        }
        this.onDispose = null;
    }

    @Override
    public void onAbandoned() {
    }
}

