/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.foundation.text.selection.TextSelectionColors;
import androidx.compose.material.Colors;
import androidx.compose.material.ColorsKt;
import androidx.compose.material.ContentAlpha;
import androidx.compose.material.ContentColorKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMaterialTextSelectionColors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaterialTextSelectionColors.kt\nandroidx/compose/material/MaterialTextSelectionColorsKt\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,244:1\n646#2:245\n635#2:246\n75#3:247\n1247#4,6:248\n*S KotlinDebug\n*F\n+ 1 MaterialTextSelectionColors.kt\nandroidx/compose/material/MaterialTextSelectionColorsKt\n*L\n45#1:245\n45#1:246\n45#1:247\n47#1:248,6\n*E\n"})
public final class MaterialTextSelectionColorsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TextSelectionColors rememberTextSelectionColors(@NotNull Colors colors, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        long l;
        void $this$takeOrElse_u2dDxMtmZc$iv22;
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        ComposerKt.sourceInformationMarkerStart($composer, -721696685, "C(rememberTextSelectionColors)45@1907L6,46@1926L416:MaterialTextSelectionColors.kt#jmzs0o");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart(-721696685, $changed, -1, "androidx.compose.material.rememberTextSelectionColors (MaterialTextSelectionColors.kt:35)");
        }
        long primaryColor = colors.getPrimary-0d7_KjU();
        long backgroundColor = colors.getBackground-0d7_KjU();
        $composer.startReplaceGroup(1102762852);
        ComposerKt.sourceInformation($composer, "*44@1858L7");
        long l2 = ColorsKt.contentColorFor-4WTKRHQ(colors, backgroundColor);
        boolean bl = false;
        void $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv22;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != 16L) {
            l = $this$takeOrElse_u2dDxMtmZc$iv22;
        } else {
            void this_$iv;
            boolean bl3 = false;
            CompositionLocal compositionLocal = ContentColorKt.getLocalContentColor();
            int $changed$iv = 6;
            boolean $i$f$getCurrent = false;
            ComposerKt.sourceInformationMarkerStart($composer, 2023513938, "CC(<get-current>):CompositionLocal.kt#9igjgp");
            Object t2 = $composer.consume(this_$iv);
            ComposerKt.sourceInformationMarkerEnd($composer);
            l = ((Color)t2).unbox-impl();
        }
        void var9_17 = l;
        $composer.endReplaceGroup();
        long textColorWithLowestAlpha = Color.copy-wmQWz5c$default((long)var9_17, ContentAlpha.INSTANCE.getMedium($composer, 6), 0.0f, 0.0f, 0.0f, 14, null);
        ComposerKt.sourceInformationMarkerStart($composer, 1102766396, "CC(remember):MaterialTextSelectionColors.kt#9igjgp");
        Composer $this$takeOrElse_u2dDxMtmZc$iv22 = $composer;
        boolean invalid$iv = $composer.changed(primaryColor) | $composer.changed(backgroundColor) | $composer.changed(textColorWithLowestAlpha);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl4 = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            boolean bl5 = false;
            TextSelectionColors value$iv = new TextSelectionColors(colors.getPrimary-0d7_KjU(), MaterialTextSelectionColorsKt.calculateSelectionBackgroundColor-ysEtTa8(primaryColor, textColorWithLowestAlpha, backgroundColor), null);
            $this$cache$iv.updateRememberedValue(value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        TextSelectionColors textSelectionColors = (TextSelectionColors)object;
        ComposerKt.sourceInformationMarkerEnd($composer);
        TextSelectionColors textSelectionColors2 = textSelectionColors;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd($composer);
        return textSelectionColors2;
    }

    public static final long calculateSelectionBackgroundColor-ysEtTa8(long selectionColor, long textColor, long backgroundColor) {
        float maximumContrastRatio = MaterialTextSelectionColorsKt.calculateContrastRatio-nb2GgbA(selectionColor, 0.4f, textColor, backgroundColor);
        float minimumContrastRatio = MaterialTextSelectionColorsKt.calculateContrastRatio-nb2GgbA(selectionColor, 0.2f, textColor, backgroundColor);
        float alpha2 = maximumContrastRatio >= 4.5f ? 0.4f : (minimumContrastRatio < 4.5f ? 0.2f : MaterialTextSelectionColorsKt.binarySearchForAccessibleSelectionColorAlpha-ysEtTa8(selectionColor, textColor, backgroundColor));
        return Color.copy-wmQWz5c$default(selectionColor, alpha2, 0.0f, 0.0f, 0.0f, 14, null);
    }

    private static final float binarySearchForAccessibleSelectionColorAlpha-ysEtTa8(long selectionColor, long textColor, long backgroundColor) {
        int maxAttempts = 7;
        float lowAlpha = 0.2f;
        float alpha2 = 0.4f;
        float highAlpha = 0.4f;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            float contrastRatio = MaterialTextSelectionColorsKt.calculateContrastRatio-nb2GgbA(selectionColor, alpha2, textColor, backgroundColor);
            float percentageError = contrastRatio / 4.5f - 1.0f;
            if (0.0f <= percentageError ? percentageError <= 0.01f : false) break;
            if (percentageError < 0.0f) {
                highAlpha = alpha2;
            } else {
                lowAlpha = alpha2;
            }
            alpha2 = (highAlpha + lowAlpha) / 2.0f;
        }
        return alpha2;
    }

    private static final float calculateContrastRatio-nb2GgbA(long selectionColor, float selectionColorAlpha, long textColor, long backgroundColor) {
        long compositeBackground = ColorKt.compositeOver--OWjLjI(Color.copy-wmQWz5c$default(selectionColor, selectionColorAlpha, 0.0f, 0.0f, 0.0f, 14, null), backgroundColor);
        long compositeTextColor = ColorKt.compositeOver--OWjLjI(textColor, compositeBackground);
        return MaterialTextSelectionColorsKt.calculateContrastRatio--OWjLjI(compositeTextColor, compositeBackground);
    }

    public static final float calculateContrastRatio--OWjLjI(long foreground, long background) {
        float foregroundLuminance = ColorKt.luminance-8_81llA(foreground) + 0.05f;
        float backgroundLuminance = ColorKt.luminance-8_81llA(background) + 0.05f;
        return Math.max(foregroundLuminance, backgroundLuminance) / Math.min(foregroundLuminance, backgroundLuminance);
    }
}

