/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.material.DraggableAnchors;
import java.util.Iterator;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material/MapDraggableAnchors\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,880:1\n1#2:881\n*E\n"})
final class MapDraggableAnchors<T>
implements DraggableAnchors<T> {
    @NotNull
    private final Map<T, Float> anchors;

    public MapDraggableAnchors(@NotNull Map<T, Float> anchors) {
        Intrinsics.checkNotNullParameter(anchors, (String)"anchors");
        this.anchors = anchors;
    }

    @Override
    public float positionOf(T value2) {
        Float f = this.anchors.get(value2);
        return f != null ? f.floatValue() : Float.NaN;
    }

    @Override
    public boolean hasAnchorFor(T value2) {
        return this.anchors.containsKey(value2);
    }

    @Override
    @Nullable
    public T closestAnchor(float position) {
        Object v0;
        Iterable iterable = this.anchors.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t2 = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t2;
            } else {
                Map.Entry it = (Map.Entry)t2;
                boolean bl = false;
                float f = Math.abs(position - ((Number)it.getValue()).floatValue());
                do {
                    Object t3 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t3;
                    $i$a$-minByOrNull-MapDraggableAnchors$closestAnchor$1 = false;
                    float f2 = Math.abs(position - ((Number)it2.getValue()).floatValue());
                    if (Float.compare(f, f2) <= 0) continue;
                    t2 = t3;
                    f = f2;
                } while (iterator2.hasNext());
                v0 = t2;
            }
        }
        Map.Entry entry = v0;
        return (T)(entry != null ? entry.getKey() : null);
    }

    @Override
    @Nullable
    public T closestAnchor(float position, boolean searchUpwards) {
        Object v0;
        Iterable iterable = this.anchors.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t2 = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t2;
            } else {
                Map.Entry entry = (Map.Entry)t2;
                boolean bl = false;
                float anchor = ((Number)entry.getValue()).floatValue();
                float delta = searchUpwards ? anchor - position : position - anchor;
                float f = delta < 0.0f ? Float.POSITIVE_INFINITY : delta;
                do {
                    float f2;
                    Object t3 = iterator2.next();
                    Map.Entry entry2 = (Map.Entry)t3;
                    $i$a$-minByOrNull-MapDraggableAnchors$closestAnchor$2 = false;
                    float anchor2 = ((Number)entry2.getValue()).floatValue();
                    float delta2 = searchUpwards ? anchor2 - position : position - anchor2;
                    float f3 = f2 = delta2 < 0.0f ? Float.POSITIVE_INFINITY : delta2;
                    if (Float.compare(f, f2) <= 0) continue;
                    t2 = t3;
                    f = f2;
                } while (iterator2.hasNext());
                v0 = t2;
            }
        }
        Map.Entry entry = v0;
        return entry != null ? (T)entry.getKey() : null;
    }

    @Override
    public float minAnchor() {
        Float f = CollectionsKt.minOrNull((Iterable)this.anchors.values());
        return f != null ? f.floatValue() : Float.NaN;
    }

    @Override
    public float maxAnchor() {
        Float f = CollectionsKt.maxOrNull((Iterable)this.anchors.values());
        return f != null ? f.floatValue() : Float.NaN;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapDraggableAnchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.anchors, ((MapDraggableAnchors)other).anchors);
    }

    public int hashCode() {
        return 31 * ((Object)this.anchors).hashCode();
    }

    @NotNull
    public String toString() {
        return "MapDraggableAnchors(" + this.anchors + ")";
    }
}

