/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.foundation.MutatePriority;
import androidx.compose.foundation.gestures.DragScope;
import androidx.compose.foundation.gestures.DraggableState;
import androidx.compose.material.AnchoredDragScope;
import androidx.compose.material.AnchoredDraggableKt;
import androidx.compose.material.AnchoredDraggableState;
import androidx.compose.material.DraggableAnchors;
import androidx.compose.material.InternalMutatorMutex;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material/AnchoredDraggableState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n*L\n1#1,880:1\n85#2:881\n113#2,2:882\n85#2:884\n85#2:885\n85#2:889\n85#2:893\n113#2,2:894\n85#2:896\n113#2,2:897\n79#3:886\n112#3,2:887\n79#3:890\n112#3,2:891\n*S KotlinDebug\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material/AnchoredDraggableState\n*L\n293#1:881\n293#1:882,2\n301#1:884\n316#1:885\n361#1:889\n380#1:893\n380#1:894,2\n382#1:896\n382#1:897,2\n334#1:886\n334#1:887,2\n377#1:890\n377#1:891,2\n*E\n"})
public final class AnchoredDraggableState<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Float, Float> positionalThreshold;
    @NotNull
    private final Function0<Float> velocityThreshold;
    @NotNull
    private final AnimationSpec<Float> animationSpec;
    @NotNull
    private final Function1<T, Boolean> confirmValueChange;
    @NotNull
    private final InternalMutatorMutex dragMutex;
    @NotNull
    private final DraggableState draggableState;
    @NotNull
    private final MutableState currentValue$delegate;
    @NotNull
    private final State targetValue$delegate;
    @NotNull
    private final State closestValue$delegate;
    @NotNull
    private final MutableFloatState offset$delegate;
    @NotNull
    private final State progress$delegate;
    @NotNull
    private final MutableFloatState lastVelocity$delegate;
    @NotNull
    private final MutableState dragTarget$delegate;
    @NotNull
    private final MutableState anchors$delegate;
    @NotNull
    private final AnchoredDragScope anchoredDragScope;

    public AnchoredDraggableState(T initialValue, @NotNull Function1<? super Float, Float> positionalThreshold, @NotNull Function0<Float> velocityThreshold, @NotNull AnimationSpec<Float> animationSpec, @NotNull Function1<? super T, Boolean> confirmValueChange) {
        Intrinsics.checkNotNullParameter(positionalThreshold, (String)"positionalThreshold");
        Intrinsics.checkNotNullParameter(velocityThreshold, (String)"velocityThreshold");
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
        this.positionalThreshold = positionalThreshold;
        this.velocityThreshold = velocityThreshold;
        this.animationSpec = animationSpec;
        this.confirmValueChange = confirmValueChange;
        this.dragMutex = new InternalMutatorMutex();
        this.draggableState = new DraggableState(this){
            private final draggableState.dragScope.1 dragScope;
            final /* synthetic */ AnchoredDraggableState<T> this$0;
            {
                this.this$0 = $receiver;
                this.dragScope = new DragScope($receiver){
                    final /* synthetic */ AnchoredDraggableState<T> this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void dragBy(float pixels) {
                        AnchoredDragScope anchoredDragScope2 = AnchoredDraggableState.access$getAnchoredDragScope$p(this.this$0);
                        AnchoredDraggableState<T> anchoredDraggableState = this.this$0;
                        AnchoredDragScope $this$dragBy_u24lambda_u240 = anchoredDragScope2;
                        boolean bl = false;
                        AnchoredDragScope.dragTo$default($this$dragBy_u24lambda_u240, anchoredDraggableState.newOffsetForDelta$material(pixels), 0.0f, 2, null);
                    }
                };
            }

            public Object drag(MutatePriority dragPriority, Function2<? super DragScope, ? super Continuation<? super Unit>, ? extends Object> block, Continuation<? super Unit> $completion) {
                Object object = this.this$0.anchoredDrag(dragPriority, (Function3)new Function3<AnchoredDragScope, DraggableAnchors<T>, Continuation<? super Unit>, Object>(this, block, null){
                    int label;
                    final /* synthetic */ draggableState.1 this$0;
                    final /* synthetic */ Function2<DragScope, Continuation<? super Unit>, Object> $block;
                    {
                        this.this$0 = $receiver;
                        this.$block = $block;
                        super(3, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                draggableState.dragScope.1 var2_3 = draggableState.1.access$getDragScope$p(this.this$0);
                                Function2<DragScope, Continuation<? super Unit>, Object> function2 = this.$block;
                                draggableState.dragScope.1 $this$invokeSuspend_u24lambda_u240 = var2_3;
                                boolean bl = false;
                                this.label = 1;
                                Object object3 = function2.invoke((Object)$this$invokeSuspend_u24lambda_u240, (Object)((Object)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                boolean bl = false;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Object invoke(AnchoredDragScope p1, DraggableAnchors<T> p2, Continuation<? super Unit> p3) {
                        return new /* invalid duplicate definition of identical inner class */.invokeSuspend(Unit.INSTANCE);
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ draggableState.dragScope.1 access$getDragScope$p(draggableState.1 $this) {
                return $this.dragScope;
            }
        };
        this.currentValue$delegate = SnapshotStateKt.mutableStateOf$default(initialValue, null, 2, null);
        this.targetValue$delegate = SnapshotStateKt.derivedStateOf(() -> AnchoredDraggableState.targetValue_delegate$lambda$3(this));
        this.closestValue$delegate = SnapshotStateKt.derivedStateOf(() -> AnchoredDraggableState.closestValue_delegate$lambda$5(this));
        this.offset$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(Float.NaN);
        this.progress$delegate = SnapshotStateKt.derivedStateOf(SnapshotStateKt.structuralEqualityPolicy(), () -> AnchoredDraggableState.progress_delegate$lambda$7(this));
        this.lastVelocity$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(0.0f);
        this.dragTarget$delegate = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
        this.anchors$delegate = SnapshotStateKt.mutableStateOf$default(AnchoredDraggableKt.access$emptyDraggableAnchors(), null, 2, null);
        this.anchoredDragScope = new AnchoredDragScope(this){
            final /* synthetic */ AnchoredDraggableState<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void dragTo(float newOffset, float lastKnownVelocity) {
                AnchoredDraggableState.access$setOffset(this.this$0, newOffset);
                AnchoredDraggableState.access$setLastVelocity(this.this$0, lastKnownVelocity);
            }
        };
    }

    @NotNull
    public final AnimationSpec<Float> getAnimationSpec() {
        return this.animationSpec;
    }

    @NotNull
    public final Function1<T, Boolean> getConfirmValueChange$material() {
        return this.confirmValueChange;
    }

    @NotNull
    public final DraggableState getDraggableState$material() {
        return this.draggableState;
    }

    /*
     * WARNING - void declaration
     */
    public final T getCurrentValue() {
        void $this$getValue$iv;
        State state2 = this.currentValue$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentValue(T t2) {
        void $this$setValue$iv;
        MutableState mutableState = this.currentValue$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(t2);
    }

    /*
     * WARNING - void declaration
     */
    public final T getTargetValue() {
        void $this$getValue$iv;
        State state2 = this.targetValue$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final T getClosestValue$material() {
        void $this$getValue$iv;
        State state2 = this.closestValue$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final float getOffset() {
        void $this$getValue$iv;
        FloatState floatState = this.offset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setOffset(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.offset$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    public final float requireOffset() {
        if (!(!Float.isNaN(this.getOffset()))) {
            boolean bl = false;
            String string = "The offset was read before being initialized. Did you access the offset in a phase before layout, like effects or composition?";
            throw new IllegalStateException(string.toString());
        }
        return this.getOffset();
    }

    public final boolean isAnimationRunning() {
        return this.getDragTarget() != null;
    }

    /*
     * WARNING - void declaration
     */
    public final float getLastVelocity() {
        void $this$getValue$iv;
        FloatState floatState = this.lastVelocity$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setLastVelocity(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.lastVelocity$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    /*
     * WARNING - void declaration
     */
    private final T getDragTarget() {
        void $this$getValue$iv;
        State state2 = this.dragTarget$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setDragTarget(T t2) {
        void $this$setValue$iv;
        MutableState mutableState = this.dragTarget$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(t2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DraggableAnchors<T> getAnchors() {
        void $this$getValue$iv;
        State state2 = this.anchors$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (DraggableAnchors)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAnchors(DraggableAnchors<T> draggableAnchors) {
        void $this$setValue$iv;
        MutableState mutableState = this.anchors$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(draggableAnchors);
    }

    public final void updateAnchors(@NotNull DraggableAnchors<T> newAnchors, T newTarget) {
        Intrinsics.checkNotNullParameter(newAnchors, (String)"newAnchors");
        if (!Intrinsics.areEqual(this.getAnchors(), newAnchors)) {
            this.setAnchors(newAnchors);
            boolean snapSuccessful = this.trySnapTo(newTarget);
            if (!snapSuccessful) {
                this.setDragTarget(newTarget);
            }
        }
    }

    public static /* synthetic */ void updateAnchors$default(AnchoredDraggableState anchoredDraggableState, DraggableAnchors draggableAnchors, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            Object t2;
            if (!Float.isNaN(anchoredDraggableState.getOffset())) {
                t2 = draggableAnchors.closestAnchor(anchoredDraggableState.getOffset());
                if (t2 == null) {
                    t2 = anchoredDraggableState.getTargetValue();
                }
            } else {
                t2 = anchoredDraggableState.getTargetValue();
            }
            object = t2;
        }
        anchoredDraggableState.updateAnchors(draggableAnchors, object);
    }

    @Nullable
    public final Object settle(float velocity, @NotNull Continuation<? super Unit> $completion) {
        T previousValue = this.getCurrentValue();
        T targetValue = this.computeTarget(this.requireOffset(), previousValue, velocity);
        if (((Boolean)this.confirmValueChange.invoke(targetValue)).booleanValue()) {
            Object object = AnchoredDraggableKt.animateTo(this, targetValue, velocity, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = AnchoredDraggableKt.animateTo(this, previousValue, velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final T computeTarget(float offset, T currentValue, float velocity) {
        T t2;
        DraggableAnchors<T> currentAnchors = this.getAnchors();
        float currentAnchorPosition = currentAnchors.positionOf(currentValue);
        float velocityThresholdPx = ((Number)this.velocityThreshold.invoke()).floatValue();
        if (currentAnchorPosition == offset || Float.isNaN(currentAnchorPosition)) {
            t2 = currentValue;
        } else if (currentAnchorPosition < offset) {
            if (velocity >= velocityThresholdPx) {
                T t3 = currentAnchors.closestAnchor(offset, true);
                t2 = t3;
                Intrinsics.checkNotNull(t3);
            } else {
                T t4 = currentAnchors.closestAnchor(offset, true);
                Intrinsics.checkNotNull(t4);
                T upper = t4;
                float distance = Math.abs(currentAnchors.positionOf(upper) - currentAnchorPosition);
                float relativeThreshold = Math.abs(((Number)this.positionalThreshold.invoke((Object)Float.valueOf(distance))).floatValue());
                float absoluteThreshold = Math.abs(currentAnchorPosition + relativeThreshold);
                t2 = offset < absoluteThreshold ? currentValue : upper;
            }
        } else if (velocity <= -velocityThresholdPx) {
            T t5 = currentAnchors.closestAnchor(offset, false);
            t2 = t5;
            Intrinsics.checkNotNull(t5);
        } else {
            T t6 = currentAnchors.closestAnchor(offset, false);
            Intrinsics.checkNotNull(t6);
            T lower = t6;
            float distance = Math.abs(currentAnchorPosition - currentAnchors.positionOf(lower));
            float relativeThreshold = Math.abs(((Number)this.positionalThreshold.invoke((Object)Float.valueOf(distance))).floatValue());
            float absoluteThreshold = Math.abs(currentAnchorPosition - relativeThreshold);
            t2 = offset < 0.0f ? (Math.abs(offset) < absoluteThreshold ? currentValue : lower) : (offset > absoluteThreshold ? currentValue : lower);
        }
        return t2;
    }

    private final T computeTargetWithoutThresholds(float offset, T currentValue) {
        T t2;
        DraggableAnchors<T> currentAnchors = this.getAnchors();
        float currentAnchorPosition = currentAnchors.positionOf(currentValue);
        if (currentAnchorPosition == offset || Float.isNaN(currentAnchorPosition)) {
            t2 = currentValue;
        } else if (currentAnchorPosition < offset) {
            t2 = currentAnchors.closestAnchor(offset, true);
            if (t2 == null) {
                t2 = currentValue;
            }
        } else {
            t2 = currentAnchors.closestAnchor(offset, false);
            if (t2 == null) {
                t2 = currentValue;
            }
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object anchoredDrag(@NotNull MutatePriority var1_1, @NotNull Function3<? super AnchoredDragScope, ? super DraggableAnchors<T>, ? super Continuation<? super Unit>, ? extends Object> var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof anchoredDrag.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AnchoredDraggableState<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.anchoredDrag(null, null, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.dragMutex.mutate((MutatePriority)dragPriority, (Function1)new Function1<Continuation<? super Unit>, Object>(this, block, null){
                    int label;
                    final /* synthetic */ AnchoredDraggableState<T> this$0;
                    final /* synthetic */ Function3<AnchoredDragScope, DraggableAnchors<T>, Continuation<? super Unit>, Object> $block;
                    {
                        this.this$0 = $receiver;
                        this.$block = $block;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = AnchoredDraggableKt.access$restartable(() -> anchoredDrag.2.invokeSuspend$lambda$0(this.this$0), (Function2)new Function2<DraggableAnchors<T>, Continuation<? super Unit>, Object>(this.$block, this.this$0, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ Function3<AnchoredDragScope, DraggableAnchors<T>, Continuation<? super Unit>, Object> $block;
                                    final /* synthetic */ AnchoredDraggableState<T> this$0;
                                    {
                                        this.$block = $block;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                DraggableAnchors latestAnchors = (DraggableAnchors)this.L$0;
                                                this.label = 1;
                                                Object object3 = this.$block.invoke((Object)AnchoredDraggableState.access$getAnchoredDragScope$p(this.this$0), (Object)latestAnchors, (Object)((Object)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(DraggableAnchors<T> p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final DraggableAnchors invokeSuspend$lambda$0(AnchoredDraggableState this$0) {
                        return this$0.getAnchors();
                    }
                }, $continuation);
                ** if (v0 != var8_6) goto lbl19
lbl18:
                // 1 sources

                return var8_6;
lbl19:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                this = (AnchoredDraggableState)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var4_8) {
                    throw var4_8;
                }
                finally {
                    closest = this.getAnchors().closestAnchor(this.getOffset());
                    if (closest != null && Math.abs(this.getOffset() - this.getAnchors().positionOf(closest)) <= 0.5f && ((Boolean)this.confirmValueChange.invoke(closest)).booleanValue()) {
                        this.setCurrentValue(closest);
                    }
                }
lbl34:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object anchoredDrag(T var1_1, @NotNull MutatePriority var2_2, @NotNull Function4<? super AnchoredDragScope, ? super DraggableAnchors<T>, ? super T, ? super Continuation<? super Unit>, ? extends Object> var3_3, @NotNull Continuation<? super Unit> $completion) {
        block12: {
            if (!($completion instanceof anchoredDrag.3)) ** GOTO lbl-1000
            var8_5 = $completion;
            if ((var8_5.label & -2147483648) != 0) {
                var8_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AnchoredDraggableState<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.anchoredDrag(null, null, null, (Continuation<Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!this.getAnchors().hasAnchorFor(targetValue)) break;
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.dragMutex.mutate((MutatePriority)dragPriority, (Function1)new Function1<Continuation<? super Unit>, Object>(this, targetValue, block, null){
                        int label;
                        final /* synthetic */ AnchoredDraggableState<T> this$0;
                        final /* synthetic */ T $targetValue;
                        final /* synthetic */ Function4<AnchoredDragScope, DraggableAnchors<T>, T, Continuation<? super Unit>, Object> $block;
                        {
                            this.this$0 = $receiver;
                            this.$targetValue = $targetValue;
                            this.$block = $block;
                            super(1, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    AnchoredDraggableState.access$setDragTarget(this.this$0, this.$targetValue);
                                    this.label = 1;
                                    Object object3 = AnchoredDraggableKt.access$restartable(() -> anchoredDrag.4.invokeSuspend$lambda$0(this.this$0), (Function2)new Function2<Pair<? extends DraggableAnchors<T>, ? extends T>, Continuation<? super Unit>, Object>(this.$block, this.this$0, null){
                                        int label;
                                        /* synthetic */ Object L$0;
                                        final /* synthetic */ Function4<AnchoredDragScope, DraggableAnchors<T>, T, Continuation<? super Unit>, Object> $block;
                                        final /* synthetic */ AnchoredDraggableState<T> this$0;
                                        {
                                            this.$block = $block;
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object object) {
                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    Pair pair = (Pair)this.L$0;
                                                    DraggableAnchors latestAnchors = (DraggableAnchors)pair.component1();
                                                    Object latestTarget = pair.component2();
                                                    this.label = 1;
                                                    Object object3 = this.$block.invoke((Object)AnchoredDraggableState.access$getAnchoredDragScope$p(this.this$0), (Object)latestAnchors, latestTarget, (Object)((Object)this));
                                                    if (object3 != object2) return Unit.INSTANCE;
                                                    return object2;
                                                }
                                                case 1: {
                                                    void $result;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object3 = $result;
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value2;
                                            return (Continuation)var3_3;
                                        }

                                        public final Object invoke(Pair<? extends DraggableAnchors<T>, ? extends T> p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Pair invokeSuspend$lambda$0(AnchoredDraggableState this$0) {
                            return TuplesKt.to(this$0.getAnchors(), this$0.getTargetValue());
                        }
                    }, $continuation);
                    ** if (v0 != var9_7) goto lbl20
lbl19:
                    // 1 sources

                    return var9_7;
lbl20:
                    // 1 sources

                    break block12;
                }
                case 1: {
                    this = (AnchoredDraggableState)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        break block12;
                    }
                    catch (Throwable var5_9) {
                        throw var5_9;
                    }
                    finally {
                        this.setDragTarget(null);
                        closest = this.getAnchors().closestAnchor(this.getOffset());
                        if (closest != null && Math.abs(this.getOffset() - this.getAnchors().positionOf(closest)) <= 0.5f && ((Boolean)this.confirmValueChange.invoke(closest)).booleanValue()) {
                            this.setCurrentValue(closest);
                        }
                    }
                }
            }
            this.setCurrentValue(targetValue);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object anchoredDrag$default(AnchoredDraggableState anchoredDraggableState, Object object, MutatePriority mutatePriority, Function4 function4, Continuation continuation, int n, Object object2) {
        if ((n & 2) != 0) {
            mutatePriority = MutatePriority.Default;
        }
        return anchoredDraggableState.anchoredDrag(object, mutatePriority, function4, (Continuation<Unit>)continuation);
    }

    public final float newOffsetForDelta$material(float delta) {
        return RangesKt.coerceIn((float)((Float.isNaN(this.getOffset()) ? 0.0f : this.getOffset()) + delta), (float)this.getAnchors().minAnchor(), (float)this.getAnchors().maxAnchor());
    }

    private final boolean trySnapTo(T targetValue) {
        return this.dragMutex.tryMutate((Function0<Unit>)((Function0)() -> AnchoredDraggableState.trySnapTo$lambda$9(this, targetValue)));
    }

    private static final Object targetValue_delegate$lambda$3(AnchoredDraggableState this$0) {
        Object t2 = this$0.getDragTarget();
        if (t2 == null) {
            AnchoredDraggableState $this$targetValue_delegate_u24lambda_u243_u24lambda_u242 = this$0;
            boolean bl = false;
            float currentOffset = $this$targetValue_delegate_u24lambda_u243_u24lambda_u242.getOffset();
            t2 = !Float.isNaN(currentOffset) ? $this$targetValue_delegate_u24lambda_u243_u24lambda_u242.computeTarget(currentOffset, $this$targetValue_delegate_u24lambda_u243_u24lambda_u242.getCurrentValue(), 0.0f) : $this$targetValue_delegate_u24lambda_u243_u24lambda_u242.getCurrentValue();
        }
        return t2;
    }

    private static final Object closestValue_delegate$lambda$5(AnchoredDraggableState this$0) {
        Object t2 = this$0.getDragTarget();
        if (t2 == null) {
            AnchoredDraggableState $this$closestValue_delegate_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            float currentOffset = $this$closestValue_delegate_u24lambda_u245_u24lambda_u244.getOffset();
            t2 = !Float.isNaN(currentOffset) ? $this$closestValue_delegate_u24lambda_u245_u24lambda_u244.computeTargetWithoutThresholds(currentOffset, $this$closestValue_delegate_u24lambda_u245_u24lambda_u244.getCurrentValue()) : $this$closestValue_delegate_u24lambda_u245_u24lambda_u244.getCurrentValue();
        }
        return t2;
    }

    private static final float progress_delegate$lambda$7(AnchoredDraggableState this$0) {
        float progress2;
        float a = this$0.getAnchors().positionOf(this$0.getCurrentValue());
        float b = this$0.getAnchors().positionOf(this$0.getClosestValue$material());
        float distance = Math.abs(b - a);
        return !Float.isNaN(distance) && distance > 1.0E-6f ? ((progress2 = (this$0.requireOffset() - a) / (b - a)) < 1.0E-6f ? 0.0f : (progress2 > 0.999999f ? 1.0f : progress2)) : 1.0f;
    }

    private static final Unit trySnapTo$lambda$9(AnchoredDraggableState this$0, Object $targetValue) {
        AnchoredDragScope $this$trySnapTo_u24lambda_u249_u24lambda_u248 = this$0.anchoredDragScope;
        boolean bl = false;
        float targetOffset = this$0.getAnchors().positionOf($targetValue);
        if (!Float.isNaN(targetOffset)) {
            AnchoredDragScope.dragTo$default($this$trySnapTo_u24lambda_u249_u24lambda_u248, targetOffset, 0.0f, 2, null);
            this$0.setDragTarget(null);
        }
        this$0.setCurrentValue($targetValue);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AnchoredDragScope access$getAnchoredDragScope$p(AnchoredDraggableState $this) {
        return $this.anchoredDragScope;
    }

    public static final /* synthetic */ void access$setDragTarget(AnchoredDraggableState $this, Object object) {
        $this.setDragTarget(object);
    }

    public static final /* synthetic */ void access$setOffset(AnchoredDraggableState $this, float f) {
        $this.setOffset(f);
    }

    public static final /* synthetic */ void access$setLastVelocity(AnchoredDraggableState $this, float f) {
        $this.setLastVelocity(f);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

