/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.window;

import androidx.compose.foundation.window.DragHandler;
import androidx.compose.foundation.window.WindowDraggableArea_desktopKt;
import androidx.compose.ui.unit.IntOffset;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DragHandler {
    @NotNull
    private final Window window;
    @Nullable
    private IntOffset windowLocationAtDragStart;
    @Nullable
    private IntOffset dragStartPoint;
    @NotNull
    private final dragListener.1 dragListener;
    @NotNull
    private final removeListener.1 removeListener;

    public DragHandler(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.window = window;
        this.dragListener = new MouseMotionAdapter(this){
            final /* synthetic */ DragHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDragged(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DragHandler.access$onDrag(this.this$0);
            }
        };
        this.removeListener = new MouseAdapter(this){
            final /* synthetic */ DragHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseReleased(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DragHandler.access$getWindow$p(this.this$0).removeMouseMotionListener(DragHandler.access$getDragListener$p(this.this$0));
                DragHandler.access$getWindow$p(this.this$0).removeMouseListener(this);
            }
        };
    }

    public final void onDragStarted() {
        IntOffset intOffset = WindowDraggableArea_desktopKt.access$currentPointerLocation();
        if (intOffset == null) {
            return;
        }
        this.dragStartPoint = intOffset;
        Point point = this.window.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
        this.windowLocationAtDragStart = IntOffset.box-impl(WindowDraggableArea_desktopKt.access$toComposeOffset(point));
        this.window.addMouseListener(this.removeListener);
        this.window.addMouseMotionListener(this.dragListener);
    }

    private final void onDrag() {
        IntOffset intOffset = this.windowLocationAtDragStart;
        if (intOffset == null) {
            return;
        }
        long windowLocationAtDragStart = intOffset.unbox-impl();
        IntOffset intOffset2 = this.dragStartPoint;
        if (intOffset2 == null) {
            return;
        }
        long dragStartPoint = intOffset2.unbox-impl();
        IntOffset intOffset3 = WindowDraggableArea_desktopKt.access$currentPointerLocation();
        if (intOffset3 == null) {
            return;
        }
        long point = intOffset3.unbox-impl();
        long newLocation = IntOffset.plus-qkQi6aY(windowLocationAtDragStart, IntOffset.minus-qkQi6aY(point, dragStartPoint));
        this.window.setLocation(IntOffset.getX-impl(newLocation), IntOffset.getY-impl(newLocation));
    }

    public static final /* synthetic */ void access$onDrag(DragHandler $this) {
        $this.onDrag();
    }

    public static final /* synthetic */ Window access$getWindow$p(DragHandler $this) {
        return $this.window;
    }

    public static final /* synthetic */ dragListener.1 access$getDragListener$p(DragHandler $this) {
        return $this.dragListener;
    }
}

