/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.collection.MutableLongObjectMap;
import androidx.compose.foundation.AtomicLong;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionAdjustment;
import androidx.compose.foundation.text.selection.SelectionRegistrar;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverKt;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.layout.LayoutCoordinates;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nSelectionRegistrarImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionRegistrarImpl.kt\nandroidx/compose/foundation/text/selection/SelectionRegistrarImpl\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 4 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,217:1\n85#2:218\n113#2,2:219\n97#3,4:221\n97#3,4:225\n69#4:229\n65#4:232\n69#4:235\n70#5:230\n60#5:233\n70#5:236\n22#6:231\n22#6:234\n22#6:237\n*S KotlinDebug\n*F\n+ 1 SelectionRegistrarImpl.kt\nandroidx/compose/foundation/text/selection/SelectionRegistrarImpl\n*L\n100#1:218\n100#1:219,2\n103#1:221,4\n106#1:225,4\n155#1:229\n156#1:232\n158#1:235\n155#1:230\n156#1:233\n158#1:236\n155#1:231\n156#1:234\n158#1:237\n*E\n"})
public final class SelectionRegistrarImpl
implements SelectionRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean sorted;
    @NotNull
    private final List<Selectable> _selectables = new ArrayList();
    @NotNull
    private final MutableLongObjectMap<Selectable> _selectableMap = LongObjectMapKt.mutableLongObjectMapOf();
    @NotNull
    private AtomicLong incrementId;
    @Nullable
    private Function1<? super Long, Unit> onPositionChangeCallback;
    @Nullable
    private Function4<? super Boolean, ? super LayoutCoordinates, ? super Offset, ? super SelectionAdjustment, Unit> onSelectionUpdateStartCallback;
    @Nullable
    private Function2<? super Boolean, ? super Long, Unit> onSelectionUpdateSelectAll;
    @Nullable
    private Function6<? super Boolean, ? super LayoutCoordinates, ? super Offset, ? super Offset, ? super Boolean, ? super SelectionAdjustment, Boolean> onSelectionUpdateCallback;
    @Nullable
    private Function0<Unit> onSelectionUpdateEndCallback;
    @Nullable
    private Function1<? super Long, Unit> onSelectableChangeCallback;
    @Nullable
    private Function1<? super Long, Unit> afterSelectableUnsubscribe;
    @NotNull
    private final MutableState subselections$delegate;
    public static final int $stable = 8;
    @NotNull
    private static final Saver<SelectionRegistrarImpl, Long> Saver = SaverKt.Saver(SelectionRegistrarImpl::Saver$lambda$4, SelectionRegistrarImpl::Saver$lambda$5);

    private SelectionRegistrarImpl(long initialIncrementId) {
        this.incrementId = new AtomicLong(initialIncrementId);
        this.subselections$delegate = SnapshotStateKt.mutableStateOf$default(LongObjectMapKt.emptyLongObjectMap(), null, 2, null);
    }

    public SelectionRegistrarImpl() {
        this(1L);
    }

    @NotNull
    public final List<Selectable> getSelectables$foundation() {
        return this._selectables;
    }

    @NotNull
    public final LongObjectMap<Selectable> getSelectableMap$foundation() {
        return (LongObjectMap)this._selectableMap;
    }

    public final void setOnPositionChangeCallback$foundation(@Nullable Function1<? super Long, Unit> function1) {
        this.onPositionChangeCallback = function1;
    }

    public final void setOnSelectionUpdateStartCallback$foundation(@Nullable Function4<? super Boolean, ? super LayoutCoordinates, ? super Offset, ? super SelectionAdjustment, Unit> function4) {
        this.onSelectionUpdateStartCallback = function4;
    }

    public final void setOnSelectionUpdateSelectAll$foundation(@Nullable Function2<? super Boolean, ? super Long, Unit> function2) {
        this.onSelectionUpdateSelectAll = function2;
    }

    public final void setOnSelectionUpdateCallback$foundation(@Nullable Function6<? super Boolean, ? super LayoutCoordinates, ? super Offset, ? super Offset, ? super Boolean, ? super SelectionAdjustment, Boolean> function6) {
        this.onSelectionUpdateCallback = function6;
    }

    public final void setOnSelectionUpdateEndCallback$foundation(@Nullable Function0<Unit> function0) {
        this.onSelectionUpdateEndCallback = function0;
    }

    public final void setOnSelectableChangeCallback$foundation(@Nullable Function1<? super Long, Unit> function1) {
        this.onSelectableChangeCallback = function1;
    }

    public final void setAfterSelectableUnsubscribe$foundation(@Nullable Function1<? super Long, Unit> function1) {
        this.afterSelectableUnsubscribe = function1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LongObjectMap<Selection> getSubselections() {
        void $this$getValue$iv;
        State state2 = this.subselections$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (LongObjectMap)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setSubselections(@NotNull LongObjectMap<Selection> longObjectMap) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter(longObjectMap, (String)"<set-?>");
        MutableState mutableState = this.subselections$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(longObjectMap);
    }

    @Override
    @NotNull
    public Selectable subscribe(@NotNull Selectable selectable) {
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"selectable");
        boolean value$iv = selectable.getSelectableId() != 0L;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("The selectable contains an invalid id: " + selectable.getSelectableId());
        }
        value$iv = !this._selectableMap.containsKey(selectable.getSelectableId());
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Another selectable with the id: " + selectable + ".selectableId has already subscribed.");
        }
        this._selectableMap.set(selectable.getSelectableId(), (Object)selectable);
        this._selectables.add(selectable);
        this.sorted = false;
        return selectable;
    }

    @Override
    public void unsubscribe(@NotNull Selectable selectable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)selectable, (String)"selectable");
            if (!this._selectableMap.containsKey(selectable.getSelectableId())) {
                return;
            }
            this._selectables.remove(selectable);
            this._selectableMap.remove(selectable.getSelectableId());
            Function1<? super Long, Unit> function1 = this.afterSelectableUnsubscribe;
            if (function1 == null) break block1;
            function1.invoke((Object)selectable.getSelectableId());
        }
    }

    @Override
    public long nextSelectableId() {
        long id = this.incrementId.getAndIncrement();
        while (id == 0L) {
            id = this.incrementId.getAndIncrement();
        }
        return id;
    }

    @NotNull
    public final List<Selectable> sort(@NotNull LayoutCoordinates containerLayoutCoordinates) {
        Intrinsics.checkNotNullParameter((Object)containerLayoutCoordinates, (String)"containerLayoutCoordinates");
        if (!this.sorted) {
            CollectionsKt.sortWith(this._selectables, (arg_0, arg_1) -> SelectionRegistrarImpl.sort$lambda$3((arg_0, arg_1) -> SelectionRegistrarImpl.sort$lambda$2(containerLayoutCoordinates, arg_0, arg_1), arg_0, arg_1));
            this.sorted = true;
        }
        return this.getSelectables$foundation();
    }

    @Override
    public void notifyPositionChange(long selectableId) {
        block0: {
            this.sorted = false;
            Function1<? super Long, Unit> function1 = this.onPositionChangeCallback;
            if (function1 == null) break block0;
            function1.invoke((Object)selectableId);
        }
    }

    @Override
    public void notifySelectionUpdateStart-ubNVwUQ(@NotNull LayoutCoordinates layoutCoordinates, long startPosition, @NotNull SelectionAdjustment adjustment, boolean isInTouchMode) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
            Intrinsics.checkNotNullParameter((Object)adjustment, (String)"adjustment");
            Function4<? super Boolean, ? super LayoutCoordinates, ? super Offset, ? super SelectionAdjustment, Unit> function4 = this.onSelectionUpdateStartCallback;
            if (function4 == null) break block0;
            function4.invoke((Object)isInTouchMode, (Object)layoutCoordinates, (Object)Offset.box-impl(startPosition), (Object)adjustment);
        }
    }

    @Override
    public boolean notifySelectionUpdate-njBpvok(@NotNull LayoutCoordinates layoutCoordinates, long newPosition, long previousPosition, boolean isStartHandle, @NotNull SelectionAdjustment adjustment, boolean isInTouchMode) {
        Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
        Intrinsics.checkNotNullParameter((Object)adjustment, (String)"adjustment");
        Function6<? super Boolean, ? super LayoutCoordinates, ? super Offset, ? super Offset, ? super Boolean, ? super SelectionAdjustment, Boolean> function6 = this.onSelectionUpdateCallback;
        return function6 != null ? (Boolean)function6.invoke((Object)isInTouchMode, (Object)layoutCoordinates, (Object)Offset.box-impl(newPosition), (Object)Offset.box-impl(previousPosition), (Object)isStartHandle, (Object)adjustment) : true;
    }

    @Override
    public void notifySelectionUpdateEnd() {
        block0: {
            Function0<Unit> function0 = this.onSelectionUpdateEndCallback;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    @Override
    public void notifySelectableChange(long selectableId) {
        block0: {
            Function1<? super Long, Unit> function1 = this.onSelectableChangeCallback;
            if (function1 == null) break block0;
            function1.invoke((Object)selectableId);
        }
    }

    private static final int sort$lambda$2(LayoutCoordinates $containerLayoutCoordinates, Selectable a, Selectable b) {
        int n;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        LayoutCoordinates layoutCoordinatesA = a.getLayoutCoordinates();
        LayoutCoordinates layoutCoordinatesB = b.getLayoutCoordinates();
        long positionA = layoutCoordinatesA != null ? $containerLayoutCoordinates.localPositionOf-R5De75A(layoutCoordinatesA, Offset.Companion.getZero-F1C5BW0()) : Offset.Companion.getZero-F1C5BW0();
        long positionB = layoutCoordinatesB != null ? $containerLayoutCoordinates.localPositionOf-R5De75A(layoutCoordinatesB, Offset.Companion.getZero-F1C5BW0()) : Offset.Companion.getZero-F1C5BW0();
        boolean bl = false;
        long value$iv$iv = positionA;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        bl = false;
        value$iv$iv = positionB;
        $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        if (f == Float.intBitsToFloat(bits$iv$iv$iv)) {
            boolean bl2 = false;
            value$iv$iv = positionA;
            boolean $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            Comparable comparable = Float.valueOf(Float.intBitsToFloat(bits$iv$iv$iv));
            bl2 = false;
            value$iv$iv = positionB;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Float.valueOf(Float.intBitsToFloat(bits$iv$iv$iv)));
        } else {
            bl = false;
            value$iv$iv = positionA;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            Comparable comparable = Float.valueOf(Float.intBitsToFloat(bits$iv$iv$iv));
            bl = false;
            value$iv$iv = positionB;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Float.valueOf(Float.intBitsToFloat(bits$iv$iv$iv)));
        }
        return n;
    }

    private static final int sort$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final Long Saver$lambda$4(SaverScope $this$Saver, SelectionRegistrarImpl it) {
        Intrinsics.checkNotNullParameter((Object)$this$Saver, (String)"$this$Saver");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.incrementId.get();
    }

    private static final SelectionRegistrarImpl Saver$lambda$5(long it) {
        return new SelectionRegistrarImpl(it);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<SelectionRegistrarImpl, Long> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

