/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.selection.BoundaryFunction;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import androidx.compose.foundation.text.selection.SelectionLayoutKt;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSelectionAdjustment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionAdjustment.kt\nandroidx/compose/foundation/text/selection/SelectionAdjustmentKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,417:1\n1#2:418\n*E\n"})
public final class SelectionAdjustmentKt {
    private static final Selection.AnchorInfo updateSelectionBoundary(SelectionLayout $this$updateSelectionBoundary, SelectableInfo info, Selection.AnchorInfo previousSelectionAnchor) {
        int currentSlot;
        int currentRawOffset = $this$updateSelectionBoundary.isStartHandle() ? info.getRawStartHandleOffset() : info.getRawEndHandleOffset();
        int n = currentSlot = $this$updateSelectionBoundary.isStartHandle() ? $this$updateSelectionBoundary.getStartSlot() : $this$updateSelectionBoundary.getEndSlot();
        if (currentSlot != info.getSlot()) {
            return info.anchorForOffset(currentRawOffset);
        }
        Lazy currentRawLine$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SelectionAdjustmentKt.updateSelectionBoundary$lambda$0(info, currentRawOffset));
        int otherRawOffset = $this$updateSelectionBoundary.isStartHandle() ? info.getRawEndHandleOffset() : info.getRawStartHandleOffset();
        Lazy anchorSnappedToWordBoundary$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SelectionAdjustmentKt.updateSelectionBoundary$lambda$2(info, currentRawOffset, otherRawOffset, $this$updateSelectionBoundary, currentRawLine$delegate));
        if (info.getSelectableId() != previousSelectionAnchor.getSelectableId()) {
            return SelectionAdjustmentKt.updateSelectionBoundary$lambda$3((Lazy<Selection.AnchorInfo>)anchorSnappedToWordBoundary$delegate);
        }
        int rawPreviousHandleOffset = info.getRawPreviousHandleOffset();
        if (currentRawOffset == rawPreviousHandleOffset) {
            return previousSelectionAnchor;
        }
        int previousRawLine = info.getTextLayoutResult().getLineForOffset(rawPreviousHandleOffset);
        if (SelectionAdjustmentKt.updateSelectionBoundary$lambda$1((Lazy<Integer>)currentRawLine$delegate) != previousRawLine) {
            return SelectionAdjustmentKt.updateSelectionBoundary$lambda$3((Lazy<Selection.AnchorInfo>)anchorSnappedToWordBoundary$delegate);
        }
        int previousSelectionOffset = previousSelectionAnchor.getOffset();
        long previousSelectionWordBoundary = info.getTextLayoutResult().getWordBoundary--jx7JFs(previousSelectionOffset);
        if (!SelectionAdjustmentKt.isExpanding(info, currentRawOffset, $this$updateSelectionBoundary.isStartHandle())) {
            return info.anchorForOffset(currentRawOffset);
        }
        if (previousSelectionOffset == TextRange.getStart-impl(previousSelectionWordBoundary) || previousSelectionOffset == TextRange.getEnd-impl(previousSelectionWordBoundary)) {
            return SelectionAdjustmentKt.updateSelectionBoundary$lambda$3((Lazy<Selection.AnchorInfo>)anchorSnappedToWordBoundary$delegate);
        }
        return info.anchorForOffset(currentRawOffset);
    }

    private static final boolean isExpanding(SelectableInfo $this$isExpanding, int currentRawOffset, boolean isStart) {
        boolean crossed;
        if ($this$isExpanding.getRawPreviousHandleOffset() == -1) {
            return true;
        }
        if (currentRawOffset == $this$isExpanding.getRawPreviousHandleOffset()) {
            return false;
        }
        boolean bl = crossed = $this$isExpanding.getRawCrossStatus() == CrossStatus.CROSSED;
        return isStart ^ crossed ? currentRawOffset < $this$isExpanding.getRawPreviousHandleOffset() : currentRawOffset > $this$isExpanding.getRawPreviousHandleOffset();
    }

    private static final Selection.AnchorInfo snapToWordBoundary(SelectableInfo $this$snapToWordBoundary, int currentLine, int currentOffset, int otherOffset, boolean isStart, boolean crossed) {
        int end;
        long wordBoundary = $this$snapToWordBoundary.getTextLayoutResult().getWordBoundary--jx7JFs(currentOffset);
        int wordStartLine = $this$snapToWordBoundary.getTextLayoutResult().getLineForOffset(TextRange.getStart-impl(wordBoundary));
        int start2 = wordStartLine == currentLine ? TextRange.getStart-impl(wordBoundary) : (currentLine >= $this$snapToWordBoundary.getTextLayoutResult().getLineCount() ? $this$snapToWordBoundary.getTextLayoutResult().getLineStart($this$snapToWordBoundary.getTextLayoutResult().getLineCount() - 1) : $this$snapToWordBoundary.getTextLayoutResult().getLineStart(currentLine));
        int wordEndLine = $this$snapToWordBoundary.getTextLayoutResult().getLineForOffset(TextRange.getEnd-impl(wordBoundary));
        int n = wordEndLine == currentLine ? TextRange.getEnd-impl(wordBoundary) : (end = currentLine >= $this$snapToWordBoundary.getTextLayoutResult().getLineCount() ? TextLayoutResult.getLineEnd$default($this$snapToWordBoundary.getTextLayoutResult(), $this$snapToWordBoundary.getTextLayoutResult().getLineCount() - 1, false, 2, null) : TextLayoutResult.getLineEnd$default($this$snapToWordBoundary.getTextLayoutResult(), currentLine, false, 2, null));
        if (start2 == otherOffset) {
            return $this$snapToWordBoundary.anchorForOffset(end);
        }
        if (end == otherOffset) {
            return $this$snapToWordBoundary.anchorForOffset(start2);
        }
        int resultOffset = isStart ^ crossed ? (currentOffset <= end ? start2 : end) : (currentOffset >= start2 ? end : start2);
        return $this$snapToWordBoundary.anchorForOffset(resultOffset);
    }

    private static final Selection adjustToBoundaries(SelectionLayout layout2, BoundaryFunction boundaryFunction) {
        boolean crossed = layout2.getCrossStatus() == CrossStatus.CROSSED;
        return new Selection(SelectionAdjustmentKt.anchorOnBoundary(layout2.getStartInfo(), crossed, true, layout2.getStartSlot(), boundaryFunction), SelectionAdjustmentKt.anchorOnBoundary(layout2.getEndInfo(), crossed, false, layout2.getEndSlot(), boundaryFunction), crossed);
    }

    private static final Selection.AnchorInfo anchorOnBoundary(SelectableInfo $this$anchorOnBoundary, boolean crossed, boolean isStart, int slot, BoundaryFunction boundaryFunction) {
        int offset;
        int n = offset = isStart ? $this$anchorOnBoundary.getRawStartHandleOffset() : $this$anchorOnBoundary.getRawEndHandleOffset();
        if (slot != $this$anchorOnBoundary.getSlot()) {
            return $this$anchorOnBoundary.anchorForOffset(offset);
        }
        BoundaryFunction $this$anchorOnBoundary_u24lambda_u244 = boundaryFunction;
        boolean bl = false;
        long range = $this$anchorOnBoundary_u24lambda_u244.getBoundary-fzxv0v0($this$anchorOnBoundary, offset);
        return $this$anchorOnBoundary.anchorForOffset(isStart ^ crossed ? TextRange.getStart-impl(range) : TextRange.getEnd-impl(range));
    }

    @NotNull
    public static final Selection ensureAtLeastOneChar(@NotNull Selection $this$ensureAtLeastOneChar, @NotNull SelectionLayout layout2) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureAtLeastOneChar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        if (!SelectionLayoutKt.isCollapsed($this$ensureAtLeastOneChar, layout2)) {
            return $this$ensureAtLeastOneChar;
        }
        String text2 = layout2.getCurrentInfo().getInputText();
        if (layout2.getSize() > 1 || layout2.getPreviousSelection() == null || ((CharSequence)text2).length() == 0) {
            return $this$ensureAtLeastOneChar;
        }
        return SelectionAdjustmentKt.expandOneChar($this$ensureAtLeastOneChar, layout2);
    }

    private static final Selection expandOneChar(Selection $this$expandOneChar, SelectionLayout layout2) {
        Selection selection;
        SelectableInfo info = layout2.getCurrentInfo();
        String text2 = info.getInputText();
        int offset = info.getRawStartHandleOffset();
        int lastOffset = text2.length();
        int n = offset;
        if (n == 0) {
            int followingBreak = StringHelpers_skikoKt.findFollowingBreak(text2, 0);
            selection = layout2.isStartHandle() ? Selection.copy$default($this$expandOneChar, SelectionAdjustmentKt.changeOffset($this$expandOneChar.getStart(), info, followingBreak), null, true, 2, null) : Selection.copy$default($this$expandOneChar, null, SelectionAdjustmentKt.changeOffset($this$expandOneChar.getEnd(), info, followingBreak), false, 1, null);
        } else if (n == lastOffset) {
            int precedingBreak = StringHelpers_skikoKt.findPrecedingBreak(text2, lastOffset);
            selection = layout2.isStartHandle() ? Selection.copy$default($this$expandOneChar, SelectionAdjustmentKt.changeOffset($this$expandOneChar.getStart(), info, precedingBreak), null, false, 2, null) : Selection.copy$default($this$expandOneChar, null, SelectionAdjustmentKt.changeOffset($this$expandOneChar.getEnd(), info, precedingBreak), true, 1, null);
        } else {
            Selection selection2 = layout2.getPreviousSelection();
            boolean crossed = selection2 != null ? selection2.getHandlesCrossed() : false;
            int newOffset = layout2.isStartHandle() ^ crossed ? StringHelpers_skikoKt.findPrecedingBreak(text2, offset) : StringHelpers_skikoKt.findFollowingBreak(text2, offset);
            selection = layout2.isStartHandle() ? Selection.copy$default($this$expandOneChar, SelectionAdjustmentKt.changeOffset($this$expandOneChar.getStart(), info, newOffset), null, crossed, 2, null) : Selection.copy$default($this$expandOneChar, null, SelectionAdjustmentKt.changeOffset($this$expandOneChar.getEnd(), info, newOffset), crossed, 1, null);
        }
        return selection;
    }

    private static final Selection.AnchorInfo changeOffset(Selection.AnchorInfo $this$changeOffset, SelectableInfo info, int newOffset) {
        return Selection.AnchorInfo.copy$default($this$changeOffset, info.getTextLayoutResult().getBidiRunDirection(newOffset), newOffset, 0L, 4, null);
    }

    private static final int updateSelectionBoundary$lambda$0(SelectableInfo $info, int $currentRawOffset) {
        return $info.getTextLayoutResult().getLineForOffset($currentRawOffset);
    }

    private static final int updateSelectionBoundary$lambda$1(Lazy<Integer> $currentRawLine$delegate) {
        Lazy<Integer> lazy = $currentRawLine$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private static final Selection.AnchorInfo updateSelectionBoundary$lambda$2(SelectableInfo $info, int $currentRawOffset, int $otherRawOffset, SelectionLayout $this_updateSelectionBoundary, Lazy $currentRawLine$delegate) {
        return SelectionAdjustmentKt.snapToWordBoundary($info, SelectionAdjustmentKt.updateSelectionBoundary$lambda$1((Lazy<Integer>)$currentRawLine$delegate), $currentRawOffset, $otherRawOffset, $this_updateSelectionBoundary.isStartHandle(), $this_updateSelectionBoundary.getCrossStatus() == CrossStatus.CROSSED);
    }

    private static final Selection.AnchorInfo updateSelectionBoundary$lambda$3(Lazy<Selection.AnchorInfo> $anchorSnappedToWordBoundary$delegate) {
        Lazy<Selection.AnchorInfo> lazy = $anchorSnappedToWordBoundary$delegate;
        return (Selection.AnchorInfo)lazy.getValue();
    }

    public static final /* synthetic */ Selection access$adjustToBoundaries(SelectionLayout layout2, BoundaryFunction boundaryFunction) {
        return SelectionAdjustmentKt.adjustToBoundaries(layout2, boundaryFunction);
    }

    public static final /* synthetic */ Selection.AnchorInfo access$updateSelectionBoundary(SelectionLayout $receiver, SelectableInfo info, Selection.AnchorInfo previousSelectionAnchor) {
        return SelectionAdjustmentKt.updateSelectionBoundary($receiver, info, previousSelectionAnchor);
    }
}

