/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutKt;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SelectableInfo {
    private final long selectableId;
    private final int slot;
    private final int rawStartHandleOffset;
    private final int rawEndHandleOffset;
    private final int rawPreviousHandleOffset;
    @NotNull
    private final TextLayoutResult textLayoutResult;
    public static final int $stable = TextLayoutResult.$stable;

    public SelectableInfo(long selectableId, int slot, int rawStartHandleOffset, int rawEndHandleOffset, int rawPreviousHandleOffset, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        this.selectableId = selectableId;
        this.slot = slot;
        this.rawStartHandleOffset = rawStartHandleOffset;
        this.rawEndHandleOffset = rawEndHandleOffset;
        this.rawPreviousHandleOffset = rawPreviousHandleOffset;
        this.textLayoutResult = textLayoutResult;
    }

    public final long getSelectableId() {
        return this.selectableId;
    }

    public final int getSlot() {
        return this.slot;
    }

    public final int getRawStartHandleOffset() {
        return this.rawStartHandleOffset;
    }

    public final int getRawEndHandleOffset() {
        return this.rawEndHandleOffset;
    }

    public final int getRawPreviousHandleOffset() {
        return this.rawPreviousHandleOffset;
    }

    @NotNull
    public final TextLayoutResult getTextLayoutResult() {
        return this.textLayoutResult;
    }

    @NotNull
    public final String getInputText() {
        return this.textLayoutResult.getLayoutInput().getText().getText();
    }

    public final int getTextLength() {
        return this.getInputText().length();
    }

    @NotNull
    public final CrossStatus getRawCrossStatus() {
        return this.rawStartHandleOffset < this.rawEndHandleOffset ? CrossStatus.NOT_CROSSED : (this.rawStartHandleOffset > this.rawEndHandleOffset ? CrossStatus.CROSSED : CrossStatus.COLLAPSED);
    }

    private final ResolvedTextDirection getStartRunDirection() {
        return SelectionLayoutKt.access$getTextDirectionForOffset(this.textLayoutResult, this.rawStartHandleOffset);
    }

    private final ResolvedTextDirection getEndRunDirection() {
        return SelectionLayoutKt.access$getTextDirectionForOffset(this.textLayoutResult, this.rawEndHandleOffset);
    }

    public final boolean shouldRecomputeSelection(@NotNull SelectableInfo other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.selectableId != other.selectableId || this.rawStartHandleOffset != other.rawStartHandleOffset || this.rawEndHandleOffset != other.rawEndHandleOffset;
    }

    @NotNull
    public final Selection.AnchorInfo anchorForOffset(int offset) {
        return new Selection.AnchorInfo(SelectionLayoutKt.access$getTextDirectionForOffset(this.textLayoutResult, offset), offset, this.selectableId);
    }

    @NotNull
    public final Selection makeSingleLayoutSelection(int start2, int end) {
        return new Selection(this.anchorForOffset(start2), this.anchorForOffset(end), start2 > end);
    }

    @NotNull
    public String toString() {
        return "SelectionInfo(id=" + this.selectableId + ", range=(" + this.rawStartHandleOffset + "-" + this.getStartRunDirection() + "," + this.rawEndHandleOffset + "-" + this.getEndRunDirection() + "), prevOffset=" + this.rawPreviousHandleOffset + ")";
    }
}

