/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.SelectionGesturesKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.platform.ViewConfiguration;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClicksCounter {
    @NotNull
    private final ViewConfiguration viewConfiguration;
    private int clicks;
    @Nullable
    private PointerInputChange prevClick;
    public static final int $stable = 8;

    public ClicksCounter(@NotNull ViewConfiguration viewConfiguration) {
        Intrinsics.checkNotNullParameter((Object)viewConfiguration, (String)"viewConfiguration");
        this.viewConfiguration = viewConfiguration;
    }

    public final int getClicks() {
        return this.clicks;
    }

    public final void update(@NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PointerInputChange currentPrevEvent = this.prevClick;
        this.clicks = currentPrevEvent != null && this.timeIsTolerable(currentPrevEvent, event) && this.positionIsTolerable(currentPrevEvent, event) ? ++this.clicks : 1;
        this.prevClick = event;
    }

    public final boolean timeIsTolerable(@NotNull PointerInputChange prevClick, @NotNull PointerInputChange newClick) {
        Intrinsics.checkNotNullParameter((Object)prevClick, (String)"prevClick");
        Intrinsics.checkNotNullParameter((Object)newClick, (String)"newClick");
        return newClick.getUptimeMillis() - prevClick.getUptimeMillis() < this.viewConfiguration.getDoubleTapTimeoutMillis();
    }

    public final boolean positionIsTolerable(@NotNull PointerInputChange prevClick, @NotNull PointerInputChange newClick) {
        Intrinsics.checkNotNullParameter((Object)prevClick, (String)"prevClick");
        Intrinsics.checkNotNullParameter((Object)newClick, (String)"newClick");
        return SelectionGesturesKt.access$distanceIsTolerable(this.viewConfiguration, prevClick, newClick);
    }
}

