/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextAutoSize;
import androidx.compose.foundation.text.modifiers.MultiParagraphLayoutCache;
import androidx.compose.foundation.text.modifiers.SelectionController;
import androidx.compose.foundation.text.modifiers.TextAnnotatedStringNodeKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorProducer;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.AlignmentLineKt;
import androidx.compose.ui.layout.HorizontalAlignmentLine;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.LayoutModifierNode;
import androidx.compose.ui.node.LayoutModifierNodeKt;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextAnnotatedStringNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextAnnotatedStringNode.kt\nandroidx/compose/foundation/text/modifiers/TextAnnotatedStringNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 7 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 8 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,588:1\n1#2:589\n26#3:590\n26#3:591\n54#4:592\n54#4:594\n59#4:596\n59#4:598\n54#4:600\n59#4:602\n54#4:605\n59#4:607\n85#5:593\n85#5:595\n90#5:597\n90#5:599\n85#5:601\n90#5:603\n85#5:606\n90#5:608\n53#5,3:610\n233#6:604\n33#7:609\n635#8:613\n635#8:614\n*S KotlinDebug\n*F\n+ 1 TextAnnotatedStringNode.kt\nandroidx/compose/foundation/text/modifiers/TextAnnotatedStringNode\n*L\n437#1:590\n438#1:591\n449#1:592\n450#1:594\n451#1:596\n452#1:598\n456#1:600\n456#1:602\n528#1:605\n529#1:607\n449#1:593\n450#1:595\n451#1:597\n452#1:599\n456#1:601\n456#1:603\n528#1:606\n529#1:608\n530#1:610,3\n522#1:604\n530#1:609\n552#1:613\n554#1:614\n*E\n"})
public final class TextAnnotatedStringNode
extends Modifier.Node
implements DrawModifierNode,
LayoutModifierNode,
SemanticsModifierNode {
    @NotNull
    private AnnotatedString text;
    @NotNull
    private TextStyle style;
    @NotNull
    private FontFamily.Resolver fontFamilyResolver;
    @Nullable
    private Function1<? super TextLayoutResult, Unit> onTextLayout;
    private int overflow;
    private boolean softWrap;
    private int maxLines;
    private int minLines;
    @Nullable
    private List<AnnotatedString.Range<Placeholder>> placeholders;
    @Nullable
    private Function1<? super List<Rect>, Unit> onPlaceholderLayout;
    @Nullable
    private SelectionController selectionController;
    @Nullable
    private ColorProducer overrideColor;
    @Nullable
    private TextAutoSize autoSize;
    @Nullable
    private Function1<? super TextSubstitutionValue, Unit> onShowTranslation;
    @Nullable
    private Map<AlignmentLine, Integer> baselineCache;
    @Nullable
    private MultiParagraphLayoutCache _layoutCache;
    @Nullable
    private Function1<? super List<TextLayoutResult>, Boolean> semanticsTextLayoutResult;
    @Nullable
    private TextSubstitutionValue textSubstitution;
    public static final int $stable = 8;

    private TextAnnotatedStringNode(AnnotatedString text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, Function1<? super TextLayoutResult, Unit> onTextLayout, int overflow, boolean softWrap, int maxLines, int minLines, List<AnnotatedString.Range<Placeholder>> placeholders, Function1<? super List<Rect>, Unit> onPlaceholderLayout, SelectionController selectionController, ColorProducer overrideColor, TextAutoSize autoSize, Function1<? super TextSubstitutionValue, Unit> onShowTranslation) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.style = style;
        this.fontFamilyResolver = fontFamilyResolver;
        this.onTextLayout = onTextLayout;
        this.overflow = overflow;
        this.softWrap = softWrap;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.placeholders = placeholders;
        this.onPlaceholderLayout = onPlaceholderLayout;
        this.selectionController = selectionController;
        this.overrideColor = overrideColor;
        this.autoSize = autoSize;
        this.onShowTranslation = onShowTranslation;
    }

    @Override
    public boolean getShouldAutoInvalidate() {
        return false;
    }

    private final MultiParagraphLayoutCache getLayoutCache() {
        if (this._layoutCache == null) {
            this._layoutCache = new MultiParagraphLayoutCache(this.text, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, this.placeholders, this.autoSize, null);
        }
        MultiParagraphLayoutCache multiParagraphLayoutCache = this._layoutCache;
        Intrinsics.checkNotNull((Object)multiParagraphLayoutCache);
        return multiParagraphLayoutCache;
    }

    private final MultiParagraphLayoutCache getLayoutCache(Density density) {
        MultiParagraphLayoutCache multiParagraphLayoutCache;
        TextSubstitutionValue textSubstitutionValue = this.textSubstitution;
        if (textSubstitutionValue != null) {
            TextSubstitutionValue textSubstitutionValue2 = textSubstitutionValue;
            boolean bl = false;
            if (textSubstitutionValue2.isShowingSubstitution()) {
                MultiParagraphLayoutCache multiParagraphLayoutCache2 = textSubstitutionValue2.getLayoutCache();
                if (multiParagraphLayoutCache2 != null) {
                    MultiParagraphLayoutCache multiParagraphLayoutCache3;
                    MultiParagraphLayoutCache cache2 = multiParagraphLayoutCache2;
                    boolean bl2 = false;
                    MultiParagraphLayoutCache it = multiParagraphLayoutCache3 = cache2;
                    boolean bl3 = false;
                    it.setDensity$foundation(density);
                    return multiParagraphLayoutCache3;
                }
            }
        }
        MultiParagraphLayoutCache it = multiParagraphLayoutCache = this.getLayoutCache();
        boolean bl = false;
        it.setDensity$foundation(density);
        return multiParagraphLayoutCache;
    }

    public final boolean updateDraw(@Nullable ColorProducer color, @NotNull TextStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        boolean changed = false;
        if (!Intrinsics.areEqual((Object)color, (Object)this.overrideColor)) {
            changed = true;
        }
        this.overrideColor = color;
        changed = changed || !style.hasSameDrawAffectingAttributes(this.style);
        return changed;
    }

    public final boolean updateText$foundation(@NotNull AnnotatedString text2) {
        boolean anyDiff;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean charDiff = !Intrinsics.areEqual((Object)this.text.getText(), (Object)text2.getText());
        boolean annotationDiff = !this.text.hasEqualAnnotations(text2);
        boolean bl = anyDiff = charDiff || annotationDiff;
        if (anyDiff) {
            this.text = text2;
        }
        if (charDiff) {
            this.clearSubstitution$foundation();
        }
        return anyDiff;
    }

    public final boolean updateLayoutRelatedArgs-y0k-MQk(@NotNull TextStyle style, @Nullable List<AnnotatedString.Range<Placeholder>> placeholders, int minLines, int maxLines, boolean softWrap, @NotNull FontFamily.Resolver fontFamilyResolver, int overflow, @Nullable TextAutoSize autoSize) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        boolean changed = false;
        changed = !this.style.hasSameLayoutAffectingAttributes(style);
        this.style = style;
        if (!Intrinsics.areEqual(this.placeholders, placeholders)) {
            this.placeholders = placeholders;
            changed = true;
        }
        if (this.minLines != minLines) {
            this.minLines = minLines;
            changed = true;
        }
        if (this.maxLines != maxLines) {
            this.maxLines = maxLines;
            changed = true;
        }
        if (this.softWrap != softWrap) {
            this.softWrap = softWrap;
            changed = true;
        }
        if (!Intrinsics.areEqual((Object)this.fontFamilyResolver, (Object)fontFamilyResolver)) {
            this.fontFamilyResolver = fontFamilyResolver;
            changed = true;
        }
        if (!TextOverflow.equals-impl0(this.overflow, overflow)) {
            this.overflow = overflow;
            changed = true;
        }
        if (!Intrinsics.areEqual((Object)this.autoSize, (Object)autoSize)) {
            this.autoSize = autoSize;
            changed = true;
        }
        return changed;
    }

    public final boolean updateCallbacks(@Nullable Function1<? super TextLayoutResult, Unit> onTextLayout, @Nullable Function1<? super List<Rect>, Unit> onPlaceholderLayout, @Nullable SelectionController selectionController, @Nullable Function1<? super TextSubstitutionValue, Unit> onShowTranslation) {
        boolean changed = false;
        if (this.onTextLayout != onTextLayout) {
            this.onTextLayout = onTextLayout;
            changed = true;
        }
        if (this.onPlaceholderLayout != onPlaceholderLayout) {
            this.onPlaceholderLayout = onPlaceholderLayout;
            changed = true;
        }
        if (!Intrinsics.areEqual((Object)this.selectionController, (Object)selectionController)) {
            this.selectionController = selectionController;
            changed = true;
        }
        if (this.onShowTranslation != onShowTranslation) {
            this.onShowTranslation = onShowTranslation;
            changed = true;
        }
        return changed;
    }

    public final void doInvalidations(boolean drawChanged, boolean textChanged, boolean layoutChanged, boolean callbacksChanged) {
        if (textChanged || layoutChanged || callbacksChanged) {
            this.getLayoutCache().update-J2qo7bo(this.text, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, this.placeholders, this.autoSize);
        }
        if (!this.isAttached()) {
            return;
        }
        if (textChanged || drawChanged && this.semanticsTextLayoutResult != null) {
            SemanticsModifierNodeKt.invalidateSemantics(this);
        }
        if (textChanged || layoutChanged || callbacksChanged) {
            LayoutModifierNodeKt.invalidateMeasurement(this);
            DrawModifierNodeKt.invalidateDraw(this);
        }
        if (drawChanged) {
            DrawModifierNodeKt.invalidateDraw(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean setSubstitution(AnnotatedString updatedText) {
        TextSubstitutionValue currentTextSubstitution = this.textSubstitution;
        if (currentTextSubstitution != null) {
            if (Intrinsics.areEqual((Object)updatedText, (Object)currentTextSubstitution.getSubstitution())) {
                return false;
            }
            currentTextSubstitution.setSubstitution(updatedText);
            MultiParagraphLayoutCache multiParagraphLayoutCache = currentTextSubstitution.getLayoutCache();
            if (multiParagraphLayoutCache == null) return false;
            multiParagraphLayoutCache.update-J2qo7bo(updatedText, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, CollectionsKt.emptyList(), this.autoSize);
            return true;
        } else {
            TextSubstitutionValue newTextSubstitution = new TextSubstitutionValue(this.text, updatedText, false, null, 12, null);
            MultiParagraphLayoutCache substitutionLayoutCache = new MultiParagraphLayoutCache(updatedText, this.style, this.fontFamilyResolver, this.overflow, this.softWrap, this.maxLines, this.minLines, CollectionsKt.emptyList(), this.autoSize, null);
            substitutionLayoutCache.setDensity$foundation(this.getLayoutCache().getDensity$foundation());
            newTextSubstitution.setLayoutCache(substitutionLayoutCache);
            this.textSubstitution = newTextSubstitution;
        }
        return true;
    }

    private final void invalidateForTranslate() {
        SemanticsModifierNodeKt.invalidateSemantics(this);
        LayoutModifierNodeKt.invalidateMeasurement(this);
        DrawModifierNodeKt.invalidateDraw(this);
    }

    public final void clearSubstitution$foundation() {
        this.textSubstitution = null;
    }

    @Override
    public void applySemantics(@NotNull SemanticsPropertyReceiver $this$applySemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        Function1 localSemanticsTextLayoutResult = this.semanticsTextLayoutResult;
        if (localSemanticsTextLayoutResult == null) {
            this.semanticsTextLayoutResult = localSemanticsTextLayoutResult = arg_0 -> TextAnnotatedStringNode.applySemantics$lambda$5(this, arg_0);
        }
        SemanticsPropertiesKt.setText($this$applySemantics, this.text);
        TextSubstitutionValue currentTextSubstitution = this.textSubstitution;
        if (currentTextSubstitution != null) {
            SemanticsPropertiesKt.setTextSubstitution($this$applySemantics, currentTextSubstitution.getSubstitution());
            SemanticsPropertiesKt.setShowingTextSubstitution($this$applySemantics, currentTextSubstitution.isShowingSubstitution());
        }
        SemanticsPropertiesKt.setTextSubstitution$default($this$applySemantics, null, arg_0 -> TextAnnotatedStringNode.applySemantics$lambda$6(this, arg_0), 1, null);
        SemanticsPropertiesKt.showTextSubstitution$default($this$applySemantics, null, arg_0 -> TextAnnotatedStringNode.applySemantics$lambda$7(this, arg_0), 1, null);
        SemanticsPropertiesKt.clearTextSubstitution$default($this$applySemantics, null, () -> TextAnnotatedStringNode.applySemantics$lambda$8(this), 1, null);
        SemanticsPropertiesKt.getTextLayoutResult$default($this$applySemantics, null, localSemanticsTextLayoutResult, 1, null);
    }

    @NotNull
    public final MeasureResult measureNonExtension-3p2s80s(@NotNull MeasureScope measureScope, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)measureScope, (String)"measureScope");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.measure-3p2s80s(measureScope, measurable, constraints);
    }

    @Override
    @NotNull
    public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        MultiParagraphLayoutCache layoutCache = this.getLayoutCache($this$measure_u2d3p2s80s);
        boolean didChangeLayout = layoutCache.layoutWithConstraints-K40F9xA(constraints, $this$measure_u2d3p2s80s.getLayoutDirection());
        TextLayoutResult textLayoutResult = layoutCache.getTextLayoutResult();
        textLayoutResult.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts();
        if (didChangeLayout) {
            Map cache2;
            Map map2;
            LayoutModifierNodeKt.invalidateLayer(this);
            Function1<? super TextLayoutResult, Unit> function1 = this.onTextLayout;
            if (function1 != null) {
                function1.invoke((Object)textLayoutResult);
            }
            SelectionController selectionController = this.selectionController;
            if (selectionController != null) {
                selectionController.updateTextLayout(textLayoutResult);
            }
            if ((map2 = this.baselineCache) == null) {
                map2 = new LinkedHashMap(2);
            }
            Map map3 = cache2 = map2;
            HorizontalAlignmentLine horizontalAlignmentLine = AlignmentLineKt.getFirstBaseline();
            float $this$fastRoundToInt$iv22 = textLayoutResult.getFirstBaseline();
            boolean $i$f$fastRoundToInt = false;
            Integer $this$fastRoundToInt$iv22 = Math.round($this$fastRoundToInt$iv22);
            map3.put(horizontalAlignmentLine, $this$fastRoundToInt$iv22);
            map3 = cache2;
            horizontalAlignmentLine = AlignmentLineKt.getLastBaseline();
            float $this$fastRoundToInt$iv32 = textLayoutResult.getLastBaseline();
            $i$f$fastRoundToInt = false;
            Integer $this$fastRoundToInt$iv32 = Math.round($this$fastRoundToInt$iv32);
            map3.put(horizontalAlignmentLine, $this$fastRoundToInt$iv32);
            this.baselineCache = cache2;
        }
        Function1<? super List<Rect>, Unit> function1 = this.onPlaceholderLayout;
        if (function1 != null) {
            function1.invoke(textLayoutResult.getPlaceholderRects());
        }
        long arg0$iv = textLayoutResult.getSize-YbymL2g();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        int n = (int)(value$iv$iv >> 32);
        arg0$iv = textLayoutResult.getSize-YbymL2g();
        bl = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackInt1 = false;
        int n2 = (int)(value$iv$iv >> 32);
        arg0$iv = textLayoutResult.getSize-YbymL2g();
        boolean bl2 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt2 = false;
        int n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
        arg0$iv = textLayoutResult.getSize-YbymL2g();
        bl2 = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackInt2 = false;
        Placeable placeable = measurable.measure-BRTryo0(Constraints.Companion.fitPrioritizingWidth-Zbe2FdA(n, n2, n3, (int)(value$iv$iv & 0xFFFFFFFFL)));
        arg0$iv = textLayoutResult.getSize-YbymL2g();
        bl = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackInt1 = false;
        int n4 = (int)(value$iv$iv >> 32);
        arg0$iv = textLayoutResult.getSize-YbymL2g();
        bl2 = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackInt2 = false;
        int n5 = (int)(value$iv$iv & 0xFFFFFFFFL);
        Map<AlignmentLine, Integer> map4 = this.baselineCache;
        Intrinsics.checkNotNull(map4);
        return $this$measure_u2d3p2s80s.layout(n4, n5, map4, (Function1<? super Placeable.PlacementScope, Unit>)((Function1)arg_0 -> TextAnnotatedStringNode.measure_3p2s80s$lambda$9(placeable, arg_0)));
    }

    public final int minIntrinsicWidthNonExtension(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"intrinsicMeasureScope");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.minIntrinsicWidth(intrinsicMeasureScope, measurable, height);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCache($this$minIntrinsicWidth).minIntrinsicWidth($this$minIntrinsicWidth.getLayoutDirection());
    }

    public final int minIntrinsicHeightNonExtension(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"intrinsicMeasureScope");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.minIntrinsicHeight(intrinsicMeasureScope, measurable, width);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCache($this$minIntrinsicHeight).intrinsicHeight(width, $this$minIntrinsicHeight.getLayoutDirection());
    }

    public final int maxIntrinsicWidthNonExtension(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"intrinsicMeasureScope");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.maxIntrinsicWidth(intrinsicMeasureScope, measurable, height);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCache($this$maxIntrinsicWidth).maxIntrinsicWidth($this$maxIntrinsicWidth.getLayoutDirection());
    }

    public final int maxIntrinsicHeightNonExtension(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"intrinsicMeasureScope");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.maxIntrinsicHeight(intrinsicMeasureScope, measurable, width);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.getLayoutCache($this$maxIntrinsicHeight).intrinsicHeight(width, $this$maxIntrinsicHeight.getLayoutDirection());
    }

    public final void drawNonExtension(@NotNull ContentDrawScope contentDrawScope) {
        Intrinsics.checkNotNullParameter((Object)contentDrawScope, (String)"contentDrawScope");
        this.draw(contentDrawScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Collection collection;
        boolean hasLinks;
        boolean willClip;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (!this.isAttached()) {
            return;
        }
        SelectionController selectionController = this.selectionController;
        if (selectionController != null) {
            selectionController.draw($this$draw);
        }
        DrawScope $this$drawIntoCanvas$iv = $this$draw;
        boolean $i$f$drawIntoCanvas = false;
        Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl = false;
        MultiParagraphLayoutCache layoutCache = this.getLayoutCache($this$draw);
        TextLayoutResult textLayoutResult = layoutCache.getTextLayoutResult();
        MultiParagraph localParagraph = textLayoutResult.getMultiParagraph();
        boolean bl2 = willClip = textLayoutResult.getHasVisualOverflow() && !TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getVisible-gIe3tQ8());
        if (willClip) {
            long arg0$iv = textLayoutResult.getSize-YbymL2g();
            boolean bl3 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            float width = (int)(value$iv$iv >> 32);
            long arg0$iv2 = textLayoutResult.getSize-YbymL2g();
            boolean bl4 = false;
            long value$iv$iv2 = arg0$iv2;
            boolean $i$f$unpackInt2 = false;
            float height = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(width);
            long v2$iv$iv = Float.floatToRawIntBits(height);
            Rect bounds = RectKt.Rect-tz77jQw(Offset.Companion.getZero-F1C5BW0(), Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            canvas.save();
            Canvas.clipRect-mtrdD-E$default(canvas, bounds, 0, 2, null);
        }
        try {
            Brush brush;
            DrawStyle drawStyle;
            DrawStyle drawStyle2;
            Shadow shadow;
            Shadow shadow2;
            TextDecoration textDecoration;
            TextDecoration textDecoration2 = this.style.getTextDecoration();
            if (textDecoration2 == null) {
                textDecoration2 = textDecoration = TextDecoration.Companion.getNone();
            }
            if ((shadow2 = this.style.getShadow()) == null) {
                shadow2 = shadow = Shadow.Companion.getNone();
            }
            if ((drawStyle2 = this.style.getDrawStyle()) == null) {
                drawStyle2 = drawStyle = (DrawStyle)Fill.INSTANCE;
            }
            if ((brush = this.style.getBrush()) != null) {
                float alpha2 = this.style.getAlpha();
                MultiParagraph.paint-hn5TExg$default(localParagraph, canvas, brush, alpha2, shadow, textDecoration, drawStyle, 0, 64, null);
            } else {
                long l;
                long overrideColorVal;
                ColorProducer colorProducer2 = this.overrideColor;
                long $this$isSpecified$iv = overrideColorVal = colorProducer2 != null ? colorProducer2.invoke-0d7_KjU() : Color.Companion.getUnspecified-0d7_KjU();
                boolean bl5 = false;
                if ($this$isSpecified$iv != 16L) {
                    l = overrideColorVal;
                } else {
                    $this$isSpecified$iv = this.style.getColor-0d7_KjU();
                    bl5 = false;
                    l = $this$isSpecified$iv != 16L ? this.style.getColor-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
                }
                long color = l;
                MultiParagraph.paint-LG529CI$default(localParagraph, canvas, color, shadow, textDecoration, drawStyle, 0, 32, null);
            }
        }
        finally {
            if (willClip) {
                canvas.restore();
            }
        }
        TextSubstitutionValue textSubstitutionValue = this.textSubstitution;
        boolean bl6 = hasLinks = (textSubstitutionValue != null ? textSubstitutionValue.isShowingSubstitution() : false) ? false : TextAnnotatedStringNodeKt.hasLinks(this.text);
        if (hasLinks || !((collection = (Collection)this.placeholders) == null || collection.isEmpty())) {
            $this$draw.drawContent();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean applySemantics$lambda$5(TextAnnotatedStringNode this$0, List textLayoutResult) {
        TextLayoutResult textLayoutResult2;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        TextLayoutResult inputLayout = this$0.getLayoutCache().getLayoutOrNull();
        if (inputLayout == null) return false;
        ColorProducer colorProducer2 = this$0.overrideColor;
        TextLayoutResult textLayoutResult3 = TextLayoutResult.copy-O0kMr_c$default(inputLayout, new TextLayoutInput(inputLayout.getLayoutInput().getText(), TextStyle.merge-dA7vx0o$default(this$0.style, colorProducer2 != null ? colorProducer2.invoke-0d7_KjU() : Color.Companion.getUnspecified-0d7_KjU(), 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, 0, 0, null, null, 0xFFFFFE, null), inputLayout.getLayoutInput().getPlaceholders(), inputLayout.getLayoutInput().getMaxLines(), inputLayout.getLayoutInput().getSoftWrap(), inputLayout.getLayoutInput().getOverflow-gIe3tQ8(), inputLayout.getLayoutInput().getDensity(), inputLayout.getLayoutInput().getLayoutDirection(), inputLayout.getLayoutInput().getFontFamilyResolver(), inputLayout.getLayoutInput().getConstraints-msEJaDk(), null), 0L, 2, null);
        if (textLayoutResult3 == null) return false;
        TextLayoutResult it = textLayoutResult2 = textLayoutResult3;
        boolean bl = false;
        textLayoutResult.add(it);
        TextLayoutResult textLayoutResult4 = textLayoutResult2;
        TextLayoutResult layout2 = textLayoutResult4;
        if (layout2 == null) return false;
        return true;
    }

    private static final boolean applySemantics$lambda$6(TextAnnotatedStringNode this$0, AnnotatedString updatedText) {
        Intrinsics.checkNotNullParameter((Object)updatedText, (String)"updatedText");
        this$0.setSubstitution(updatedText);
        this$0.invalidateForTranslate();
        return true;
    }

    private static final boolean applySemantics$lambda$7(TextAnnotatedStringNode this$0, boolean it) {
        if (this$0.textSubstitution == null) {
            return false;
        }
        Function1<? super TextSubstitutionValue, Unit> function1 = this$0.onShowTranslation;
        if (function1 != null) {
            TextSubstitutionValue textSubstitutionValue = this$0.textSubstitution;
            Intrinsics.checkNotNull((Object)textSubstitutionValue);
            function1.invoke((Object)textSubstitutionValue);
        }
        TextSubstitutionValue textSubstitutionValue = this$0.textSubstitution;
        if (textSubstitutionValue != null) {
            textSubstitutionValue.setShowingSubstitution(it);
        }
        this$0.invalidateForTranslate();
        return true;
    }

    private static final boolean applySemantics$lambda$8(TextAnnotatedStringNode this$0) {
        this$0.clearSubstitution$foundation();
        this$0.invalidateForTranslate();
        return true;
    }

    private static final Unit measure_3p2s80s$lambda$9(Placeable $placeable, Placeable.PlacementScope $this$layout) {
        Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
        Placeable.PlacementScope.place$default($this$layout, $placeable, 0, 0, 0.0f, 4, null);
        return Unit.INSTANCE;
    }

    public /* synthetic */ TextAnnotatedStringNode(AnnotatedString text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, Function1 onTextLayout, int overflow, boolean softWrap, int maxLines, int minLines, List placeholders, Function1 onPlaceholderLayout, SelectionController selectionController, ColorProducer overrideColor, TextAutoSize autoSize, Function1 onShowTranslation, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, fontFamilyResolver, (Function1<? super TextLayoutResult, Unit>)onTextLayout, overflow, softWrap, maxLines, minLines, placeholders, (Function1<? super List<Rect>, Unit>)onPlaceholderLayout, selectionController, overrideColor, autoSize, (Function1<? super TextSubstitutionValue, Unit>)onShowTranslation);
    }

    public static final class TextSubstitutionValue {
        @NotNull
        private final AnnotatedString original;
        @NotNull
        private AnnotatedString substitution;
        private boolean isShowingSubstitution;
        @Nullable
        private MultiParagraphLayoutCache layoutCache;
        public static final int $stable = 8;

        public TextSubstitutionValue(@NotNull AnnotatedString original, @NotNull AnnotatedString substitution, boolean isShowingSubstitution, @Nullable MultiParagraphLayoutCache layoutCache) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)substitution, (String)"substitution");
            this.original = original;
            this.substitution = substitution;
            this.isShowingSubstitution = isShowingSubstitution;
            this.layoutCache = layoutCache;
        }

        public /* synthetic */ TextSubstitutionValue(AnnotatedString annotatedString, AnnotatedString annotatedString2, boolean bl, MultiParagraphLayoutCache multiParagraphLayoutCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                multiParagraphLayoutCache = null;
            }
            this(annotatedString, annotatedString2, bl, multiParagraphLayoutCache);
        }

        @NotNull
        public final AnnotatedString getOriginal() {
            return this.original;
        }

        @NotNull
        public final AnnotatedString getSubstitution() {
            return this.substitution;
        }

        public final void setSubstitution(@NotNull AnnotatedString annotatedString) {
            Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"<set-?>");
            this.substitution = annotatedString;
        }

        public final boolean isShowingSubstitution() {
            return this.isShowingSubstitution;
        }

        public final void setShowingSubstitution(boolean bl) {
            this.isShowingSubstitution = bl;
        }

        @Nullable
        public final MultiParagraphLayoutCache getLayoutCache() {
            return this.layoutCache;
        }

        public final void setLayoutCache(@Nullable MultiParagraphLayoutCache multiParagraphLayoutCache) {
            this.layoutCache = multiParagraphLayoutCache;
        }

        @NotNull
        public String toString() {
            return "TextSubstitutionValue(original=" + this.original + ", substitution=" + this.substitution + ", isShowingSubstitution=" + this.isShowingSubstitution + ", layoutCache=" + this.layoutCache + ")";
        }

        public int hashCode() {
            int result2 = this.original.hashCode();
            result2 = result2 * 31 + this.substitution.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isShowingSubstitution);
            result2 = result2 * 31 + (this.layoutCache == null ? 0 : this.layoutCache.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextSubstitutionValue)) {
                return false;
            }
            TextSubstitutionValue textSubstitutionValue = (TextSubstitutionValue)other;
            if (!Intrinsics.areEqual((Object)this.original, (Object)textSubstitutionValue.original)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.substitution, (Object)textSubstitutionValue.substitution)) {
                return false;
            }
            if (this.isShowingSubstitution != textSubstitutionValue.isShowingSubstitution) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.layoutCache, (Object)textSubstitutionValue.layoutCache);
        }
    }
}

