/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextAutoSize;
import androidx.compose.foundation.text.TextDelegateKt;
import androidx.compose.foundation.text.modifiers.InlineDensity;
import androidx.compose.foundation.text.modifiers.LayoutUtilsKt;
import androidx.compose.foundation.text.modifiers.MinLinesConstrainer;
import androidx.compose.foundation.text.modifiers.MultiParagraphLayoutCacheKt;
import androidx.compose.foundation.text.modifiers.TextAutoSizeLayoutScope;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.unit.TextUnit;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nMultiParagraphLayoutCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiParagraphLayoutCache.kt\nandroidx/compose/foundation/text/modifiers/MultiParagraphLayoutCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,491:1\n1#2:492\n30#3:493\n80#4:494\n*S KotlinDebug\n*F\n+ 1 MultiParagraphLayoutCache.kt\nandroidx/compose/foundation/text/modifiers/MultiParagraphLayoutCache\n*L\n235#1:493\n235#1:494\n*E\n"})
public final class MultiParagraphLayoutCache {
    @NotNull
    private AnnotatedString text;
    @NotNull
    private FontFamily.Resolver fontFamilyResolver;
    private int overflow;
    private boolean softWrap;
    private int maxLines;
    private int minLines;
    @Nullable
    private List<AnnotatedString.Range<Placeholder>> placeholders;
    @Nullable
    private TextAutoSize autoSize;
    @Nullable
    private MinLinesConstrainer mMinLinesConstrainer;
    private long lastDensity;
    @Nullable
    private Density density;
    @NotNull
    private TextStyle style;
    @Nullable
    private MultiParagraphIntrinsics paragraphIntrinsics;
    @Nullable
    private LayoutDirection intrinsicsLayoutDirection;
    @Nullable
    private TextLayoutResult layoutCache;
    private int cachedIntrinsicHeightInputWidth;
    private int cachedIntrinsicHeight;
    @Nullable
    private TextAutoSizeLayoutScopeImpl _textAutoSizeLayoutScope;
    public static final int $stable = 8;

    private MultiParagraphLayoutCache(AnnotatedString text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, List<AnnotatedString.Range<Placeholder>> placeholders, TextAutoSize autoSize) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.fontFamilyResolver = fontFamilyResolver;
        this.overflow = overflow;
        this.softWrap = softWrap;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.placeholders = placeholders;
        this.autoSize = autoSize;
        this.lastDensity = InlineDensity.Companion.getUnspecified-L26CHvs();
        this.style = style;
        this.cachedIntrinsicHeightInputWidth = -1;
        this.cachedIntrinsicHeight = -1;
    }

    @Nullable
    public final Density getDensity$foundation() {
        return this.density;
    }

    public final void setDensity$foundation(@Nullable Density value2) {
        long newDensity;
        long l;
        Density localField = this.density;
        Density density = value2;
        if (density != null) {
            Density it = density;
            boolean bl = false;
            l = InlineDensity.constructor-impl(it);
        } else {
            l = newDensity = InlineDensity.Companion.getUnspecified-L26CHvs();
        }
        if (localField == null) {
            this.density = value2;
            this.lastDensity = newDensity;
            return;
        }
        if (value2 == null || !InlineDensity.equals-impl0(this.lastDensity, newDensity)) {
            this.density = value2;
            this.lastDensity = newDensity;
            this.markDirty();
        }
    }

    private final void setStyle(TextStyle value2) {
        boolean newStyleHasSameLayoutAffectingAttrs = value2.hasSameLayoutAffectingAttributes(this.style);
        this.style = value2;
        if (!newStyleHasSameLayoutAffectingAttrs) {
            this.markStyleAffectedDirty();
        }
    }

    private final TextAutoSizeLayoutScopeImpl getFontSizeSearchScope() {
        if (this._textAutoSizeLayoutScope == null) {
            this._textAutoSizeLayoutScope = new TextAutoSizeLayoutScopeImpl();
        }
        TextAutoSizeLayoutScopeImpl textAutoSizeLayoutScopeImpl = this._textAutoSizeLayoutScope;
        Intrinsics.checkNotNull((Object)textAutoSizeLayoutScopeImpl);
        return textAutoSizeLayoutScopeImpl;
    }

    @NotNull
    public final TextLayoutResult getTextLayoutResult() {
        TextLayoutResult textLayoutResult = this.layoutCache;
        if (textLayoutResult == null) {
            throw new IllegalStateException("You must call layoutWithConstraints first");
        }
        return textLayoutResult;
    }

    @Nullable
    public final TextLayoutResult getLayoutOrNull() {
        return this.layoutCache;
    }

    public final boolean layoutWithConstraints-K40F9xA(long constraints, @NotNull LayoutDirection layoutDirection) {
        long finalConstraints;
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        long l = finalConstraints = this.minLines > 1 ? this.useMinLinesConstrainer-Oh53vG4(constraints, layoutDirection) : constraints;
        if (!this.newLayoutWillBeDifferent-VKLhPVY(this.layoutCache, finalConstraints, layoutDirection)) {
            TextLayoutResult textLayoutResult = this.layoutCache;
            Intrinsics.checkNotNull((Object)textLayoutResult);
            if (Constraints.equals-impl0(finalConstraints, textLayoutResult.getLayoutInput().getConstraints-msEJaDk())) {
                return false;
            }
            TextLayoutResult textLayoutResult2 = this.layoutCache;
            Intrinsics.checkNotNull((Object)textLayoutResult2);
            this.layoutCache = this.textLayoutResult-VKLhPVY(layoutDirection, finalConstraints, textLayoutResult2.getMultiParagraph());
            return true;
        }
        if (this.autoSize != null) {
            this.intrinsicsLayoutDirection = layoutDirection;
            long fontSizeBeforeLayout = this.style.getFontSize-XSAIIZE();
            TextAutoSize textAutoSize = this.autoSize;
            Intrinsics.checkNotNull((Object)textAutoSize);
            TextAutoSize $this$layoutWithConstraints_K40F9xA_u24lambda_u242 = textAutoSize;
            boolean bl = false;
            TextAutoSizeLayoutScopeImpl $this$layoutWithConstraints_K40F9xA_u24lambda_u242_u24lambda_u241 = this.getFontSizeSearchScope();
            boolean bl2 = false;
            long autoSizeFontSize = $this$layoutWithConstraints_K40F9xA_u24lambda_u242.getFontSize-Ci0_558($this$layoutWithConstraints_K40F9xA_u24lambda_u242_u24lambda_u241, constraints, this.text);
            if (TextUnit.isEm-impl(autoSizeFontSize)) {
                autoSizeFontSize = MultiParagraphLayoutCacheKt.access$times-NB67dxo(fontSizeBeforeLayout, autoSizeFontSize);
            }
            long optimalFontSize = autoSizeFontSize;
            TextLayoutResult autoSizeLayoutCache = this.getFontSizeSearchScope().getLastLayoutResult();
            if (autoSizeLayoutCache != null && TextUnit.equals-impl0(optimalFontSize, autoSizeLayoutCache.getLayoutInput().getStyle().getFontSize-XSAIIZE()) && TextOverflow.equals-impl0(autoSizeLayoutCache.getLayoutInput().getOverflow-gIe3tQ8(), this.overflow)) {
                this.layoutCache = autoSizeLayoutCache;
                return true;
            }
            this.setStyle(TextStyle.copy-p1EtxEg$default(this.style, 0L, optimalFontSize, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFD, null));
        }
        MultiParagraph multiParagraph = this.layoutText-K40F9xA(finalConstraints, layoutDirection);
        this.layoutCache = this.textLayoutResult-VKLhPVY(layoutDirection, finalConstraints, multiParagraph);
        return true;
    }

    private final long useMinLinesConstrainer-Oh53vG4(long constraints, LayoutDirection layoutDirection) {
        MinLinesConstrainer minLinesConstrainer;
        Density density = this.density;
        Intrinsics.checkNotNull((Object)density);
        MinLinesConstrainer it = minLinesConstrainer = MinLinesConstrainer.Companion.from(this.mMinLinesConstrainer, layoutDirection, this.style, density, this.fontFamilyResolver);
        boolean bl = false;
        this.mMinLinesConstrainer = it;
        MinLinesConstrainer localMin = minLinesConstrainer;
        return localMin.coerceMinLines-Oh53vG4$foundation(constraints, this.minLines);
    }

    /*
     * WARNING - void declaration
     */
    private final TextLayoutResult textLayoutResult-VKLhPVY(LayoutDirection layoutDirection, long finalConstraints, MultiParagraph multiParagraph) {
        void width$iv;
        float layoutWidth = Math.min(multiParagraph.getIntrinsics().getMaxIntrinsicWidth(), multiParagraph.getWidth());
        List list2 = this.placeholders;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Density density = this.density;
        Intrinsics.checkNotNull((Object)density);
        int n = TextDelegateKt.ceilToIntPx(layoutWidth);
        int height$iv = TextDelegateKt.ceilToIntPx(multiParagraph.getHeight());
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        return new TextLayoutResult(new TextLayoutInput(this.text, this.style, list2, this.maxLines, this.softWrap, this.overflow, density, layoutDirection, this.fontFamilyResolver, finalConstraints, null), multiParagraph, ConstraintsKt.constrain-4WqzIAM(finalConstraints, IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL)), null);
    }

    public final int intrinsicHeight(int width, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        int localWidth = this.cachedIntrinsicHeightInputWidth;
        int localHeght = this.cachedIntrinsicHeight;
        if (width == localWidth && localWidth != -1) {
            return localHeght;
        }
        long constraints = ConstraintsKt.Constraints(0, width, 0, Integer.MAX_VALUE);
        long finalConstraints = this.minLines > 1 ? this.useMinLinesConstrainer-Oh53vG4(constraints, layoutDirection) : constraints;
        int result2 = RangesKt.coerceAtLeast((int)TextDelegateKt.ceilToIntPx(this.layoutText-K40F9xA(finalConstraints, layoutDirection).getHeight()), (int)Constraints.getMinHeight-impl(finalConstraints));
        this.cachedIntrinsicHeightInputWidth = width;
        this.cachedIntrinsicHeight = result2;
        return result2;
    }

    public final void update-J2qo7bo(@NotNull AnnotatedString text2, @NotNull TextStyle style, @NotNull FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, @Nullable List<AnnotatedString.Range<Placeholder>> placeholders, @Nullable TextAutoSize autoSize) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.setStyle(style);
        this.fontFamilyResolver = fontFamilyResolver;
        this.overflow = overflow;
        this.softWrap = softWrap;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.placeholders = placeholders;
        this.autoSize = autoSize;
        this.markDirty();
    }

    private final MultiParagraphIntrinsics setLayoutDirection(LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics intrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        MultiParagraphIntrinsics localIntrinsics = this.paragraphIntrinsics;
        if (localIntrinsics == null || layoutDirection != this.intrinsicsLayoutDirection || localIntrinsics.getHasStaleResolvedFonts()) {
            this.intrinsicsLayoutDirection = layoutDirection;
            AnnotatedString annotatedString = this.text;
            TextStyle textStyle = TextStyleKt.resolveDefaults(this.style, layoutDirection);
            Density density = this.density;
            Intrinsics.checkNotNull((Object)density);
            Density density2 = density;
            FontFamily.Resolver resolver = this.fontFamilyResolver;
            List list2 = this.placeholders;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List list3 = list2;
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list3, density2, resolver);
        } else {
            multiParagraphIntrinsics = localIntrinsics;
        }
        this.paragraphIntrinsics = intrinsics = multiParagraphIntrinsics;
        return intrinsics;
    }

    private final MultiParagraph layoutText-K40F9xA(long constraints, LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics localParagraphIntrinsics = this.setLayoutDirection(layoutDirection);
        return new MultiParagraph(localParagraphIntrinsics, LayoutUtilsKt.finalConstraints-tfFHcEY(constraints, this.softWrap, this.overflow, localParagraphIntrinsics.getMaxIntrinsicWidth()), LayoutUtilsKt.finalMaxLines-xdlQI24(this.softWrap, this.overflow, this.maxLines), this.overflow, null);
    }

    private final boolean newLayoutWillBeDifferent-VKLhPVY(TextLayoutResult $this$newLayoutWillBeDifferent_u2dVKLhPVY, long constraints, LayoutDirection layoutDirection) {
        if ($this$newLayoutWillBeDifferent_u2dVKLhPVY == null) {
            return true;
        }
        if ($this$newLayoutWillBeDifferent_u2dVKLhPVY.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts()) {
            return true;
        }
        if (layoutDirection != $this$newLayoutWillBeDifferent_u2dVKLhPVY.getLayoutInput().getLayoutDirection()) {
            return true;
        }
        if (Constraints.equals-impl0(constraints, $this$newLayoutWillBeDifferent_u2dVKLhPVY.getLayoutInput().getConstraints-msEJaDk())) {
            return false;
        }
        if (Constraints.getMaxWidth-impl(constraints) != Constraints.getMaxWidth-impl($this$newLayoutWillBeDifferent_u2dVKLhPVY.getLayoutInput().getConstraints-msEJaDk())) {
            return true;
        }
        if (Constraints.getMinWidth-impl(constraints) != Constraints.getMinWidth-impl($this$newLayoutWillBeDifferent_u2dVKLhPVY.getLayoutInput().getConstraints-msEJaDk())) {
            return true;
        }
        return (float)Constraints.getMaxHeight-impl(constraints) < $this$newLayoutWillBeDifferent_u2dVKLhPVY.getMultiParagraph().getHeight() || $this$newLayoutWillBeDifferent_u2dVKLhPVY.getMultiParagraph().getDidExceedMaxLines();
    }

    private final void markDirty() {
        this.paragraphIntrinsics = null;
        this.layoutCache = null;
        this.cachedIntrinsicHeight = -1;
        this.cachedIntrinsicHeightInputWidth = -1;
        this._textAutoSizeLayoutScope = null;
    }

    private final void markStyleAffectedDirty() {
        this.paragraphIntrinsics = null;
        this.layoutCache = null;
        this.cachedIntrinsicHeight = -1;
        this.cachedIntrinsicHeightInputWidth = -1;
    }

    public final int maxIntrinsicWidth(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return TextDelegateKt.ceilToIntPx(this.setLayoutDirection(layoutDirection).getMaxIntrinsicWidth());
    }

    public final int minIntrinsicWidth(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return TextDelegateKt.ceilToIntPx(this.setLayoutDirection(layoutDirection).getMinIntrinsicWidth());
    }

    public /* synthetic */ MultiParagraphLayoutCache(AnnotatedString text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, int overflow, boolean softWrap, int maxLines, int minLines, List placeholders, TextAutoSize autoSize, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, fontFamilyResolver, overflow, softWrap, maxLines, minLines, placeholders, autoSize);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class TextAutoSizeLayoutScopeImpl
    implements TextAutoSizeLayoutScope {
        @Nullable
        private TextLayoutResult lastLayoutResult;

        @Override
        public float getDensity() {
            Density density = MultiParagraphLayoutCache.this.getDensity$foundation();
            Intrinsics.checkNotNull((Object)density);
            return density.getDensity();
        }

        @Override
        public float getFontScale() {
            Density density = MultiParagraphLayoutCache.this.getDensity$foundation();
            Intrinsics.checkNotNull((Object)density);
            return density.getFontScale();
        }

        @Nullable
        public final TextLayoutResult getLastLayoutResult() {
            return this.lastLayoutResult;
        }

        @Override
        public float toPx--R2X_6o(long $this$toPx_u2d_u2dR2X_6o) {
            if (TextUnit.isEm-impl($this$toPx_u2d_u2dR2X_6o)) {
                if (!(!TextUnit.isEm-impl(MultiParagraphLayoutCache.this.style.getFontSize-XSAIIZE()))) {
                    boolean $i$a$-check-MultiParagraphLayoutCache$TextAutoSizeLayoutScopeImpl$toPx$32 = false;
                    String $i$a$-check-MultiParagraphLayoutCache$TextAutoSizeLayoutScopeImpl$toPx$32 = "InternalAutoSize -> toPx(): Cannot convert Em to Px when style.fontSize is Em\nDeclare the composable's style.fontSize with Sp units instead.";
                    throw new IllegalStateException($i$a$-check-MultiParagraphLayoutCache$TextAutoSizeLayoutScopeImpl$toPx$32.toString());
                }
                if (!(!TextUnit.equals-impl0(MultiParagraphLayoutCache.this.style.getFontSize-XSAIIZE(), TextUnit.Companion.getUnspecified-XSAIIZE()))) {
                    boolean bl = false;
                    String string = "InternalAutoSize -> toPx(): Cannot convert Em to Px when style.fontSize is not set. Please specify a font size.";
                    throw new IllegalStateException(string.toString());
                }
                return this.toPx--R2X_6o(MultiParagraphLayoutCache.this.style.getFontSize-XSAIIZE()) * TextUnit.getValue-impl($this$toPx_u2d_u2dR2X_6o);
            }
            return this.toPx-0680j_4(this.toDp-GaN1DYA($this$toPx_u2d_u2dR2X_6o));
        }
    }
}

