/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.PlatformTextInputMethodRequest;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import androidx.compose.ui.text.input.TextFieldValue;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkikoPlatformTextInputMethodRequest
implements PlatformTextInputMethodRequest {
    @NotNull
    private final Function0<TextFieldValue> value;
    @NotNull
    private final TextEditorState state;
    @NotNull
    private final ImeOptions imeOptions;
    @NotNull
    private final Function1<List<? extends EditCommand>, Unit> onEditCommand;
    @Nullable
    private final Function1<ImeAction, Unit> onImeAction;
    @NotNull
    private final Flow<TextFieldValue> outputValue;
    @NotNull
    private final Flow<TextLayoutResult> textLayoutResult;
    @NotNull
    private final Flow<Rect> focusedRectInRoot;
    @NotNull
    private final Flow<Rect> textFieldRectInRoot;
    @NotNull
    private final Flow<Rect> textClippingRectInRoot;
    @NotNull
    private final Function1<Function1<? super TextEditingScope, Unit>, Unit> editText;
    public static final int $stable = 8;

    public SkikoPlatformTextInputMethodRequest(@NotNull Function0<TextFieldValue> value2, @NotNull TextEditorState state2, @NotNull ImeOptions imeOptions, @NotNull Function1<? super List<? extends EditCommand>, Unit> onEditCommand, @Nullable Function1<? super ImeAction, Unit> onImeAction, @NotNull Flow<TextFieldValue> outputValue, @NotNull Flow<TextLayoutResult> textLayoutResult, @NotNull Flow<Rect> focusedRectInRoot, @NotNull Flow<Rect> textFieldRectInRoot, @NotNull Flow<Rect> textClippingRectInRoot, @NotNull Function1<? super Function1<? super TextEditingScope, Unit>, Unit> editText) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkNotNullParameter(outputValue, (String)"outputValue");
        Intrinsics.checkNotNullParameter(textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter(focusedRectInRoot, (String)"focusedRectInRoot");
        Intrinsics.checkNotNullParameter(textFieldRectInRoot, (String)"textFieldRectInRoot");
        Intrinsics.checkNotNullParameter(textClippingRectInRoot, (String)"textClippingRectInRoot");
        Intrinsics.checkNotNullParameter(editText, (String)"editText");
        this.value = value2;
        this.state = state2;
        this.imeOptions = imeOptions;
        this.onEditCommand = onEditCommand;
        this.onImeAction = onImeAction;
        this.outputValue = outputValue;
        this.textLayoutResult = textLayoutResult;
        this.focusedRectInRoot = focusedRectInRoot;
        this.textFieldRectInRoot = textFieldRectInRoot;
        this.textClippingRectInRoot = textClippingRectInRoot;
        this.editText = editText;
    }

    @Override
    @NotNull
    public TextEditorState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public ImeOptions getImeOptions() {
        return this.imeOptions;
    }

    @Override
    @NotNull
    public Flow<Rect> getFocusedRectInRoot() {
        return this.focusedRectInRoot;
    }

    @Override
    @NotNull
    public Function1<Function1<? super TextEditingScope, Unit>, Unit> getEditText() {
        return this.editText;
    }

    @NotNull
    public String toString() {
        return "SkikoPlatformTextInputMethodRequest(value=" + this.value + ", state=" + this.state + ", imeOptions=" + this.imeOptions + ", onEditCommand=" + this.onEditCommand + ", onImeAction=" + this.onImeAction + ", outputValue=" + this.outputValue + ", textLayoutResult=" + this.textLayoutResult + ", focusedRectInRoot=" + this.focusedRectInRoot + ", textFieldRectInRoot=" + this.textFieldRectInRoot + ", textClippingRectInRoot=" + this.textClippingRectInRoot + ", editText=" + this.editText + ")";
    }

    public int hashCode() {
        int result2 = this.value.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        result2 = result2 * 31 + this.imeOptions.hashCode();
        result2 = result2 * 31 + this.onEditCommand.hashCode();
        result2 = result2 * 31 + (this.onImeAction == null ? 0 : this.onImeAction.hashCode());
        result2 = result2 * 31 + this.outputValue.hashCode();
        result2 = result2 * 31 + this.textLayoutResult.hashCode();
        result2 = result2 * 31 + this.focusedRectInRoot.hashCode();
        result2 = result2 * 31 + this.textFieldRectInRoot.hashCode();
        result2 = result2 * 31 + this.textClippingRectInRoot.hashCode();
        result2 = result2 * 31 + this.editText.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SkikoPlatformTextInputMethodRequest)) {
            return false;
        }
        SkikoPlatformTextInputMethodRequest skikoPlatformTextInputMethodRequest = (SkikoPlatformTextInputMethodRequest)other;
        if (!Intrinsics.areEqual(this.value, skikoPlatformTextInputMethodRequest.value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)skikoPlatformTextInputMethodRequest.state)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.imeOptions, (Object)skikoPlatformTextInputMethodRequest.imeOptions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onEditCommand, skikoPlatformTextInputMethodRequest.onEditCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onImeAction, skikoPlatformTextInputMethodRequest.onImeAction)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.outputValue, skikoPlatformTextInputMethodRequest.outputValue)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textLayoutResult, skikoPlatformTextInputMethodRequest.textLayoutResult)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.focusedRectInRoot, skikoPlatformTextInputMethodRequest.focusedRectInRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textFieldRectInRoot, skikoPlatformTextInputMethodRequest.textFieldRectInRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textClippingRectInRoot, skikoPlatformTextInputMethodRequest.textClippingRectInRoot)) {
            return false;
        }
        return Intrinsics.areEqual(this.editText, skikoPlatformTextInputMethodRequest.editText);
    }
}

