/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.CoreTextFieldKt;
import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.TextFieldDelegate;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.ui.autofill.ContentDataType;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import androidx.compose.ui.text.input.TransformedText;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nCoreTextFieldSemanticsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTextFieldSemanticsModifier.kt\nandroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1#2:338\n*E\n"})
public final class CoreTextFieldSemanticsModifierNode
extends DelegatingNode
implements SemanticsModifierNode {
    @NotNull
    private TransformedText transformedText;
    @NotNull
    private TextFieldValue value;
    @NotNull
    private LegacyTextFieldState state;
    private boolean readOnly;
    private boolean enabled;
    private boolean isPassword;
    @NotNull
    private OffsetMapping offsetMapping;
    @NotNull
    private TextFieldSelectionManager manager;
    @NotNull
    private ImeOptions imeOptions;
    @NotNull
    private FocusRequester focusRequester;
    public static final int $stable = 8;

    public CoreTextFieldSemanticsModifierNode(@NotNull TransformedText transformedText, @NotNull TextFieldValue value2, @NotNull LegacyTextFieldState state2, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager2, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        this.transformedText = transformedText;
        this.value = value2;
        this.state = state2;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.isPassword = isPassword;
        this.offsetMapping = offsetMapping;
        this.manager = manager2;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        this.manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode._init_$lambda$0(this)));
    }

    @Override
    public boolean getShouldMergeDescendantSemantics() {
        return true;
    }

    @Override
    public void applySemantics(@NotNull SemanticsPropertyReceiver $this$applySemantics) {
        Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
        SemanticsPropertiesKt.setInputText($this$applySemantics, this.value.getAnnotatedString());
        SemanticsPropertiesKt.setEditableText($this$applySemantics, this.transformedText.getText());
        SemanticsPropertiesKt.setTextSelectionRange-FDrldGo($this$applySemantics, this.value.getSelection-d9O1mEE());
        SemanticsPropertiesKt.setContentDataType($this$applySemantics, ContentDataType.Companion.getText());
        SemanticsPropertiesKt.onAutofillText$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$1(this, arg_0), 1, null);
        if (!this.enabled) {
            SemanticsPropertiesKt.disabled($this$applySemantics);
        }
        if (this.isPassword) {
            SemanticsPropertiesKt.password($this$applySemantics);
        }
        boolean editable = this.enabled && !this.readOnly;
        SemanticsPropertiesKt.setEditable($this$applySemantics, editable);
        SemanticsPropertiesKt.getTextLayoutResult$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$2(this, arg_0), 1, null);
        if (editable) {
            SemanticsPropertiesKt.setText$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$3(this, arg_0), 1, null);
            SemanticsPropertiesKt.insertTextAtCursor$default($this$applySemantics, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$6(this, $this$applySemantics, arg_0), 1, null);
        }
        SemanticsPropertiesKt.setSelection$default($this$applySemantics, null, (arg_0, arg_1, arg_2) -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$7(this, arg_0, arg_1, arg_2), 1, null);
        SemanticsPropertiesKt.onImeAction-9UiTYpY$default($this$applySemantics, this.imeOptions.getImeAction-eUduSuo(), null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$8(this), 2, null);
        SemanticsPropertiesKt.onClick$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$9(this), 1, null);
        SemanticsPropertiesKt.onLongClick$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$10(this), 1, null);
        if (!TextRange.getCollapsed-impl(this.value.getSelection-d9O1mEE()) && !this.isPassword) {
            SemanticsPropertiesKt.copyText$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$11(this), 1, null);
            if (this.enabled && !this.readOnly) {
                SemanticsPropertiesKt.cutText$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$12(this), 1, null);
            }
        }
        if (this.enabled && !this.readOnly) {
            SemanticsPropertiesKt.pasteText$default($this$applySemantics, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$13(this), 1, null);
        }
    }

    public final void updateNodeSemantics(@NotNull TransformedText transformedText, @NotNull TextFieldValue value2, @NotNull LegacyTextFieldState state2, boolean readOnly, boolean enabled, boolean isPassword, @NotNull OffsetMapping offsetMapping, @NotNull TextFieldSelectionManager manager2, @NotNull ImeOptions imeOptions, @NotNull FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"transformedText");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"offsetMapping");
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"focusRequester");
        boolean previousEditable = this.enabled && !this.readOnly;
        boolean previousEnabled = this.enabled;
        boolean previousIsPassword = this.isPassword;
        ImeOptions previousImeOptions = this.imeOptions;
        TextFieldSelectionManager previousManager = this.manager;
        boolean editable = enabled && !readOnly;
        this.transformedText = transformedText;
        this.value = value2;
        this.state = state2;
        this.readOnly = readOnly;
        this.enabled = enabled;
        this.offsetMapping = offsetMapping;
        this.manager = manager2;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        if (enabled != previousEnabled || editable != previousEditable || !Intrinsics.areEqual((Object)imeOptions, (Object)previousImeOptions) || isPassword != previousIsPassword || !TextRange.getCollapsed-impl(value2.getSelection-d9O1mEE())) {
            SemanticsModifierNodeKt.invalidateSemantics(this);
        }
        if (!Intrinsics.areEqual((Object)manager2, (Object)previousManager)) {
            manager2.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode.updateNodeSemantics$lambda$14(this)));
        }
    }

    private final void handleTextUpdateFromSemantics(LegacyTextFieldState state2, String text2, boolean readOnly, boolean enabled) {
        if (readOnly || !enabled) {
            return;
        }
        TextInputSession textInputSession2 = state2.getInputSession();
        if (textInputSession2 != null) {
            TextInputSession session2 = textInputSession2;
            boolean bl = false;
            Object[] objectArray = new EditCommand[]{new DeleteAllCommand(), new CommitTextCommand(text2, 1)};
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), state2.getProcessor(), state2.getOnValueChange(), session2);
        } else {
            CoreTextFieldSemanticsModifierNode $this$handleTextUpdateFromSemantics_u24lambda_u2416 = this;
            boolean bl = false;
            state2.getOnValueChange().invoke((Object)new TextFieldValue(text2, TextRangeKt.TextRange(text2.length()), null, 4, null));
        }
    }

    private static final Unit _init_$lambda$0(CoreTextFieldSemanticsModifierNode this$0) {
        DelegatableNodeKt.requestAutofill(this$0);
        return Unit.INSTANCE;
    }

    private static final boolean applySemantics$lambda$1(CoreTextFieldSemanticsModifierNode this$0, AnnotatedString text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this$0.state.setJustAutofilled(true);
        this$0.state.setAutofillHighlightOn(true);
        this$0.handleTextUpdateFromSemantics(this$0.state, text2.getText(), this$0.readOnly, this$0.enabled);
        return true;
    }

    private static final boolean applySemantics$lambda$2(CoreTextFieldSemanticsModifierNode this$0, List it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.state.getLayoutResult() != null) {
            TextLayoutResultProxy textLayoutResultProxy = this$0.state.getLayoutResult();
            Intrinsics.checkNotNull((Object)textLayoutResultProxy);
            it.add(textLayoutResultProxy.getValue());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean applySemantics$lambda$3(CoreTextFieldSemanticsModifierNode this$0, AnnotatedString text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this$0.handleTextUpdateFromSemantics(this$0.state, text2.getText(), this$0.readOnly, this$0.enabled);
        return true;
    }

    private static final boolean applySemantics$lambda$6(CoreTextFieldSemanticsModifierNode this$0, SemanticsPropertyReceiver $this_applySemantics, AnnotatedString text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (this$0.readOnly || !this$0.enabled) {
            return false;
        }
        TextInputSession textInputSession2 = this$0.state.getInputSession();
        if (textInputSession2 != null) {
            TextInputSession session2 = textInputSession2;
            boolean bl = false;
            Object[] objectArray = new EditCommand[]{new FinishComposingTextCommand(), new CommitTextCommand(text2, 1)};
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), this$0.state.getProcessor(), this$0.state.getOnValueChange(), session2);
        } else {
            SemanticsPropertyReceiver $this$applySemantics_u24lambda_u246_u24lambda_u245 = $this_applySemantics;
            boolean bl = false;
            String string = this$0.value.getText();
            int n = TextRange.getStart-impl(this$0.value.getSelection-d9O1mEE());
            int n2 = TextRange.getEnd-impl(this$0.value.getSelection-d9O1mEE());
            String newText = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)text2)).toString();
            long newCursor = TextRangeKt.TextRange(TextRange.getStart-impl(this$0.value.getSelection-d9O1mEE()) + text2.length());
            this$0.state.getOnValueChange().invoke((Object)new TextFieldValue(newText, newCursor, null, 4, null));
        }
        return true;
    }

    private static final boolean applySemantics$lambda$7(CoreTextFieldSemanticsModifierNode this$0, int selectionStart, int selectionEnd, boolean relativeToOriginalText) {
        boolean bl;
        int end;
        int start2 = relativeToOriginalText ? selectionStart : this$0.offsetMapping.transformedToOriginal(selectionStart);
        int n = end = relativeToOriginalText ? selectionEnd : this$0.offsetMapping.transformedToOriginal(selectionEnd);
        if (!this$0.enabled) {
            bl = false;
        } else if (start2 == TextRange.getStart-impl(this$0.value.getSelection-d9O1mEE()) && end == TextRange.getEnd-impl(this$0.value.getSelection-d9O1mEE())) {
            bl = false;
        } else if (Math.min(start2, end) >= 0 && Math.max(start2, end) <= this$0.value.getAnnotatedString().length()) {
            if (relativeToOriginalText || start2 == end) {
                this$0.manager.exitSelectionMode$foundation();
            } else {
                TextFieldSelectionManager.enterSelectionMode$foundation$default(this$0.manager, false, 1, null);
            }
            this$0.state.getOnValueChange().invoke((Object)new TextFieldValue(this$0.value.getAnnotatedString(), TextRangeKt.TextRange(start2, end), null, 4, null));
            bl = true;
        } else {
            this$0.manager.exitSelectionMode$foundation();
            bl = false;
        }
        return bl;
    }

    private static final boolean applySemantics$lambda$8(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.state.getOnImeActionPerformed().invoke((Object)ImeAction.box-impl(this$0.imeOptions.getImeAction-eUduSuo()));
        return true;
    }

    private static final boolean applySemantics$lambda$9(CoreTextFieldSemanticsModifierNode this$0) {
        CoreTextFieldKt.requestFocusAndShowKeyboardIfNeeded(this$0.state, this$0.focusRequester, !this$0.readOnly);
        return true;
    }

    private static final boolean applySemantics$lambda$10(CoreTextFieldSemanticsModifierNode this$0) {
        TextFieldSelectionManager.enterSelectionMode$foundation$default(this$0.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$11(CoreTextFieldSemanticsModifierNode this$0) {
        TextFieldSelectionManager.copy$foundation$default(this$0.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$12(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.manager.cut$foundation();
        return true;
    }

    private static final boolean applySemantics$lambda$13(CoreTextFieldSemanticsModifierNode this$0) {
        this$0.manager.paste$foundation();
        return true;
    }

    private static final Unit updateNodeSemantics$lambda$14(CoreTextFieldSemanticsModifierNode this$0) {
        DelegatableNodeKt.requestAutofill(this$0);
        return Unit.INSTANCE;
    }
}

