/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.ValidatingOffsetMappingKt;
import androidx.compose.ui.text.input.OffsetMapping;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

final class ValidatingOffsetMapping
implements OffsetMapping {
    @NotNull
    private final OffsetMapping delegate;
    private final int originalLength;
    private final int transformedLength;

    public ValidatingOffsetMapping(@NotNull OffsetMapping delegate, int originalLength, int transformedLength) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.originalLength = originalLength;
        this.transformedLength = transformedLength;
    }

    @Override
    public int originalToTransformed(int offset) {
        int n;
        int transformedOffset = n = this.delegate.originalToTransformed(offset);
        boolean bl = false;
        boolean bl2 = 0 <= offset ? offset <= this.originalLength : false;
        if (bl2) {
            ValidatingOffsetMappingKt.access$validateOriginalToTransformed(transformedOffset, this.transformedLength, offset);
        }
        return n;
    }

    @Override
    public int transformedToOriginal(int offset) {
        int n;
        int originalOffset = n = this.delegate.transformedToOriginal(offset);
        boolean bl = false;
        boolean bl2 = 0 <= offset ? offset <= this.transformedLength : false;
        if (bl2) {
            ValidatingOffsetMappingKt.access$validateTransformedToOriginal(originalOffset, this.originalLength, offset);
        }
        return n;
    }
}

