/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TextLayoutHelperKt {
    public static final boolean canReuse-7_7YC6M(@NotNull TextLayoutResult $this$canReuse_u2d7_7YC6M, @NotNull AnnotatedString text2, @NotNull TextStyle style, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders, int maxLines, boolean softWrap, int overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull FontFamily.Resolver fontFamilyResolver, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$canReuse_u2d7_7YC6M, (String)"$this$canReuse");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        TextLayoutInput layoutInput = $this$canReuse_u2d7_7YC6M.getLayoutInput();
        if ($this$canReuse_u2d7_7YC6M.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts()) {
            return false;
        }
        if (!(Intrinsics.areEqual((Object)layoutInput.getText(), (Object)text2) && layoutInput.getStyle().hasSameLayoutAffectingAttributes(style) && Intrinsics.areEqual(layoutInput.getPlaceholders(), placeholders) && layoutInput.getMaxLines() == maxLines && layoutInput.getSoftWrap() == softWrap && TextOverflow.equals-impl0(layoutInput.getOverflow-gIe3tQ8(), overflow) && Intrinsics.areEqual((Object)layoutInput.getDensity(), (Object)density) && layoutInput.getLayoutDirection() == layoutDirection && Intrinsics.areEqual((Object)layoutInput.getFontFamilyResolver(), (Object)fontFamilyResolver))) {
            return false;
        }
        if (Constraints.getMinWidth-impl(constraints) != Constraints.getMinWidth-impl(layoutInput.getConstraints-msEJaDk())) {
            return false;
        }
        if (!softWrap && !TextOverflow.equals-impl0(overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8())) {
            return true;
        }
        return Constraints.getMaxWidth-impl(constraints) == Constraints.getMaxWidth-impl(layoutInput.getConstraints-msEJaDk()) && Constraints.getMaxHeight-impl(constraints) == Constraints.getMaxHeight-impl(layoutInput.getConstraints-msEJaDk());
    }

    public static final boolean isPositionInsideSelection-uaM50fQ(@NotNull TextLayoutResult $this$isPositionInsideSelection_u2duaM50fQ, long position, @Nullable TextRange selectionRange) {
        Intrinsics.checkNotNullParameter((Object)$this$isPositionInsideSelection_u2duaM50fQ, (String)"$this$isPositionInsideSelection");
        if (selectionRange == null || TextRange.getCollapsed-impl(selectionRange.unbox-impl())) {
            return false;
        }
        int offset = $this$isPositionInsideSelection_u2duaM50fQ.getOffsetForPosition-k-4lQ0M(position);
        return TextLayoutHelperKt.isPositionInsideSelection_uaM50fQ$isOffsetSelectedAndContainsPosition(selectionRange, $this$isPositionInsideSelection_u2duaM50fQ, position, offset) || TextLayoutHelperKt.isPositionInsideSelection_uaM50fQ$isOffsetSelectedAndContainsPosition(selectionRange, $this$isPositionInsideSelection_u2duaM50fQ, position, offset - 1);
    }

    public static final float getLineHeight(@NotNull TextLayoutResult $this$getLineHeight, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineHeight, (String)"<this>");
        if (offset < 0 || ((CharSequence)$this$getLineHeight.getLayoutInput().getText()).length() == 0) {
            return 0.0f;
        }
        int line = Math.min($this$getLineHeight.getMultiParagraph().getLineForOffset(offset), Math.min($this$getLineHeight.getMultiParagraph().getMaxLines() - 1, $this$getLineHeight.getMultiParagraph().getLineCount() - 1));
        int lineEnd = MultiParagraph.getLineEnd$default($this$getLineHeight.getMultiParagraph(), line, false, 2, null);
        if (offset > lineEnd) {
            return 0.0f;
        }
        return $this$getLineHeight.getMultiParagraph().getLineHeight(line);
    }

    private static final boolean isPositionInsideSelection_uaM50fQ$isOffsetSelectedAndContainsPosition(TextRange $selectionRange, TextLayoutResult $this_isPositionInsideSelection, long $position, int offset) {
        return TextRange.contains-impl($selectionRange.unbox-impl(), offset) && $this_isPositionInsideSelection.getBoundingBox(offset).contains-k-4lQ0M($position);
    }
}

