/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.saveable.ListSaverKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.text.TextRange;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextFieldScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldScroll.kt\nandroidx/compose/foundation/text/TextFieldScrollerPosition\n+ 2 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 3 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 4 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,405:1\n79#2:406\n112#2,2:407\n79#2:409\n112#2,2:410\n78#3:412\n107#3,2:413\n85#4:415\n113#4,2:416\n*S KotlinDebug\n*F\n+ 1 TextFieldScroll.kt\nandroidx/compose/foundation/text/TextFieldScrollerPosition\n*L\n286#1:406\n286#1:407,2\n292#1:409\n292#1:410,2\n296#1:412\n296#1:413,2\n311#1:415\n311#1:416,2\n*E\n"})
public final class TextFieldScrollerPosition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableFloatState offset$delegate;
    @NotNull
    private final MutableFloatState maximum$delegate;
    @NotNull
    private final MutableIntState viewportSize$delegate;
    @NotNull
    private Rect previousCursorRect;
    private long previousSelection;
    @NotNull
    private final MutableState orientation$delegate;
    @NotNull
    private static final Saver<TextFieldScrollerPosition, Object> Saver = ListSaverKt.listSaver(TextFieldScrollerPosition::Saver$lambda$0, TextFieldScrollerPosition::Saver$lambda$1);

    public TextFieldScrollerPosition(@NotNull Orientation initialOrientation, float initial) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialOrientation), (String)"initialOrientation");
        this.offset$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(initial);
        this.maximum$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(0.0f);
        this.viewportSize$delegate = SnapshotIntStateKt.mutableIntStateOf(0);
        this.previousCursorRect = Rect.Companion.getZero();
        this.previousSelection = TextRange.Companion.getZero-d9O1mEE();
        this.orientation$delegate = SnapshotStateKt.mutableStateOf(initialOrientation, SnapshotStateKt.structuralEqualityPolicy());
    }

    public /* synthetic */ TextFieldScrollerPosition(Orientation orientation, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        this(orientation, f);
    }

    public TextFieldScrollerPosition() {
        this(Orientation.Vertical, 0.0f, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final float getOffset() {
        void $this$getValue$iv;
        FloatState floatState = this.offset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setOffset(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.offset$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    /*
     * WARNING - void declaration
     */
    public final float getMaximum() {
        void $this$getValue$iv;
        FloatState floatState = this.maximum$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaximum(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.maximum$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    /*
     * WARNING - void declaration
     */
    public final int getViewportSize() {
        void $this$getValue$iv;
        IntState intState = this.viewportSize$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setViewportSize(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.viewportSize$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    public final void setPreviousSelection-5zc-tL8(long l) {
        this.previousSelection = l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Orientation getOrientation() {
        void $this$getValue$iv;
        State state2 = this.orientation$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Orientation)((Object)$this$getValue$iv.getValue());
    }

    public final void update(@NotNull Orientation orientation, @NotNull Rect cursorRect, int containerSize, int textFieldSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)cursorRect, (String)"cursorRect");
        float difference = textFieldSize - containerSize;
        this.setMaximum(difference);
        if (!(cursorRect.getLeft() == this.previousCursorRect.getLeft()) || !(cursorRect.getTop() == this.previousCursorRect.getTop())) {
            boolean vertical = orientation == Orientation.Vertical;
            float cursorStart = vertical ? cursorRect.getTop() : cursorRect.getLeft();
            float cursorEnd = vertical ? cursorRect.getBottom() : cursorRect.getRight();
            this.coerceOffset$foundation(cursorStart, cursorEnd, containerSize);
            this.previousCursorRect = cursorRect;
        }
        this.setOffset(RangesKt.coerceIn((float)this.getOffset(), (float)0.0f, (float)difference));
        this.setViewportSize(containerSize);
    }

    public final void coerceOffset$foundation(float cursorStart, float cursorEnd, int containerSize) {
        float startVisibleBound = this.getOffset();
        float endVisibleBound = startVisibleBound + (float)containerSize;
        float offsetDifference = cursorEnd > endVisibleBound ? cursorEnd - endVisibleBound : (cursorStart < startVisibleBound && cursorEnd - cursorStart > (float)containerSize ? cursorEnd - endVisibleBound : (cursorStart < startVisibleBound && cursorEnd - cursorStart <= (float)containerSize ? cursorStart - startVisibleBound : 0.0f));
        this.setOffset(this.getOffset() + offsetDifference);
    }

    public final int getOffsetToFollow-5zc-tL8(long selection) {
        return TextRange.getStart-impl(selection) != TextRange.getStart-impl(this.previousSelection) ? TextRange.getStart-impl(selection) : (TextRange.getEnd-impl(selection) != TextRange.getEnd-impl(this.previousSelection) ? TextRange.getEnd-impl(selection) : TextRange.getMin-impl(selection));
    }

    private static final List Saver$lambda$0(SaverScope $this$listSaver, TextFieldScrollerPosition it) {
        Intrinsics.checkNotNullParameter((Object)$this$listSaver, (String)"$this$listSaver");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{Float.valueOf(it.getOffset()), it.getOrientation() == Orientation.Vertical};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final TextFieldScrollerPosition Saver$lambda$1(List restored) {
        Intrinsics.checkNotNullParameter((Object)restored, (String)"restored");
        Object e = restored.get(1);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Boolean");
        Orientation orientation = (Boolean)e != false ? Orientation.Vertical : Orientation.Horizontal;
        Object e2 = restored.get(0);
        Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Float");
        return new TextFieldScrollerPosition(orientation, ((Float)e2).floatValue());
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<TextFieldScrollerPosition, Object> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

